/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.jms;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.JavaConfig;
import com.iplanet.ias.config.serverbeans.JmsService;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.instance.ServerManager;
import com.iplanet.ias.jms.IASJmsUtil;
import com.iplanet.ias.server.ServerContext;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.logging.LogDomains;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import java.io.File;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmsProviderLifecycle
extends ServerLifecycleImpl {
    private ConfigContext ctx = null;
    private JmsService jmsService_ = null;
    private static JMSAdmin jmsAdmin_ = null;
    private static boolean onShutdown = false;
    private boolean startedByMe_ = false;
    private boolean autoShutdown_ = true;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jms");
    private static boolean debug = true;

    public void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
        block19: {
            try {
                boolean bl;
                String string;
                Object object;
                ElementProperty[] elementPropertyArray;
                String string2;
                String[] stringArray;
                String string3;
                jmsAdmin_ = null;
                this.ctx = serverContext.getConfigContext();
                JavaConfig javaConfig = ServerBeansFactory.getServerBean(this.ctx).getJavaConfig();
                String string4 = javaConfig.getJavaHome();
                this.jmsService_ = ServerBeansFactory.getServerBean(this.ctx).getJmsService();
                if (this.jmsService_ == null || !this.jmsService_.isEnabled()) break block19;
                String string5 = this.jmsService_.getPort();
                String string6 = this.jmsService_.getAdminUserName();
                String string7 = this.jmsService_.getAdminPassword();
                Vector<String> vector = new Vector<String>();
                if (string4 != null) {
                    vector.add("-javahome");
                    vector.add(string4);
                }
                if ((string3 = this.jmsService_.getStartArgs()) != null) {
                    stringArray = new StringTokenizer(string3, " ");
                    while (stringArray.hasMoreTokens()) {
                        string2 = stringArray.nextToken();
                        vector.add(string2);
                    }
                }
                stringArray = vector.toArray(new String[0]);
                string2 = null;
                long l = 30000L;
                string2 = this.jmsService_.getInitTimeoutInSeconds();
                if (string2 != null) {
                    l = Integer.parseInt(string2) * 1000;
                }
                if ((elementPropertyArray = this.jmsService_.getElementProperty()) != null) {
                    for (int i = 0; i < elementPropertyArray.length; ++i) {
                        object = elementPropertyArray[i];
                        string = ((ElementProperty)object).getName();
                        if (!string.equals("auto-shutdown")) continue;
                        this.autoShutdown_ = Boolean.valueOf(((ElementProperty)object).getValue());
                    }
                }
                String string8 = null;
                string8 = System.getProperty("com.sun.aas.imqBin");
                if (string8 == null) {
                    object = File.separator + ".." + File.separator + ".." + File.separator + "imq" + File.separator + "bin";
                    string8 = serverContext.getInstallRoot() + (String)object;
                }
                object = serverContext.getInstanceName();
                string = ServerManager.instance().getDomainName();
                String string9 = IASJmsUtil.getBrokerInstanceName(string, (String)object, this.jmsService_);
                String string10 = InetAddress.getLocalHost().getHostName();
                String string11 = string10 + (string5 == null ? "" : ":" + string5);
                jmsAdmin_ = string6 == null ? IASJmsUtil.getJMSAdminFactory().getJMSAdmin(string11) : IASJmsUtil.getJMSAdminFactory().getJMSAdmin(string11, string6, string7);
                try {
                    jmsAdmin_.pingProvider();
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (bl) {
                    _logger.fine("Broker is already running. Trying to attach.");
                    String string12 = null;
                    try {
                        string12 = this.attachToJmsProvider();
                    }
                    catch (Exception exception) {
                        _logger.log(Level.INFO, "jms.broker_attach_failed");
                        _logger.log(Level.INFO, "jms.broker_log_location", string9);
                        throw new ServerLifecycleException(exception.getMessage(), exception);
                    }
                    if (string12.equals(string9)) {
                        this.startedByMe_ = true;
                        _logger.log(Level.INFO, "jms.broker_found", string9);
                        break block19;
                    }
                    this.startedByMe_ = false;
                    Object[] objectArray = new Object[]{string12, string5};
                    _logger.log(Level.SEVERE, "jms.broker_already_up", objectArray);
                    throw new ServerLifecycleException("JmsProviderLifecycle error.");
                }
                _logger.fine("Starting JMS broker : imq-home=" + string8 + ", initTimeout=" + l + ", stargArgs=" + string3 + ", instanceName=" + string9);
                try {
                    jmsAdmin_.startProvider(string8, stringArray, string9);
                }
                catch (Exception exception) {
                    _logger.log(Level.INFO, "jms.broker_exec_failed");
                    _logger.log(Level.INFO, "jms.broker_log_location", string9);
                    throw new ServerLifecycleException(exception.getMessage(), exception);
                }
                try {
                    this.waitForJmsProvider(l);
                }
                catch (Exception exception) {
                    _logger.log(Level.INFO, "jms.broker_ping_failed", Long.toString(l));
                    _logger.log(Level.INFO, "jms.broker_log_location", string9);
                    throw new ServerLifecycleException(exception.getMessage(), exception);
                }
                this.startedByMe_ = true;
                Object[] objectArray = new Object[]{string9, string8};
                _logger.log(Level.INFO, "jms.broker_started", objectArray);
            }
            catch (Exception exception) {
                this.jmsService_ = null;
                _logger.log(Level.SEVERE, "jms.broker_startup_failed");
                throw new ServerLifecycleException(exception.getMessage(), exception);
            }
        }
    }

    private String attachToJmsProvider() throws Exception {
        jmsAdmin_.connectToProvider();
        String string = jmsAdmin_.getProviderInstanceName();
        jmsAdmin_.disconnectFromProvider();
        return string;
    }

    private void waitForJmsProvider(long l) throws Exception {
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        boolean bl2 = false;
        while (!bl2) {
            try {
                jmsAdmin_.pingProvider();
                bl = true;
                bl2 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (System.currentTimeMillis() - l2 >= l) {
                bl2 = true;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
        }
        if (!bl) {
            jmsAdmin_.pingProvider();
        }
    }

    public static JMSAdmin getJMSAdmin() {
        return jmsAdmin_;
    }

    public static boolean isShutdown() {
        return onShutdown;
    }

    public boolean isNOJMS() {
        return false;
    }

    public void onStartup(ServerContext serverContext) throws ServerLifecycleException {
    }

    public void onShutdown() throws ServerLifecycleException {
        onShutdown = true;
    }

    public void onTermination() throws ServerLifecycleException {
        onShutdown = true;
        try {
            if (!this.autoShutdown_ || this.jmsService_ == null || !this.jmsService_.isEnabled()) {
                return;
            }
            if (jmsAdmin_ == null || !this.startedByMe_) {
                return;
            }
            _logger.log(Level.INFO, "jms.broker_shutting_down");
            jmsAdmin_.connectToProvider();
        }
        catch (Exception exception) {
            throw new ServerLifecycleException(exception.getMessage(), exception);
        }
        try {
            jmsAdmin_.shutdownProvider();
            _logger.log(Level.INFO, "jms.broker_shutdown_complete");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

