/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.admin.audit.ASAuditUtil;
import com.iplanet.ias.admin.common.InitConfFileBean;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.HttpListener;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.IiopListener;
import com.iplanet.ias.config.serverbeans.IiopService;
import com.iplanet.ias.config.serverbeans.JmsService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.installer.core.ServerConfig;
import com.iplanet.ias.installer.core.installConfig;
import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.instance.InstanceDefinition;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.InstanceFolderFilter;
import com.iplanet.ias.instance.Localizer;
import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.license.IASLicenseException;
import com.iplanet.ias.util.ExecException;
import com.iplanet.ias.util.ProcessExecutor;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerManager {
    public static final String INSTALL_ROOT = System.getProperty("com.sun.aas.installRoot");
    public static final String INSTANCE_CFG_ROOT = System.getProperty("com.sun.aas.instanceRoot");
    public static final String DOC_DIR_NAME = "docroot";
    public static final String ADMINSERVER_ID = "admin-server";
    private static final ServerManager SHARED_INSTANCE = new ServerManager();
    private static Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");

    private ServerManager() {
    }

    public static ServerManager instance() {
        return SHARED_INSTANCE;
    }

    public boolean instanceExists(String string) {
        boolean bl = false;
        if (!StringUtils.ok((String)string)) {
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.NULL_INSTANCE_NAME));
        }
        String[] stringArray = this.getInstanceNames(false);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!StringUtils.ok((String)string2) || !string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String[] getInstanceNames(boolean bl) {
        String[] stringArray = null;
        InstanceFolderFilter instanceFolderFilter = new InstanceFolderFilter(bl);
        File file = new File(INSTANCE_CFG_ROOT);
        File[] fileArray = file.listFiles(instanceFolderFilter);
        stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getName();
            sLogger.log(Level.FINE, "general.print_instance_name", stringArray[i]);
        }
        return stringArray;
    }

    public int getNumInstances(boolean bl) {
        return this.getInstanceNames(bl).length;
    }

    public void createServerInstance(InstanceDefinition instanceDefinition) throws IOException, IASLicenseException, ConfigException {
        boolean bl = false;
        String string = null;
        if (instanceDefinition == null) {
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.NULL_INSTANCE));
        }
        string = instanceDefinition.getID();
        if (this.instanceExists(string)) {
            throw new RuntimeException(Localizer.getValue(ExceptionType.INSTANCE_EXISTS, string));
        }
        if (!NetUtils.isPortFree(instanceDefinition.getPort())) {
            throw new RuntimeException(Localizer.getValue(ExceptionType.PORT_IN_USE, instanceDefinition.getPort()));
        }
        if (this.portTakenByHTTP(instanceDefinition.getPort()) || this.portTakenByORB(instanceDefinition.getPort()) || this.portTakenByJMS(instanceDefinition.getPort())) {
            throw new RuntimeException(Localizer.getValue(ExceptionType.PORT_TAKEN));
        }
        if (string.equals(ADMINSERVER_ID)) {
            throw new RuntimeException(Localizer.getValue(ExceptionType.CANT_CREATE_ADMIN));
        }
        String string2 = instanceDefinition.getAdminJavaHome();
        if (string2 == null) {
            sLogger.log(Level.WARNING, "general.no_java_home");
            throw new RuntimeException(Localizer.getValue(ExceptionType.NO_JAVA_HOME));
        }
        IASLicense.checkCanCreateInstance(this.getNumInstances(false));
        try {
            installConfig installConfig2 = new installConfig();
            ServerConfig serverConfig = new ServerConfig();
            serverConfig.serverID = instanceDefinition.getID();
            serverConfig.serverPort = instanceDefinition.getPort();
            serverConfig.serverName = instanceDefinition.getServerName();
            serverConfig.serverUser = instanceDefinition.getUser();
            serverConfig.docRoot = FileUtils.makeForwardSlashes(instanceDefinition.getDocRoot());
            serverConfig.javaHome = FileUtils.makeForwardSlashes(string2);
            serverConfig.imqBin = FileUtils.makeForwardSlashes(System.getProperty("com.sun.aas.imqBin"));
            serverConfig.imqLib = FileUtils.makeForwardSlashes(System.getProperty("com.sun.aas.imqLib"));
            serverConfig.serverRoot = FileUtils.makeForwardSlashes(INSTALL_ROOT);
            serverConfig.domainRoot = FileUtils.makeForwardSlashes(INSTANCE_CFG_ROOT);
            serverConfig.domainName = this.getDomainName();
            serverConfig.orbListenerPort = this.getFreePort(3700);
            serverConfig.jmsPort = this.getFreePort(7676);
            serverConfig.configRoot = FileUtils.makeForwardSlashes(System.getProperty("com.sun.aas.configRoot"));
            String string3 = installConfig2.createServerInstance(serverConfig);
            if (string3 != null) {
                throw new RuntimeException(string3);
            }
            ASAuditUtil.logGenericEvent(serverConfig.serverID, "", "create", 0);
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(instanceDefinition.getID());
            instanceEnvironment.createTimeStampFiles();
        }
        catch (Throwable throwable) {
            sLogger.log(Level.WARNING, "general.instance_create_failed", throwable);
            throw new RuntimeException(throwable.getMessage());
        }
    }

    public void deleteServerInstance(String string) throws ConfigException {
        if (string == null) {
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.NULL_INSTANCE_NAME));
        }
        if (!this.instanceExists(string)) {
            throw new ConfigException(Localizer.getValue(ExceptionType.NO_SUCH_INSTANCE, string));
        }
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
        File file = new File(instanceEnvironment.getInstanceDirPath());
        FileUtils.whack(file);
        installConfig installConfig2 = new installConfig();
        if (installConfig2.uninstallServerInstance(string, this.getDomainName()) != 0) {
            sLogger.log(Level.WARNING, "general.delete_service_failed");
        }
        if (file.exists()) {
            sLogger.log(Level.WARNING, "general.delete_instance_not_complete", string);
        }
        ASAuditUtil.logGenericEvent(string, "", "delete", 0);
    }

    public void startServerInstance(InstanceDefinition instanceDefinition) throws ConfigException, RuntimeException {
        this.startServerInstance(instanceDefinition, null);
    }

    public void startServerInstance(InstanceDefinition instanceDefinition, String[] stringArray) throws ConfigException, RuntimeException {
        if (instanceDefinition == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray2 = instanceDefinition.getStartCommand();
        String[] stringArray3 = null;
        stringArray3 = stringArray != null ? stringArray : new String[]{};
        try {
            sLogger.log(Level.FINE, "general.exec_cmd", stringArray2[0]);
            ProcessExecutor processExecutor = new ProcessExecutor(stringArray2, stringArray3);
            processExecutor.execute();
            ASAuditUtil.logGenericEvent(instanceDefinition.getID(), "", "start", 0);
        }
        catch (ExecException execException) {
            sLogger.log(Level.WARNING, "general.exec_cmd", execException);
            throw new RuntimeException(Localizer.getValue(ExceptionType.SERVER_NO_START));
        }
        catch (Exception exception) {
            throw new ConfigException(exception.getMessage());
        }
    }

    public void stopServerInstance(InstanceDefinition instanceDefinition) throws ConfigException {
        if (instanceDefinition == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = instanceDefinition.getStopCommand();
        try {
            sLogger.log(Level.FINE, "general.exec_cmd", stringArray[0]);
            ProcessExecutor processExecutor = new ProcessExecutor(stringArray);
            processExecutor.execute();
            ASAuditUtil.logGenericEvent(instanceDefinition.getID(), "", "stop", 0);
        }
        catch (Exception exception) {
            throw new ConfigException(exception.getMessage());
        }
    }

    public void restartServerInstance(InstanceDefinition instanceDefinition) throws ConfigException {
        if (instanceDefinition == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = instanceDefinition.getRestartCommand();
        try {
            sLogger.log(Level.FINE, "general.exec_cmd", stringArray[0]);
            ProcessExecutor processExecutor = new ProcessExecutor(stringArray);
            processExecutor.execute();
            ASAuditUtil.logGenericEvent(instanceDefinition.getID(), "", "restart", 0);
        }
        catch (Exception exception) {
            throw new ConfigException(exception.getMessage());
        }
    }

    public String[] getSecurityTokensForInstance(InstanceDefinition instanceDefinition) throws ConfigException, RuntimeException {
        if (instanceDefinition == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = instanceDefinition.getGetSecurityTokensCommand();
        Object var3_3 = null;
        try {
            sLogger.log(Level.FINE, "general.gettokens_cmd", stringArray[0]);
            ProcessExecutor processExecutor = new ProcessExecutor(stringArray);
            return processExecutor.execute(true);
        }
        catch (ExecException execException) {
            throw new RuntimeException(Localizer.getValue(ExceptionType.NO_RECEIVE_TOKENS));
        }
        catch (Exception exception) {
            throw new ConfigException(exception.getMessage());
        }
    }

    public String getMimeTypesTemplateFilePath() {
        String[] stringArray = new String[]{INSTALL_ROOT, "lib", "install", "templates", "mime.types.template"};
        return StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private int getFreePort(int n) {
        int n2 = NetUtils.getFreePort();
        if (n2 == 0) {
            sLogger.log(Level.SEVERE, "general.free_port_failed");
            return n;
        }
        Integer n3 = new Integer(n2);
        sLogger.log(Level.INFO, "general.free_port", n3);
        return n2;
    }

    private boolean portTakenByHTTP(int n) {
        boolean bl = true;
        String string = "" + n;
        String[] stringArray = this.getInstanceNames(true);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string2);
                String string3 = instanceEnvironment.getBackupConfigFilePath();
                ConfigContext configContext = ConfigFactory.createConfigContext(string3);
                Server server = ServerBeansFactory.getServerBean(configContext);
                HttpService httpService = server.getHttpService();
                HttpListener[] httpListenerArray = httpService.getHttpListener();
                for (int j = 0; j < httpListenerArray.length; ++j) {
                    String string4 = httpListenerArray[j].getPort();
                    string4 = string4.trim();
                    sLogger.log(Level.FINE, "port = " + string4);
                    if (!string4.equals(string)) continue;
                    sLogger.log(Level.WARNING, "general.port_occupied", string2);
                    return bl;
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "general.port_derivation_failed", exception);
        }
        return false;
    }

    private boolean portTakenByORB(int n) {
        boolean bl = true;
        String string = "" + n;
        String[] stringArray = this.getInstanceNames(true);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string2);
                String string3 = instanceEnvironment.getBackupConfigFilePath();
                ConfigContext configContext = ConfigFactory.createConfigContext(string3);
                Server server = ServerBeansFactory.getServerBean(configContext);
                IiopService iiopService = server.getIiopService();
                IiopListener[] iiopListenerArray = iiopService.getIiopListener();
                for (int j = 0; j < iiopListenerArray.length; ++j) {
                    String string4 = iiopListenerArray[j].getPort();
                    string4 = string4.trim();
                    sLogger.log(Level.FINE, "port = " + string4);
                    if (!string4.equals(string)) continue;
                    sLogger.log(Level.WARNING, "general.port_occupied", string2);
                    return bl;
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "general.port_derivation_failed", exception);
        }
        return false;
    }

    private boolean portTakenByJMS(int n) {
        boolean bl = true;
        String string = "" + n;
        String[] stringArray = this.getInstanceNames(true);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string2);
                String string3 = instanceEnvironment.getBackupConfigFilePath();
                ConfigContext configContext = ConfigFactory.createConfigContext(string3);
                Server server = ServerBeansFactory.getServerBean(configContext);
                JmsService jmsService = server.getJmsService();
                String string4 = jmsService.getPort();
                string4 = string4.trim();
                sLogger.log(Level.FINE, "port = " + string4);
                if (!string4.equals(string)) continue;
                sLogger.log(Level.WARNING, "general.port_occupied", string2);
                return bl;
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "general.port_derivation_failed", exception);
        }
        return false;
    }

    public String getDomainName() {
        File file = new File(INSTANCE_CFG_ROOT);
        return file.getName();
    }

    public String getInstanceUser(InstanceEnvironment instanceEnvironment) throws IOException {
        if (instanceEnvironment == null) {
            throw new IllegalArgumentException("env cant be null");
        }
        InitConfFileBean initConfFileBean = new InitConfFileBean();
        initConfFileBean.readConfig(instanceEnvironment.getInitFilePath());
        String string = initConfFileBean.get_mag_var("User");
        return string;
    }
}

