/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.EjbModule;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.deployment.ApplicationXmlWriter;
import com.iplanet.ias.deployment.EjbBundleXmlReader;
import com.iplanet.ias.deployment.EjbModuleConfigEnv;
import com.iplanet.ias.deployment.backend.DeployableObjectInfo;
import com.iplanet.ias.deployment.backend.DeployableObjectType;
import com.iplanet.ias.deployment.backend.ModuleInfo;
import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.Localizer;
import com.iplanet.ias.instance.ModuleEnvironment;
import com.iplanet.ias.instance.ModulesManager;
import com.sun.enterprise.deployment.Application;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class EjbModulesManager
extends ModulesManager {
    public EjbModulesManager(InstanceEnvironment instanceEnvironment) throws ConfigException {
        super(instanceEnvironment, true);
    }

    public EjbModulesManager(InstanceEnvironment instanceEnvironment, boolean bl) throws ConfigException {
        super(instanceEnvironment, bl);
        EjbModule[] ejbModuleArray = ((Applications)this.configBean).getEjbModule();
        if (ejbModuleArray != null) {
            for (int i = 0; i < ejbModuleArray.length; ++i) {
                ejbModuleArray[i].setConfigContext(this.configContext);
                ejbModuleArray[i].setXPath(ServerXPathHelper.getEjbModuleIdXpathExpression(ejbModuleArray[i].getName()));
            }
        }
    }

    public EjbModule[] listEjbModules() {
        EjbModule[] ejbModuleArray = ((Applications)this.configBean).getEjbModule();
        if (ejbModuleArray == null) {
            return new EjbModule[0];
        }
        return ejbModuleArray;
    }

    public List listIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        EjbModule[] ejbModuleArray = ((Applications)this.configBean).getEjbModule();
        if (ejbModuleArray == null) {
            return arrayList;
        }
        for (int i = 0; i < ejbModuleArray.length; ++i) {
            EjbModule ejbModule = ejbModuleArray[i];
            arrayList.add(ejbModule.getName());
        }
        return arrayList;
    }

    private EjbModule getEjbModule(String string) throws ConfigException {
        EjbModule ejbModule = ((Applications)this.configBean).getEjbModuleByName(string);
        if (ejbModule == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.NO_SUCH_EJB_MOD));
        }
        return ejbModule;
    }

    public void remove(String string) throws ConfigException {
        this.removeEjbModule(string);
    }

    private void removeEjbModule(String string) throws ConfigException {
        EjbModule ejbModule = ((Applications)this.configBean).getEjbModuleByName(string);
        ((Applications)this.configBean).removeEjbModule(ejbModule);
    }

    protected boolean isRegistered(String string, ConfigBean configBean) {
        EjbModule ejbModule = null;
        try {
            ejbModule = ((Applications)configBean).getEjbModuleByName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ejbModule != null;
    }

    public boolean isShared(String string) throws ConfigException {
        return false;
    }

    public boolean isEnabled(String string) throws ConfigException {
        return this.getEjbModule(string).isEnabled();
    }

    public void setShared(String string, boolean bl) throws ConfigException {
    }

    public void setEnable(String string, boolean bl) throws ConfigException {
        this.getEjbModule(string).setEnabled(bl);
    }

    public void setOptionalAttributes(String string, Properties properties) throws ConfigException {
        if (properties != null) {
            EjbModule ejbModule = this.getEjbModule(string);
            ejbModule.setAttributeValue(ServerTags.AVAILABILITY_ENABLED, null);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                ejbModule.setAttributeValue(string2, string3);
            }
        }
    }

    public String getLocation(String string) throws ConfigException {
        EjbModule ejbModule = ((Applications)this.configBean).getEjbModuleByName(string);
        String string2 = ejbModule.getLocation();
        return string2;
    }

    public void setLocation(String string, String string2) throws ConfigException {
        this.getEjbModule(string).setLocation(string2);
    }

    public String getStubLocation(String string) {
        ModuleEnvironment moduleEnvironment = this.instanceEnvironment.getModuleEnvironment(string, DeployableObjectType.EJB);
        return moduleEnvironment.getModuleStubPath();
    }

    public void register(DeployableObjectInfo deployableObjectInfo) throws ConfigException {
        if (!(deployableObjectInfo instanceof ModuleInfo)) {
            throw new ConfigException(Localizer.getValue(ExceptionType.BAD_EJB_MOD_INFO));
        }
        ModuleInfo moduleInfo = (ModuleInfo)deployableObjectInfo;
        this.regMod(moduleInfo, this.configContext, this.configBean);
    }

    private void regMod(ModuleInfo moduleInfo, ConfigContext configContext, ConfigBean configBean) throws ConfigException {
        if (moduleInfo == null || !moduleInfo.isEjb()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.WRONG_MOD_INFO));
        }
        EjbModule ejbModule = new EjbModule();
        ejbModule.setName(moduleInfo.getName());
        ejbModule.setLocation(moduleInfo.getRootPath().getAbsolutePath());
        boolean bl = this.isRegistered(moduleInfo.getName(), configBean);
        if (bl) {
            EjbModule ejbModule2 = ((Applications)configBean).getEjbModuleByName(moduleInfo.getName());
            ((Applications)configBean).removeEjbModule(ejbModule2);
        }
        ((Applications)configBean).addEjbModule(ejbModule);
        ejbModule.setConfigContext(this.configContext);
        ejbModule.setXPath(ServerXPathHelper.getEjbModuleIdXpathExpression(ejbModule.getName()));
    }

    public String getDescription(String string) throws ConfigException {
        return this.getEjbModule(string).getDescription();
    }

    public void setDescription(String string, String string2) throws ConfigException {
        this.getEjbModule(string).setDescription(string2);
    }

    public Application getDescriptor(String string, ClassLoader classLoader) throws ConfigException {
        return this.getDescriptor(string, classLoader, false, false);
    }

    public Application getDescriptor(String string, ClassLoader classLoader, boolean bl, boolean bl2) throws ConfigException {
        try {
            File file = new File(this.getLocation(string));
            EjbModuleConfigEnv ejbModuleConfigEnv = new EjbModuleConfigEnv(file, string, bl);
            ejbModuleConfigEnv.setVerifying(bl2);
            Application application = EjbBundleXmlReader.loadStdAloneModule(ejbModuleConfigEnv, classLoader);
            return application;
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (IOException iOException) {
            throw new ConfigException(Localizer.getValue(ExceptionType.IO_ERROR_LOADING_DD, string), iOException);
        }
        catch (Throwable throwable) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_LOAD, string), throwable);
        }
    }

    public void saveDescriptor(String string, Application application) throws ConfigException {
        try {
            application.setVirtual(true);
            File file = new File(this.getLocation(string));
            EjbModuleConfigEnv ejbModuleConfigEnv = new EjbModuleConfigEnv(file, string, false);
            ApplicationXmlWriter.saveEjbModule(ejbModuleConfigEnv, application);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (IOException iOException) {
            throw new ConfigException(Localizer.getValue(ExceptionType.IO_ERROR_SAVING_DD, string), iOException);
        }
        catch (Throwable throwable) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_SAVE, string), throwable);
        }
    }
}

