/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.ConnectorModule;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.deployment.ConnectorXmlReader;
import com.iplanet.ias.deployment.RarModuleConfigEnv;
import com.iplanet.ias.deployment.backend.DeployableObjectInfo;
import com.iplanet.ias.deployment.backend.ModuleInfo;
import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.Localizer;
import com.iplanet.ias.instance.ModulesManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ConnectorModulesManager
extends ModulesManager {
    public ConnectorModulesManager(InstanceEnvironment instanceEnvironment) throws ConfigException {
        super(instanceEnvironment, true);
    }

    public ConnectorModulesManager(InstanceEnvironment instanceEnvironment, boolean bl) throws ConfigException {
        super(instanceEnvironment, bl);
        ConnectorModule[] connectorModuleArray = ((Applications)this.configBean).getConnectorModule();
        if (connectorModuleArray != null) {
            for (int i = 0; i < connectorModuleArray.length; ++i) {
                connectorModuleArray[i].setConfigContext(this.configContext);
                connectorModuleArray[i].setXPath(ServerXPathHelper.getConnectorModuleIdXpathExpression(connectorModuleArray[i].getName()));
            }
        }
    }

    public ConnectorModule[] listConnectorModules() {
        ConnectorModule[] connectorModuleArray = ((Applications)this.configBean).getConnectorModule();
        if (connectorModuleArray == null) {
            return new ConnectorModule[0];
        }
        return connectorModuleArray;
    }

    public List listIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ConnectorModule[] connectorModuleArray = ((Applications)this.configBean).getConnectorModule();
        if (connectorModuleArray == null) {
            return arrayList;
        }
        for (int i = 0; i < connectorModuleArray.length; ++i) {
            ConnectorModule connectorModule = connectorModuleArray[i];
            arrayList.add(connectorModule.getName());
        }
        return arrayList;
    }

    private ConnectorModule getConnectorModule(String string) throws ConfigException {
        ConnectorModule connectorModule = ((Applications)this.configBean).getConnectorModuleByName(string);
        if (connectorModule == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.NO_SUCH_CON_MOD));
        }
        return connectorModule;
    }

    public void remove(String string) throws ConfigException {
        ConnectorModule connectorModule = ((Applications)this.configBean).getConnectorModuleByName(string);
        ((Applications)this.configBean).removeConnectorModule(connectorModule);
    }

    protected boolean isRegistered(String string, ConfigBean configBean) {
        ConnectorModule connectorModule = null;
        try {
            connectorModule = ((Applications)configBean).getConnectorModuleByName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connectorModule != null;
    }

    public boolean isEnabled(String string) throws ConfigException {
        return this.getConnectorModule(string).isEnabled();
    }

    public void setEnable(String string, boolean bl) throws ConfigException {
        this.getConnectorModule(string).setEnabled(bl);
    }

    public void setOptionalAttributes(String string, Properties properties) throws ConfigException {
        if (properties != null) {
            ConnectorModule connectorModule = this.getConnectorModule(string);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                connectorModule.setAttributeValue(string2, string3);
            }
        }
    }

    public String getLocation(String string) {
        String string2 = null;
        ConnectorModule connectorModule = ((Applications)this.configBean).getConnectorModuleByName(string);
        string2 = connectorModule.getLocation();
        return string2;
    }

    public void setLocation(String string, String string2) throws ConfigException {
        ConnectorModule connectorModule = ((Applications)this.configBean).getConnectorModuleByName(string);
        connectorModule.setLocation(string2);
    }

    public void register(DeployableObjectInfo deployableObjectInfo) throws ConfigException {
        if (!(deployableObjectInfo instanceof ModuleInfo)) {
            throw new ConfigException(Localizer.getValue(ExceptionType.BAD_CON_MOD_INFO));
        }
        ModuleInfo moduleInfo = (ModuleInfo)deployableObjectInfo;
        this.regMod(moduleInfo, this.configContext, this.configBean);
    }

    private void regMod(ModuleInfo moduleInfo, ConfigContext configContext, ConfigBean configBean) throws ConfigException {
        if (moduleInfo == null || !moduleInfo.isConnector()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.WRONG_MOD_INFO));
        }
        ConnectorModule connectorModule = new ConnectorModule();
        connectorModule.setName(moduleInfo.getName());
        connectorModule.setLocation(moduleInfo.getRootPath().getAbsolutePath());
        boolean bl = this.isRegistered(moduleInfo.getName(), configBean);
        if (bl) {
            ConnectorModule connectorModule2 = ((Applications)configBean).getConnectorModuleByName(moduleInfo.getName());
            ((Applications)configBean).removeConnectorModule(connectorModule2);
        }
        ((Applications)configBean).addConnectorModule(connectorModule);
        connectorModule.setConfigContext(this.configContext);
        connectorModule.setXPath(ServerXPathHelper.getConnectorModuleIdXpathExpression(connectorModule.getName()));
    }

    public String getDescription(String string) throws ConfigException {
        return this.getConnectorModule(string).getDescription();
    }

    public void setDescription(String string, String string2) throws ConfigException {
        this.getConnectorModule(string).setDescription(string2);
    }

    public static ConnectorDescriptor getDescriptor(String string, String string2, boolean bl, boolean bl2) throws ConfigException {
        try {
            Set set;
            RarModuleConfigEnv rarModuleConfigEnv = new RarModuleConfigEnv(new File(string2), string, bl);
            rarModuleConfigEnv.setVerifying(bl2);
            Application application = ConnectorXmlReader.loadStdAloneModule(rarModuleConfigEnv);
            ConnectorDescriptor connectorDescriptor = null;
            if (application != null && (set = application.getRarDescriptors()) != null && set.size() > 0) {
                connectorDescriptor = (ConnectorDescriptor)set.iterator().next();
            }
            return connectorDescriptor;
        }
        catch (IOException iOException) {
            throw new ConfigException(Localizer.getValue(ExceptionType.IO_ERROR_LOADING_DD, string), iOException);
        }
        catch (Throwable throwable) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_LOAD, string), throwable);
        }
    }
}

