/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.J2eeApplication;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.deployment.AppConfigEnvImpl;
import com.iplanet.ias.deployment.ApplicationXmlReader;
import com.iplanet.ias.deployment.ApplicationXmlWriter;
import com.iplanet.ias.deployment.backend.AppInfo;
import com.iplanet.ias.deployment.backend.DeployableObjectInfo;
import com.iplanet.ias.instance.ApplicationEnvironment;
import com.iplanet.ias.instance.BaseManager;
import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.Localizer;
import com.sun.enterprise.deployment.Application;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class AppsManager
extends BaseManager {
    public AppsManager(InstanceEnvironment instanceEnvironment) throws ConfigException {
        super(instanceEnvironment, true);
    }

    public AppsManager(InstanceEnvironment instanceEnvironment, boolean bl) throws ConfigException {
        super(instanceEnvironment, bl);
        J2eeApplication[] j2eeApplicationArray = ((Applications)this.configBean).getJ2eeApplication();
        if (j2eeApplicationArray != null) {
            for (int i = 0; i < j2eeApplicationArray.length; ++i) {
                j2eeApplicationArray[i].setConfigContext(this.configContext);
                j2eeApplicationArray[i].setXPath(ServerXPathHelper.getAppIdXpathExpression(j2eeApplicationArray[i].getName()));
            }
        }
    }

    public String getStubLocation(String string) {
        ApplicationEnvironment applicationEnvironment = this.instanceEnvironment.getApplicationEnvironment(string);
        return applicationEnvironment.getAppStubPath();
    }

    public String getJSPLocation(String string) {
        ApplicationEnvironment applicationEnvironment = this.instanceEnvironment.getApplicationEnvironment(string);
        return applicationEnvironment.getAppJSPPath();
    }

    public J2eeApplication[] getAllApps() {
        J2eeApplication[] j2eeApplicationArray = ((Applications)this.configBean).getJ2eeApplication();
        if (j2eeApplicationArray == null) {
            return new J2eeApplication[0];
        }
        return j2eeApplicationArray;
    }

    public List listIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        J2eeApplication[] j2eeApplicationArray = ((Applications)this.configBean).getJ2eeApplication();
        if (j2eeApplicationArray == null) {
            return arrayList;
        }
        for (int i = 0; i < j2eeApplicationArray.length; ++i) {
            J2eeApplication j2eeApplication = j2eeApplicationArray[i];
            arrayList.add(j2eeApplication.getName());
        }
        return arrayList;
    }

    public String getLocation(String string) throws ConfigException {
        J2eeApplication j2eeApplication = ((Applications)this.configBean).getJ2eeApplicationByName(string);
        return j2eeApplication.getLocation();
    }

    public boolean isEnabled(String string) throws ConfigException {
        return this.getJ2eeApplication(string).isEnabled();
    }

    private void regApp(AppInfo appInfo, ConfigContext configContext, ConfigBean configBean) throws ConfigException {
        J2eeApplication j2eeApplication = new J2eeApplication();
        j2eeApplication.setName(appInfo.getName());
        j2eeApplication.setLocation(appInfo.getRootPath().getAbsolutePath());
        boolean bl = this.isRegistered(appInfo.getName(), configBean);
        if (bl) {
            J2eeApplication j2eeApplication2 = ((Applications)configBean).getJ2eeApplicationByName(appInfo.getName());
            ((Applications)configBean).removeJ2eeApplication(j2eeApplication2);
        }
        ((Applications)configBean).addJ2eeApplication(j2eeApplication);
        j2eeApplication.setConfigContext(this.configContext);
        j2eeApplication.setXPath(ServerXPathHelper.getAppIdXpathExpression(j2eeApplication.getName()));
    }

    protected boolean isRegistered(String string, ConfigBean configBean) {
        J2eeApplication j2eeApplication = null;
        try {
            j2eeApplication = ((Applications)configBean).getJ2eeApplicationByName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return j2eeApplication != null;
    }

    public void remove(String string) throws ConfigException {
        J2eeApplication j2eeApplication = ((Applications)this.configBean).getJ2eeApplicationByName(string);
        ((Applications)this.configBean).removeJ2eeApplication(j2eeApplication);
    }

    public void setEnable(String string, boolean bl) throws ConfigException {
        this.getJ2eeApplication(string).setEnabled(bl);
    }

    public void setLocation(String string, String string2) throws ConfigException {
        this.getJ2eeApplication(string).setLocation(string2);
    }

    public void setOptionalAttributes(String string, Properties properties) throws ConfigException {
        if (properties != null) {
            J2eeApplication j2eeApplication = this.getJ2eeApplication(string);
            j2eeApplication.setAttributeValue(ServerTags.AVAILABILITY_ENABLED, null);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                j2eeApplication.setAttributeValue(string2, string3);
            }
        }
    }

    public Application getAppDescriptor(String string, ClassLoader classLoader) throws ConfigException {
        return this.getAppDescriptor(string, classLoader, false, false);
    }

    public Application getAppDescriptor(String string, ClassLoader classLoader, boolean bl, boolean bl2) throws ConfigException {
        try {
            String string2 = this.getLocation(string);
            AppConfigEnvImpl appConfigEnvImpl = new AppConfigEnvImpl(string2, string, bl);
            appConfigEnvImpl.setVerifying(bl2);
            ApplicationXmlReader applicationXmlReader = new ApplicationXmlReader(appConfigEnvImpl);
            Application application = applicationXmlReader.load(classLoader);
            return application;
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Throwable throwable) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_LOAD, string), throwable);
        }
    }

    public void saveAppDescriptor(String string, Application application) throws ConfigException {
        try {
            String string2 = this.getLocation(string);
            AppConfigEnvImpl appConfigEnvImpl = new AppConfigEnvImpl(string2, string, false);
            ApplicationXmlWriter.save(appConfigEnvImpl, application);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Throwable throwable) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_SAVE, string), throwable);
        }
    }

    public String getDescription(String string) throws ConfigException {
        return this.getJ2eeApplication(string).getDescription();
    }

    private J2eeApplication getJ2eeApplication(String string) throws ConfigException {
        J2eeApplication j2eeApplication = ((Applications)this.configBean).getJ2eeApplicationByName(string);
        if (j2eeApplication == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.APP_NOT_EXIST));
        }
        return j2eeApplication;
    }

    public void setDescription(String string, String string2) throws ConfigException {
        this.getJ2eeApplication(string).setDescription(string2);
    }

    public void register(DeployableObjectInfo deployableObjectInfo) throws ConfigException {
        if (!(deployableObjectInfo instanceof AppInfo)) {
            throw new ConfigException(Localizer.getValue(ExceptionType.BAD_REG));
        }
        this.regApp((AppInfo)deployableObjectInfo, this.configContext, this.configBean);
    }
}

