/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.ejb.containers;

import com.iplanet.ias.ejb.containers.IASServerSessionFactory;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.ejb.containers.MessageBeanContainer;
import com.sun.ejb.containers.MessageBeanHelper;
import com.sun.enterprise.jms.SessionWrapper;
import com.sun.logging.LogDomains;
import com.sun.messaging.jmq.jmsspi.ServerSession;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;

public class IASServerSessionImpl
implements Runnable,
ServerSession {
    private static Logger logger_ = LogDomains.getLogger("javax.enterprise.system.container.ejb.mdb");
    private static final StringManager localStrings = StringManager.getManager("com.sun.ejb.containers");
    private Thread thread_ = null;
    private boolean inUse_ = false;
    private boolean started_ = false;
    private Session session_ = null;
    private MessageListener listener_ = null;
    private MessageBeanHelper helper_ = null;
    private MessageBeanContainer container_ = null;
    private IASServerSessionFactory ssf_ = null;

    public IASServerSessionImpl(MessageBeanHelper messageBeanHelper, MessageBeanContainer messageBeanContainer, IASServerSessionFactory iASServerSessionFactory) throws Exception {
        this.helper_ = messageBeanHelper;
        this.container_ = messageBeanContainer;
        this.ssf_ = iASServerSessionFactory;
        this.thread_ = new Thread(this);
        this.thread_.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() throws JMSException {
        IASServerSessionImpl iASServerSessionImpl = this;
        synchronized (iASServerSessionImpl) {
            if (this.inUse_) {
                logger_.log(Level.SEVERE, "containers.mdb.get_session_inuse");
                throw new IllegalStateException(localStrings.getStringWithDefault("containers.mdb.get_session_inuse", "Can not call getSession() while the session is still in use !"));
            }
            this.inUse_ = true;
        }
        if (this.thread_ == null) {
            logger_.log(Level.SEVERE, "containers.mdb.get_session_invalid");
            this.destroy();
            throw new IllegalStateException(localStrings.getStringWithDefault("containers.mdb.get_session_invalid", "Can not call getSession() after the session has been destroyed"));
        }
        if (!this.thread_.isAlive()) {
            logger_.log(Level.SEVERE, "containers.mdb.get_session_failed");
            this.destroy();
            throw new JMSException(localStrings.getStringWithDefault("containers.mdb.get_session_failed", "Get session failed"));
        }
        if (this.session_ == null) {
            try {
                this.session_ = this.helper_.createSession(this.ssf_.jmsConnection_);
                this.listener_ = this.container_.createMessageDrivenEJBListener(this.session_);
                this.session_.setMessageListener(this.listener_);
            }
            catch (Exception exception) {
                logger_.log(Level.SEVERE, "containers.mdb.get_session_error", exception.getMessage());
                logger_.log(Level.SEVERE, "containers.mdb.get_session_exception", exception);
                JMSException jMSException = new JMSException(localStrings.getStringWithDefault("containers.mdb.get_session_failed", "Get session failed"));
                jMSException.setLinkedException(exception);
                this.destroy();
                throw jMSException;
            }
        }
        if (logger_.isLoggable(Level.FINEST)) {
            logger_.finest(Thread.currentThread() + ": got session: " + this.session_ + " from " + this);
        }
        try {
            return ((SessionWrapper)this.session_).getDelegate();
        }
        catch (JMSException jMSException) {
            logger_.log(Level.SEVERE, "containers.mdb.get_session_exception", jMSException);
            this.destroy();
            throw jMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        IASServerSessionImpl iASServerSessionImpl = this;
        synchronized (iASServerSessionImpl) {
            if (this.session_ == null || !this.inUse_) {
                logger_.log(Level.SEVERE, "containers.mdb.serversession_start");
                throw new IllegalStateException(localStrings.getStringWithDefault("containers.mdb.serversession_start", "ServerSession.getSession() must be called first before calling start() !"));
            }
            if (logger_.isLoggable(Level.FINEST)) {
                logger_.finest("start(): calling notify... " + this);
            }
            this.started_ = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            Object var4_4;
            block17: {
                if (this.thread_ == null) {
                    return;
                }
                try {
                    if (logger_.isLoggable(Level.FINEST)) {
                        logger_.finest("run(): before wait ... " + this);
                    }
                    IASServerSessionImpl iASServerSessionImpl = this;
                    synchronized (iASServerSessionImpl) {
                        while (this.thread_ != null && !this.started_) {
                            this.wait();
                        }
                        if (!logger_.isLoggable(Level.FINEST)) break block17;
                    }
                    logger_.finest("run(): after wait ... " + this);
                }
                catch (InterruptedException interruptedException) {
                    logger_.finest("run(): wait interrupted " + this);
                    continue;
                }
            }
            if (this.thread_ == null) {
                return;
            }
            try {
                try {
                    if (logger_.isLoggable(Level.FINEST)) {
                        logger_.finest(Thread.currentThread() + ": run(): calling Session.run() ... " + this);
                    }
                    this.session_.run();
                }
                catch (Exception exception) {
                    logger_.log(Level.SEVERE, "containers.mdb.session_run_error", exception.getMessage());
                    logger_.log(Level.SEVERE, "containers.mdb.session_run_exception", exception);
                    var4_4 = null;
                    if (logger_.isLoggable(Level.FINEST)) {
                        logger_.finest(Thread.currentThread() + ": in run(): return object " + this + " to pool ...");
                    }
                    this.started_ = false;
                    this.inUse_ = false;
                    this.ssf_.pool.returnObject(this);
                    continue;
                }
                var4_4 = null;
                if (logger_.isLoggable(Level.FINEST)) {
                    logger_.finest(Thread.currentThread() + ": in run(): return object " + this + " to pool ...");
                }
                this.started_ = false;
                this.inUse_ = false;
            }
            catch (Throwable throwable) {
                var4_4 = null;
                if (logger_.isLoggable(Level.FINEST)) {
                    logger_.finest(Thread.currentThread() + ": in run(): return object " + this + " to pool ...");
                }
                this.started_ = false;
                this.inUse_ = false;
                this.ssf_.pool.returnObject(this);
                throw throwable;
            }
            this.ssf_.pool.returnObject(this);
        }
    }

    public void beforeMessageDelivery(Message message) {
        if (logger_.isLoggable(Level.FINEST)) {
            logger_.finest(Thread.currentThread() + ": in beforeMessageDelivery() ... " + this);
        }
        this.container_.beforeMessageDelivery(message, this.listener_);
    }

    public void afterMessageDelivery(Message message) {
        if (logger_.isLoggable(Level.FINEST)) {
            logger_.finest(Thread.currentThread() + ": in afterMessageDelivery() ... " + this);
        }
        this.container_.afterMessageDelivery(message, this.listener_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        if (logger_.isLoggable(Level.FINEST)) {
            logger_.finest(Thread.currentThread() + ": in cleanup() ... " + this);
        }
        IASServerSessionImpl iASServerSessionImpl = this;
        synchronized (iASServerSessionImpl) {
            this.thread_ = null;
            this.notify();
        }
        try {
            if (this.listener_ != null) {
                this.container_.destroyMessageDrivenEJBListener(this.listener_);
                this.listener_ = null;
            }
        }
        catch (Exception exception) {
            this.listener_ = null;
            logger_.log(Level.SEVERE, "containers.mdb.serversession_cleanup_error", exception.getMessage());
            logger_.log(Level.SEVERE, "containers.mdb.serversession_cleanup_exception", exception);
        }
        try {
            if (this.session_ != null) {
                this.session_.close();
                this.session_ = null;
            }
        }
        catch (Exception exception) {
            this.session_ = null;
            logger_.log(Level.FINE, "containers.mdb.serversession_cleanup_error", exception.getMessage());
            logger_.log(Level.FINE, "containers.mdb.serversession_cleanup_exception", exception);
        }
        this.inUse_ = false;
    }

    public void destroy() {
        if (logger_.isLoggable(Level.FINEST)) {
            logger_.finest(Thread.currentThread() + ": in destory() ... " + this);
        }
        if (this.ssf_.pool != null) {
            if (logger_.isLoggable(Level.FINEST)) {
                logger_.finest("destory() object ... " + this);
            }
            this.ssf_.pool.destroyObject(this);
        }
    }
}

