/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.ejb.codegen;

import com.iplanet.ias.deployment.IASEjbExtraDescriptors;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

class RedeployInspector {
    private Application _currentDD = null;
    private Object _oldDD = null;
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    RedeployInspector(Application application, Object object) {
        this._currentDD = application;
        this._oldDD = object;
    }

    void check() {
        if (this._currentDD == null || this._oldDD == null) {
            return;
        }
        EjbDescriptor[] ejbDescriptorArray = this._currentDD.getSortedEjbDescriptors();
        EjbDescriptor[] ejbDescriptorArray2 = ((Application)this._oldDD).getSortedEjbDescriptors();
        for (int i = 0; i < ejbDescriptorArray.length; ++i) {
            if (ejbDescriptorArray[i] instanceof EjbMessageBeanDescriptor) continue;
            EjbDescriptor ejbDescriptor = null;
            String string = ejbDescriptorArray[i].getName();
            try {
                ejbDescriptor = ((Application)this._oldDD).getEjbByName(string);
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "[EJBC] EJB is missing in previous deployment: " + string);
            }
            if (ejbDescriptor != null) {
                if (!this.isRmicMandatory(ejbDescriptorArray[i], ejbDescriptor)) continue;
                ejbDescriptorArray[i].setRmicMandatory(true);
                continue;
            }
            ejbDescriptorArray[i].setRmicMandatory(true);
        }
    }

    private boolean isRmicMandatory(EjbDescriptor ejbDescriptor, EjbDescriptor ejbDescriptor2) {
        boolean bl = false;
        try {
            Object object;
            Object object2;
            String string = ejbDescriptor.getType();
            String string2 = ejbDescriptor2.getType();
            if (string != null && string2 != null && !string.equals(string2)) {
                _logger.log(Level.FINE, "[EJBC] Bean TYPE has changed for bean: " + ejbDescriptor.getName());
                bl = true;
            } else if (EjbSessionDescriptor.TYPE.equals(string)) {
                object2 = ((EjbSessionDescriptor)ejbDescriptor).getSessionTypeString();
                object = ((EjbSessionDescriptor)ejbDescriptor2).getSessionTypeString();
                if (object2 != null && object != null && !((String)object2).equals(object)) {
                    _logger.log(Level.FINE, "[EJBC] Bean SUBTYPE has changed for bean: " + ejbDescriptor.getName());
                    bl = true;
                }
            }
            if (!bl) {
                boolean bl2;
                boolean bl3;
                object2 = ejbDescriptor.getIASEjbExtraDescriptors();
                object = ejbDescriptor2.getIASEjbExtraDescriptors();
                if (object2 != null && object != null && (bl3 = ((IASEjbExtraDescriptors)object2).getPassByReference()) != (bl2 = ((IASEjbExtraDescriptors)object).getPassByReference())) {
                    _logger.log(Level.FINE, "[EJBC] pass-by-reference has changed for bean: " + ejbDescriptor.getName());
                    bl = true;
                }
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[EJBC] RMIC mandatory flag is " + bl + " for bean: " + ejbDescriptor.getName());
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }
}

