/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.ejb.codegen;

import com.iplanet.ias.ejb.codegen.ProcessExecutor;
import com.iplanet.ias.ejb.codegen.ProcessExecutorException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class ProcessRunner
implements Runnable {
    static final Logger logger = ProcessExecutor.logger;
    long timeout;
    String[] cmd;
    StringBuffer stdout = new StringBuffer();
    StringBuffer stderr = new StringBuffer();
    BufferedInputStream is = null;
    BufferedInputStream es = null;
    int exitCode;
    boolean completed = false;
    boolean interrupted = false;
    ProcessExecutorException exception;
    private String cmdString = null;

    ProcessRunner(String[] stringArray, long l) {
        this.cmd = stringArray;
        this.timeout = l;
    }

    public void run() {
        try {
            Process process;
            try {
                process = Runtime.getRuntime().exec(this.cmd);
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "process.creation_failed", iOException);
                this.makeOtherException(iOException);
                return;
            }
            if (this.checkInterrupted()) {
                return;
            }
            this.is = new BufferedInputStream(process.getInputStream());
            this.es = new BufferedInputStream(process.getErrorStream());
            ProcessReader processReader = new ProcessReader(this.es, this.stderr);
            processReader.start();
            ProcessReader processReader2 = new ProcessReader(this.is, this.stdout);
            processReader2.start();
            this.exitCode = process.waitFor();
            if (this.exitCode != 0) {
                this.makeAbnormalTerminationException();
            }
            try {
                processReader.join();
            }
            catch (InterruptedException interruptedException) {
                logger.log(Level.FINEST, "process.waiter_interrupted", this.getCommandString());
            }
            try {
                processReader2.join();
            }
            catch (InterruptedException interruptedException) {
                logger.log(Level.FINEST, "process.waiter_interrupted", this.getCommandString());
            }
            process.destroy();
            this.completed = true;
        }
        catch (Exception exception) {
            logger.log(Level.FINEST, "process.execution_failed", exception);
            this.makeOtherException(exception);
        }
    }

    private boolean checkInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            this.interrupted = true;
            this.makeTimeoutException();
        }
        return this.interrupted;
    }

    void makeTimeoutException() {
        String string = this.stderr.toString() + "\n" + this.stdout.toString();
        this.exception = new ProcessExecutorException("process.timeout", "Process timed out.\nTimeout was {2} msecs\nAttempted command: {0}\nOutput from command: {1}", new Object[]{this.getCommandString(), string, new Long(this.timeout)});
    }

    void makeAbnormalTerminationException() {
        String string = this.stderr.toString() + "\n" + this.stdout.toString();
        this.exception = new ProcessExecutorException("process.abnormal_termination", "Abnormal process termination -- process returned: {0}\nAttempted command: {1}\nOutput from command: {2}", new Object[]{new Integer(this.exitCode), this.getCommandString(), string});
    }

    void makeOtherException(Throwable throwable) {
        String string = this.stderr.toString() + "\n" + this.stdout.toString();
        this.exception = new ProcessExecutorException("process.unknown_exception", "Abnormal process termination -- process threw an Exception.\nAttempted command: {0}\nOutput from command: {1}", new Object[]{this.getCommandString(), string}, throwable);
    }

    String getCommandString() {
        if (this.cmdString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.cmd.length; ++i) {
                stringBuffer.append(this.cmd[i] + " ");
            }
            this.cmdString = stringBuffer.toString();
        }
        return this.cmdString;
    }

    static /* synthetic */ boolean access$000(ProcessRunner processRunner) {
        return processRunner.checkInterrupted();
    }

    private class ProcessReader
    extends Thread {
        final Logger logger = ProcessExecutor.logger;
        BufferedInputStream is = null;
        StringBuffer buffer = null;

        public ProcessReader(BufferedInputStream bufferedInputStream, StringBuffer stringBuffer) {
            this.is = bufferedInputStream;
            this.buffer = stringBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                var1_1 = new byte[1024];
                var2_3 = 0;
                while ((var2_3 = this.is.read(var1_1)) != -1) {
                    this.buffer.append(new String(var1_1, 0, var2_3));
                    if (!ProcessRunner.access$000(ProcessRunner.this)) continue;
                    var4_4 = null;
                    ** GOTO lbl36
                }
                ** GOTO lbl44
            }
            catch (IOException var1_2) {
                this.logger.log(Level.FINEST, "process.stream_read_error", var1_2);
                var4_6 = null;
                try {
                    if (this.is != null) {
                        this.is.close();
                    }
                    this.is = null;
                    return;
                }
                catch (IOException var5_10) {
                    this.logger.log(Level.FINEST, "process.stream_close_error", var5_10);
                    return;
                }
            }
            {
                catch (Throwable var3_12) {
                    var4_7 = null;
                    ** try [egrp 2[TRYBLOCK] [5 : 88->110)] { 
lbl29:
                    // 1 sources

                    if (this.is != null) {
                        this.is.close();
                    }
                    this.is = null;
                    throw var3_12;
lbl33:
                    // 1 sources

                    catch (IOException var5_11) {
                        this.logger.log(Level.FINEST, "process.stream_close_error", var5_11);
                    }
                    throw var3_12;
                }
lbl36:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [5 : 88->110)] { 
lbl37:
                // 1 sources

                if (this.is != null) {
                    this.is.close();
                }
                this.is = null;
                return;
lbl41:
                // 1 sources

                catch (IOException var5_8) {
                    this.logger.log(Level.FINEST, "process.stream_close_error", var5_8);
                }
                return;
lbl44:
                // 1 sources

                var4_5 = null;
                try {}
                catch (IOException var5_9) {}
                this.logger.log(Level.FINEST, "process.stream_close_error", var5_9);
                return;
                if (this.is != null) {
                    this.is.close();
                }
                this.is = null;
                return;
            }
        }
    }
}

