/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.ejb.codegen;

import com.iplanet.ias.ejb.codegen.ProcessExecutorException;
import com.iplanet.ias.ejb.codegen.ProcessRunner;
import com.iplanet.ias.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessExecutor {
    private static final StringManager localStrings = StringManager.getManager(ProcessExecutor.class);
    static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.deployment");
    private String[] command;
    private long timeout;
    private ProcessRunner runner = null;

    public ProcessExecutor(String[] stringArray, long l) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException(localStrings.getString("process.null_or_empty_command"));
        }
        if (l <= 0L) {
            throw new IllegalArgumentException(localStrings.getString("process.invalid_timeout_value", new Long(l)));
        }
        this.command = stringArray;
        this.timeout = l;
    }

    public String getCommandString() {
        String string = null;
        if (this.runner != null) {
            string = this.runner.getCommandString();
        }
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.command.length; ++i) {
                stringBuffer.append(this.command[i] + " ");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(localStrings.getString("process.invalid_timeout_value", new Long(l)));
        }
        this.timeout = l;
    }

    public String execute() throws ProcessExecutorException {
        if (this.runner != null) {
            throw new IllegalStateException(localStrings.getString("process.already_executed"));
        }
        this.runner = new ProcessRunner(this.command, this.timeout);
        Thread thread = new Thread(this.runner);
        thread.start();
        try {
            thread.join(this.timeout);
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.FINEST, "process.waiter_interrupted", this.getCommandString());
        }
        if (thread.isAlive() && !this.runner.completed) {
            logger.log(Level.FINEST, "process.interrupting", new Object[]{new Long(this.timeout), this.getCommandString()});
            thread.interrupt();
            try {
                thread.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.runner.completed && !this.runner.interrupted) {
                this.runner.interrupted = true;
            }
        }
        if (this.runner.interrupted || this.runner.exception != null) {
            if (this.runner.exception == null) {
                this.runner.makeTimeoutException();
            }
            throw this.runner.exception;
        }
        return this.runner.stdout.toString();
    }

    public boolean isCompleted() {
        boolean bl = false;
        if (this.runner != null) {
            bl = this.runner.completed;
        }
        return bl;
    }

    public boolean isInterrupted() {
        boolean bl = false;
        if (this.runner != null) {
            bl = this.runner.interrupted;
        }
        return bl;
    }

    public String getStdout() {
        String string = null;
        if (this.runner != null) {
            string = this.runner.stdout.toString();
        }
        return string;
    }

    public String getStderr() {
        String string = null;
        if (this.runner != null) {
            string = this.runner.stderr.toString();
        }
        return string;
    }

    public int getExitCode() {
        int n = 0;
        if (this.runner == null || !this.runner.completed) {
            throw new IllegalStateException(localStrings.getString("process.not_yet_executed"));
        }
        n = this.runner.exitCode;
        return n;
    }

    public String executeAgain() throws ProcessExecutorException {
        this.runner = null;
        return this.execute();
    }
}

