/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.ejb.codegen;

import com.iplanet.ias.ejb.codegen.Compiler;
import com.iplanet.ias.ejb.codegen.JavaCompilerException;
import com.iplanet.ias.ejb.codegen.ProcessExecutorException;
import com.iplanet.ias.util.OS;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.tools.javac.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

class JavaCompiler
extends Compiler {
    private File userExe;
    private File fastExe;
    private File javacExe;
    private List userOptions;
    private static int fastJavacTimeout = -1;
    private static int javacTimeout = -1;
    private static int userTimeout = -1;

    JavaCompiler(List list, List list2) throws JavaCompilerException {
        super(list, list2);
    }

    protected void internal_compile() throws JavaCompilerException, ProcessExecutorException {
        if (this.userCompile()) {
            return;
        }
        if (this.fastjavacCompile()) {
            return;
        }
        if (this.javacCompile()) {
            return;
        }
        this.nativeCompile();
    }

    private boolean userCompile() throws ProcessExecutorException {
        if (this.userExe == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.userExe.getPath());
        arrayList.addAll(this.userOptions);
        arrayList.addAll(this.options);
        arrayList.addAll(this.files);
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        this.runProcess(stringArray, JavaCompiler.getUserSpecifiedCompilerTimeout() * this.files.size());
        this.logCompilerName(this.userExe.getName());
        return true;
    }

    private boolean fastjavacCompile() throws ProcessExecutorException {
        if (this.fastExe == null || this.jdkDir == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.fastExe.getPath());
        arrayList.add("-jdk");
        arrayList.add(this.jdkDir.getPath());
        arrayList.addAll(this.options);
        this.addJavaFiles(arrayList);
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        this.runProcess(stringArray, JavaCompiler.getFastjavacTimeout() * this.files.size());
        this.logCompilerName("fastjavac");
        return true;
    }

    private boolean javacCompile() throws ProcessExecutorException {
        if (this.javacExe == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.javacExe.getPath());
        arrayList.addAll(this.options);
        this.addJavaFiles(arrayList);
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        this.runProcess(stringArray, JavaCompiler.getJavacTimeout() * this.files.size());
        this.logCompilerName("javac");
        return true;
    }

    private void nativeCompile() throws JavaCompilerException {
        this.options.addAll(this.files);
        String[] stringArray = new String[this.options.size()];
        stringArray = this.options.toArray(stringArray);
        try {
            Main main = new Main();
            int n = Main.compile(stringArray);
            if (n != 0) {
                throw new JavaCompilerException("java_compiler.error", "Native compiler returned an error: {0}", new Object[]{new Integer(n)});
            }
        }
        catch (JavaCompilerException javaCompilerException) {
            throw javaCompilerException;
        }
        catch (Throwable throwable) {
            throw new JavaCompilerException("java_compiler.unknown_exception", "Native java compiler threw an Exception", throwable);
        }
        this.logCompilerName("native JDK (com.sun.tools.javac.Main)");
    }

    protected void internal_init() {
        this.fastExe = null;
        this.javacExe = null;
        this.userExe = null;
        this.userOptions = new ArrayList();
        this.initUserCompiler();
        this.initFastjavac();
        this.initJavac();
        logger.log(Level.FINE, "fastExe: " + (this.fastExe == null ? "null" : this.fastExe.getPath()));
        logger.log(Level.FINE, "javacExe: " + (this.javacExe == null ? "null" : this.javacExe.getPath()));
        logger.log(Level.FINE, "jdkDir: " + (this.jdkDir == null ? "null" : this.jdkDir.getPath()));
    }

    private void initUserCompiler() {
        String string = JavaCompiler.getSystemPropertyIgnoreCase("com.sun.aas.deployment.java.compiler");
        if (!StringUtils.ok((String)string)) {
            return;
        }
        this.userExe = new File(string);
        if (!this.userExe.exists()) {
            String string2 = localStrings.getStringWithDefault("java_compiler.bad_user_compiler", "Can't locate user-specified Java Compiler for deployment.  Environmental Variable= {0}, Value = {1}", new Object[]{"com.sun.aas.deployment.java.compiler", string});
            logger.warning(string2);
            this.userExe = null;
            return;
        }
        this.userExe = FileUtils.safeGetCanonicalFile(this.userExe);
        String string3 = JavaCompiler.getSystemPropertyIgnoreCase("com.sun.aas.deployment.java.compiler.options");
        if (!StringUtils.ok((String)string3)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        while (stringTokenizer.hasMoreTokens()) {
            this.userOptions.add(stringTokenizer.nextToken());
        }
    }

    private void initFastjavac() {
        if (this.installRoot == null || this.jdkDir == null) {
            return;
        }
        String string = OS.isWindows() ? "fastjavac.exe" : (OS.isSun() ? "fastjavac.sun" : (OS.isLinux() ? "fastjavac.linux" : null));
        if (string == null) {
            return;
        }
        this.fastExe = new File(this.installRoot + "/studio4/bin/fastjavac/" + string);
        this.fastExe = this.fastExe.exists() ? FileUtils.safeGetCanonicalFile(this.fastExe) : null;
    }

    private void initJavac() {
        if (this.jdkDir == null) {
            return;
        }
        String string = OS.isWindows() ? "javac.exe" : "javac";
        this.javacExe = new File(this.jdkDir, "/bin/" + string);
        this.javacExe = this.javacExe.exists() ? FileUtils.safeGetCanonicalFile(this.javacExe) : null;
    }

    private static int getFastjavacTimeout() {
        if (fastJavacTimeout < 0) {
            fastJavacTimeout = JavaCompiler.getTimeout("com.sun.aas.deployment.Fastjavac.TimeoutMS", 4000, 1000, 300000);
        }
        return fastJavacTimeout;
    }

    private static int getJavacTimeout() {
        if (javacTimeout < 0) {
            javacTimeout = JavaCompiler.getTimeout("com.sun.aas.deployment.Javac.TimeoutMS", 30000, 1000, 900000);
        }
        return javacTimeout;
    }

    private static int getUserSpecifiedCompilerTimeout() {
        if (userTimeout < 0) {
            userTimeout = JavaCompiler.getTimeout("com.sun.aas.deployment.java.compiler.TimeoutMS", 30000, 1000, 900000);
        }
        return userTimeout;
    }
}

