/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.ejb.codegen;

import com.iplanet.ias.deployment.IASEjbBundleDescriptor;
import com.iplanet.ias.deployment.IASEjbCMPEntityDescriptor;
import com.iplanet.ias.deployment.IASPersistenceManagerDescriptor;
import com.iplanet.ias.ejb.codegen.CmpCompilerException;
import com.iplanet.ias.ejb.codegen.EjbcContext;
import com.iplanet.ias.ejb.codegen.IASEJBC;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.ejb.codegen.AbstractCMPGenerator;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class CmpCompiler {
    private EjbcContext _ejbcCtx = null;
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private static final StringManager localStrings = StringManager.getManager(CmpCompiler.class);

    CmpCompiler(EjbcContext ejbcContext) {
        this._ejbcCtx = ejbcContext;
    }

    void compile() throws CmpCompilerException {
        try {
            long l;
            Object object;
            File file = this._ejbcCtx.getStubsDir();
            Application application = this._ejbcCtx.getDescriptor();
            _logger.log(Level.FINE, "ejbc.processing_cmp", application.getRegistrationName());
            Vector<String> vector = new Vector<String>();
            Iterator iterator = application.getEjbBundleDescriptors().iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object object3;
                Object object4;
                object = (IASEjbBundleDescriptor)iterator.next();
                IASPersistenceManagerDescriptor iASPersistenceManagerDescriptor = ((IASEjbBundleDescriptor)object).getPreferredPersistenceManager();
                if (null == iASPersistenceManagerDescriptor) continue;
                if (!application.isVirtual()) {
                    ((IASEjbBundleDescriptor)object).setModuleDirName(this._ejbcCtx.getSrcDir().getCanonicalPath() + File.separator + CmpCompiler.getModuleDirName((EjbBundleDescriptor)object));
                } else {
                    ((IASEjbBundleDescriptor)object).setModuleDirName(this._ejbcCtx.getSrcDir().getCanonicalPath());
                }
                String string = iASPersistenceManagerDescriptor.getPersistenceManagerClassGenerator();
                ClassLoader classLoader = application.getApplicationArchivist().getClassLoader();
                Class<?> clazz = classLoader.loadClass(string);
                AbstractCMPGenerator abstractCMPGenerator = (AbstractCMPGenerator)clazz.newInstance();
                l = this.now();
                abstractCMPGenerator.init((IASEjbBundleDescriptor)object, classLoader);
                this._ejbcCtx.getTiming().cmpGeneratorTime += this.now() - l;
                Iterator iterator2 = ((EjbBundleDescriptor)object).getEjbs().iterator();
                while (iterator2.hasNext()) {
                    object4 = (EjbDescriptor)iterator2.next();
                    if (object4 instanceof IASEjbCMPEntityDescriptor) {
                        object3 = (IASEjbCMPEntityDescriptor)object4;
                        object2 = ((IASEjbCMPEntityDescriptor)object3).getConcreteImplClassName();
                        ((IASEjbCMPEntityDescriptor)object3).setClassLoader(classLoader);
                        l = this.now();
                        abstractCMPGenerator.generate((IASEjbCMPEntityDescriptor)object3, file, file);
                        this._ejbcCtx.getTiming().cmpGeneratorTime += this.now() - l;
                        continue;
                    }
                    if (!(object4 instanceof EjbCMPEntityDescriptor)) continue;
                }
                l = this.now();
                object4 = abstractCMPGenerator.cleanup();
                this._ejbcCtx.getTiming().cmpGeneratorTime += this.now() - l;
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (File)object3.next();
                    String string2 = ((File)object2).getPath();
                    _logger.log(Level.FINE, "[CMPC] File name is " + string2);
                    vector.addElement(string2);
                }
            }
            object = CmpCompiler.getClassPath(this._ejbcCtx.getClasspathUrls(), file);
            l = this.now();
            IASEJBC.compileClasses((String)object, vector, file, file.getCanonicalPath(), this._ejbcCtx.getJavacOptions());
            this._ejbcCtx.getTiming().javaCompileTime += this.now() - l;
            _logger.log(Level.FINE, "ejbc.done_processing_cmp", application.getRegistrationName());
        }
        catch (Exception exception) {
            String string = localStrings.getString("cmpc.cmp_error");
            throw new CmpCompilerException(string, exception);
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private static String getModuleDirName(EjbBundleDescriptor ejbBundleDescriptor) {
        String string = ejbBundleDescriptor.getArchivist().getArchiveUri();
        return FileUtils.makeFriendlyFilename(string);
    }

    private static String getClassPath(String[] stringArray, File file) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + File.pathSeparator);
        }
        if (file != null) {
            stringBuffer.append(file.toString());
        }
        return stringBuffer.toString();
    }
}

