/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.xml;

import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.MethodDescriptorNode;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IASApplicationRuntimeDescriptorNode
extends ElementNode {
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 J2EE Application 1.3//EN";
    public static String SYSTEM_ID = "http://www.sun.com/software/sunone/appserver/dtds/sun-application_1_3-0.dtd";
    public static String IAS_RUNTIME_TAG = "sun-application";
    private static String WEB = "web";
    private static String WEB_URI = "web-uri";
    private static String CONTEXT_ROOT = "context-root";
    private static String PASS_BY_REFERENCE = "pass-by-reference";
    private static String SECURITY_ROLE_MAPPING = "security-role-mapping";
    private static String ROLE_NAME = "role-name";
    private static String PRINCIPAL_NAME = "principal-name";
    private static String GROUP_NAME = "group-name";
    private static String UNIQUE_ID = "unique-id";
    private static final Logger _logger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(IASApplicationRuntimeDescriptorNode.class);

    public IASApplicationRuntimeDescriptorNode() {
        this.setTag(IAS_RUNTIME_TAG);
    }

    public void setDescriptor(Application application) {
        Object object;
        WebBundleDescriptor webBundleDescriptor;
        ElementNode elementNode;
        Object object2;
        if (this.getOwnerDocument() == null) {
            String string = localStrings.getString("enterprise.deployment.xml.error_setting_descriptor");
            throw new IllegalArgumentException(string);
        }
        XMLUtils xMLUtils = new XMLUtils(this.getOwnerDocument());
        ArrayList arrayList = application.getIasWebUriList();
        if (arrayList != null) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                elementNode = xMLUtils.getNode(WEB);
                this.appendChild((Node)elementNode);
                elementNode.appendChild((Node)xMLUtils.getTextNode(WEB_URI, string));
                webBundleDescriptor = application.getWebBundleDescriptorByUri(string);
                object = webBundleDescriptor.getContextRoot();
                elementNode.appendChild((Node)xMLUtils.getTextNode(CONTEXT_ROOT, (String)object));
                object = webBundleDescriptor.getSavedContextRoot();
                webBundleDescriptor.setContextRoot((String)object);
            }
        }
        if (application.isPassByReferenceDefined()) {
            object2 = String.valueOf(application.getPassByReference());
            this.appendChild((Node)xMLUtils.getTextNode(PASS_BY_REFERENCE, (String)object2));
        }
        object2 = String.valueOf(application.getUniqueId());
        this.appendChild((Node)xMLUtils.getTextNode(UNIQUE_ID, (String)object2));
        webBundleDescriptor = null;
        Enumeration enumeration = null;
        RoleMapper roleMapper = application.getRoleMapper();
        if (roleMapper != null) {
            object = roleMapper.getRoles();
            while (object.hasMoreElements()) {
                Principal principal;
                Role role = (Role)object.nextElement();
                ElementNode elementNode2 = xMLUtils.getNode(SECURITY_ROLE_MAPPING);
                this.appendChild((Node)elementNode2);
                ElementNode elementNode3 = xMLUtils.getTextNode(ROLE_NAME, role.getName());
                elementNode2.appendChild((Node)elementNode3);
                Enumeration enumeration2 = roleMapper.getUsersAssignedTo(role);
                if (enumeration2.hasMoreElements()) {
                    while (enumeration2.hasMoreElements()) {
                        principal = (Principal)enumeration2.nextElement();
                        ElementNode elementNode4 = xMLUtils.getTextNode(PRINCIPAL_NAME, principal.getName());
                        elementNode2.appendChild((Node)elementNode4);
                    }
                }
                if (!(enumeration = roleMapper.getGroupsAssignedTo(role)).hasMoreElements()) continue;
                while (enumeration.hasMoreElements()) {
                    principal = (Group)enumeration.nextElement();
                    elementNode = xMLUtils.getTextNode(GROUP_NAME, ((PrincipalImpl)principal).getName());
                    elementNode2.appendChild((Node)elementNode);
                }
            }
        }
    }

    private void storeSQLInfo(ElementNode elementNode, PersistenceDescriptor persistenceDescriptor, XMLUtils xMLUtils) {
    }

    public void updateIASApplicationRuntimeInformation(Application application) throws ContentTransformationException {
        Object object = this;
        try {
            Object object2;
            String string;
            WebBundleDescriptor webBundleDescriptor;
            Object object3;
            Object object4;
            String string2;
            ElementNode elementNode;
            Enumeration enumeration;
            Object object5;
            if (XMLUtils.hasNodesUnder((Node)((Object)this), WEB)) {
                object5 = application.getWebBundleDescriptors();
                enumeration = XMLUtils.getNodesUnder((Node)((Object)this), WEB);
                while (enumeration.hasMoreElements()) {
                    elementNode = (ElementNode)enumeration.nextElement();
                    object = elementNode;
                    string2 = XMLUtils.getTextFor(elementNode, WEB_URI);
                    object4 = XMLUtils.getTextFor(elementNode, CONTEXT_ROOT);
                    object3 = object5.iterator();
                    while (object3.hasNext()) {
                        webBundleDescriptor = (WebBundleDescriptor)object3.next();
                        string = webBundleDescriptor.getArchivist().getArchiveUri();
                        object2 = webBundleDescriptor.getContextRoot();
                        if (!string2.equals(string)) continue;
                        webBundleDescriptor.setContextRoot((String)object4);
                        webBundleDescriptor.setSavedContextRoot((String)object2);
                    }
                    application.addIasWebUri(string2);
                }
            }
            if (XMLUtils.hasNodesUnder((Node)((Object)this), PASS_BY_REFERENCE)) {
                object = XMLUtils.getFirstNodeUnder((Node)((Object)this), PASS_BY_REFERENCE);
                object5 = XMLUtils.getTextFor(this, PASS_BY_REFERENCE);
                application.setPassByReference(IASApplicationRuntimeDescriptorNode.getBooleanValue((String)object5, false));
            }
            if (XMLUtils.hasNodesUnder((Node)((Object)this), UNIQUE_ID)) {
                object = XMLUtils.getFirstNodeUnder((Node)((Object)this), UNIQUE_ID);
                object5 = XMLUtils.getTextFor(this, UNIQUE_ID);
                application.setUniqueId(Long.parseLong((String)object5));
            }
            if (XMLUtils.hasNodesUnder((Node)((Object)this), SECURITY_ROLE_MAPPING)) {
                object5 = application.getRoleMapper();
                ((RoleMapper)object5).unassignAllRoles();
                enumeration = XMLUtils.getNodesUnder((Node)((Object)this), SECURITY_ROLE_MAPPING);
                while (enumeration.hasMoreElements()) {
                    elementNode = (ElementNode)enumeration.nextElement();
                    object = elementNode;
                    string2 = XMLUtils.getTextFor(elementNode, ROLE_NAME);
                    object4 = new Role(string2);
                    object3 = XMLUtils.getNodesUnder((Node)elementNode, PRINCIPAL_NAME);
                    while (object3.hasMoreElements()) {
                        webBundleDescriptor = (ElementNode)object3.nextElement();
                        object = webBundleDescriptor;
                        string = XMLUtils.getTextFor((ElementNode)webBundleDescriptor, PRINCIPAL_NAME);
                        object2 = new PrincipalImpl(string);
                        ((RoleMapper)object5).assignRole((Principal)object2, (Role)object4);
                    }
                    object3 = XMLUtils.getNodesUnder((Node)elementNode, GROUP_NAME);
                    while (object3.hasMoreElements()) {
                        webBundleDescriptor = (ElementNode)object3.nextElement();
                        object = webBundleDescriptor;
                        string = XMLUtils.getTextFor((ElementNode)webBundleDescriptor, GROUP_NAME);
                        object2 = new Group(string);
                        ((RoleMapper)object5).assignRole((Principal)object2, (Role)object4);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.log(Level.WARNING, "enterprise.deployment_illarg", illegalArgumentException);
            throw new ContentTransformationException((application == null ? "" : application.getName()) + "\n" + illegalArgumentException.getMessage(), object.toString());
        }
        catch (Exception exception) {
            throw new ContentTransformationException((application == null ? "" : application.getName()) + "\n" + exception.getMessage(), object.toString());
        }
    }

    public static Vector readIASApplicationRuntimeDescriptorNodes(InputStream inputStream, boolean bl) throws ParseException {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(IAS_RUNTIME_TAG, "com.iplanet.ias.deployment.xml.IASApplicationRuntimeDescriptorNode");
            hashtable.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(IASApplicationRuntimeDescriptorNode.class, hashtable, inputStream, bl);
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException);
        }
        catch (Throwable throwable) {
            throw new ParseException(throwable.getMessage());
        }
    }

    public static IASApplicationRuntimeDescriptorNode read(InputStream inputStream, boolean bl) throws ParseException {
        Vector vector = IASApplicationRuntimeDescriptorNode.readIASApplicationRuntimeDescriptorNodes(inputStream, bl);
        if (vector == null || vector.size() == 0) {
            String string = localStrings.getStringWithDefault("enterprise.deployment.xml.error_no_app_runtime_nodes", "No Application Runtime Nodes were found");
            throw new ParseException(string);
        }
        IASApplicationRuntimeDescriptorNode iASApplicationRuntimeDescriptorNode = (IASApplicationRuntimeDescriptorNode)((Object)vector.elementAt(0));
        return iASApplicationRuntimeDescriptorNode;
    }

    public static XmlDocument getDocument(Application application) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(PUBLIC_DTD_ID, SYSTEM_ID, null);
        IASApplicationRuntimeDescriptorNode iASApplicationRuntimeDescriptorNode = new IASApplicationRuntimeDescriptorNode();
        xmlDocument.appendChild((Node)((Object)iASApplicationRuntimeDescriptorNode));
        iASApplicationRuntimeDescriptorNode.setDescriptor(application);
        return xmlDocument;
    }

    private static boolean getBooleanValue(String string, boolean bl) {
        try {
            String string2 = string.toLowerCase();
            return new Boolean(string2);
        }
        catch (Throwable throwable) {
            return bl;
        }
    }
}

