/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.xml;

import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.deployment.xml.IASEjbRuntimeDescriptorNode;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLUtils;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IASApplicationClientRuntimeDescriptorNode
extends ElementNode {
    public static String IAS_RUNTIME_TAG = "sun-application-client";
    private static final Logger _logger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(IASApplicationClientRuntimeDescriptorNode.class);

    public IASApplicationClientRuntimeDescriptorNode() {
        this.setTag(IAS_RUNTIME_TAG);
    }

    public void setDescriptor(ApplicationClientDescriptor applicationClientDescriptor) {
        ElementNode elementNode;
        EnvironmentProperty environmentProperty;
        if (this.getOwnerDocument() == null) {
            String string = localStrings.getString("enterprise.deployment.xml.error_setting_descriptor");
            throw new IllegalArgumentException(string);
        }
        XMLUtils xMLUtils = new XMLUtils(this.getOwnerDocument());
        _logger.fine("Begin Writing Sun Application Client Descriptor");
        Iterator iterator = applicationClientDescriptor.getResourceReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            environmentProperty = (ResourceReferenceDescriptor)iterator.next();
            elementNode = IASEjbRuntimeDescriptorNode.getResourceReferenceNodeFor((ResourceReferenceDescriptor)environmentProperty, xMLUtils);
            this.appendChild((Node)elementNode);
        }
        iterator = applicationClientDescriptor.getEjbReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            environmentProperty = (EjbReferenceDescriptor)iterator.next();
            elementNode = xMLUtils.getNode("ejb-ref");
            this.appendChild((Node)elementNode);
            elementNode.appendChild((Node)xMLUtils.getTextNode("ejb-ref-name", environmentProperty.getName()));
            elementNode.appendChild((Node)xMLUtils.getTextNode("jndi-name", ((EjbReferenceDescriptor)environmentProperty).getJndiName()));
        }
        IASEjbRuntimeDescriptorNode.setJmsDestinationReferenceInfo(applicationClientDescriptor, xMLUtils, this);
        _logger.fine("Finished Writing Sun Application Client Descriptor");
    }

    public void updateRuntimeInformation(ApplicationClientDescriptor applicationClientDescriptor) throws ContentTransformationException {
        IASApplicationClientRuntimeDescriptorNode iASApplicationClientRuntimeDescriptorNode = this;
        try {
            EnvironmentProperty environmentProperty;
            String string;
            ElementNode elementNode;
            Enumeration enumeration;
            _logger.fine("Begin Reading Sun Application Client Descriptor");
            if (XMLUtils.hasNodesUnder((Node)((Object)this), "resource-ref")) {
                enumeration = XMLUtils.getNodesUnder((Node)((Object)this), "resource-ref");
                while (enumeration.hasMoreElements()) {
                    elementNode = (ElementNode)enumeration.nextElement();
                    iASApplicationClientRuntimeDescriptorNode = elementNode;
                    string = XMLUtils.getTextFor(elementNode, "res-ref-name");
                    environmentProperty = applicationClientDescriptor.getResourceReferenceByName(string);
                    IASEjbRuntimeDescriptorNode.updateResourceReference((ResourceReferenceDescriptor)environmentProperty, elementNode);
                }
            }
            if (XMLUtils.hasNodesUnder((Node)((Object)this), "ejb-ref")) {
                enumeration = XMLUtils.getNodesUnder((Node)((Object)this), "ejb-ref");
                while (enumeration.hasMoreElements()) {
                    elementNode = (ElementNode)enumeration.nextElement();
                    iASApplicationClientRuntimeDescriptorNode = elementNode;
                    string = XMLUtils.getTextFor(elementNode, "ejb-ref-name");
                    environmentProperty = applicationClientDescriptor.getEjbReferenceByName(string);
                    ((EjbReferenceDescriptor)environmentProperty).setJndiName(XMLUtils.getTextFor(elementNode, "jndi-name"));
                }
            }
            IASEjbRuntimeDescriptorNode.updateJmsDestinationReferences(applicationClientDescriptor, this);
            _logger.fine("Finished Reading Sun Application Client Descriptor");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ContentTransformationException((applicationClientDescriptor == null ? "" : applicationClientDescriptor.getName()) + "\n" + illegalArgumentException.getMessage(), iASApplicationClientRuntimeDescriptorNode.toString());
        }
        catch (Exception exception) {
            throw new ContentTransformationException((applicationClientDescriptor == null ? "" : applicationClientDescriptor.getName()) + "\n" + exception.getMessage(), iASApplicationClientRuntimeDescriptorNode.toString());
        }
    }

    public static Vector readRuntimeNodes(InputStream inputStream, boolean bl) throws ParseException {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(IAS_RUNTIME_TAG, "com.iplanet.ias.deployment.xml.IASApplicationClientRuntimeDescriptorNode");
            return XMLUtils.getNodesByType(IASApplicationClientRuntimeDescriptorNode.class, hashtable, inputStream, bl);
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException);
        }
        catch (Throwable throwable) {
            throw new ParseException(throwable.getMessage());
        }
    }

    public static IASApplicationClientRuntimeDescriptorNode read(InputStream inputStream, boolean bl) throws ParseException {
        Vector vector = IASApplicationClientRuntimeDescriptorNode.readRuntimeNodes(inputStream, bl);
        if (vector == null || vector.size() == 0) {
            String string = localStrings.getStringWithDefault("enterprise.deployment.xml.error_no_appclient_runtime_nodes", "No Application Client Runtime Descriptor Nodes were found");
            throw new ParseException(string);
        }
        IASApplicationClientRuntimeDescriptorNode iASApplicationClientRuntimeDescriptorNode = (IASApplicationClientRuntimeDescriptorNode)((Object)vector.elementAt(0));
        return iASApplicationClientRuntimeDescriptorNode;
    }

    public static XmlDocument getDocument(ApplicationClientDescriptor applicationClientDescriptor) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Application Client 1.3//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-application-client_1_3-0.dtd", null);
        IASApplicationClientRuntimeDescriptorNode iASApplicationClientRuntimeDescriptorNode = new IASApplicationClientRuntimeDescriptorNode();
        xmlDocument.appendChild((Node)((Object)iASApplicationClientRuntimeDescriptorNode));
        iASApplicationClientRuntimeDescriptorNode.setDescriptor(applicationClientDescriptor);
        return xmlDocument;
    }
}

