/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.ui;

import com.iplanet.ias.util.OS;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.Reporter;
import com.iplanet.ias.util.diagnostics.SystemProps;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SystemPropertiesSetter {
    private static final boolean debug = false;
    private static final String IAS_SERVER_HOME = "com.sun.aas.instanceRoot";
    private static final String RI_SERVER_HOME = "com.sun.enterprise.home";
    private static final String SYSTEM_PROPS_FILENAME = "ias_startup.properties";
    private static String DEFAULT_IAS_UNIX_HOME = "/j2ee";
    private static String DEFAULT_IAS_WIN_HOME = "C:\\j2ee";
    private static String REPORTER_LEVEL = "com.iplanet.util.diagnostic.Reporter.severityLevel";
    private static final String STARS = "****************************************************";
    private String computerName;
    private Properties iasProps;
    private File propsFile = null;
    private static boolean byron = false;

    public SystemPropertiesSetter(Properties properties) {
        this.iasProps = properties;
        this.set();
    }

    public SystemPropertiesSetter() {
        String string = System.getProperty(IAS_SERVER_HOME);
        Reporter.crit("home: " + string);
        if (string == null || string.length() <= 0) {
            String string2 = File.separatorChar == '\\' ? DEFAULT_IAS_WIN_HOME : DEFAULT_IAS_UNIX_HOME;
            this.propsFile = new File(string2, SYSTEM_PROPS_FILENAME);
            Reporter.verbose("Null or empty required command-line define: com.sun.aas.instanceRoot\nTrying the default: " + FileUtils.safeGetCanonicalPath(this.propsFile));
        } else {
            this.propsFile = new File(new File(string), SYSTEM_PROPS_FILENAME);
        }
        this.checkPropsFile();
        if (this.propsFile == null) {
            return;
        }
        this.readProps();
        this.set();
    }

    public SystemPropertiesSetter(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        this.propsFile = file.isDirectory() ? new File(file, SYSTEM_PROPS_FILENAME) : file;
        this.checkPropsFile();
        if (this.propsFile == null) {
            return;
        }
        this.readProps();
        this.set();
    }

    public SystemPropertiesSetter(String string) {
        this(new File(string));
    }

    private void set() {
        this.setComputerName();
        this.trimProps();
        this.replaceMacros();
        this.setReporter();
        this.removePropsAlreadyInSystem();
        this.fixFilePaths();
        this.addToSystemProps();
    }

    private void checkPropsFile() {
        if (this.propsFile == null) {
            return;
        }
        if (!this.propsFile.exists()) {
            Reporter.error("System Properties File points to a file that doesn't exist: " + this.propsFile);
            this.propsFile = null;
            return;
        }
        if (this.propsFile.isDirectory()) {
            Reporter.error("System Properties File points to a directory, not a file: " + this.propsFile);
            this.propsFile = null;
            return;
        }
        Reporter.verbose("Using System Properties File: " + this.propsFile);
    }

    private void readProps() {
        new File(this.propsFile, SYSTEM_PROPS_FILENAME);
        if (!this.propsFile.exists()) {
            this.goodbye("ias Startup Properties file doesn't exist: " + this.propsFile.getAbsolutePath());
        }
        if (this.propsFile.isDirectory()) {
            this.goodbye("ias Startup Properties file isn't a file.  It is a directory: " + this.propsFile.getAbsolutePath());
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.propsFile);
            this.iasProps = new Properties();
            this.iasProps.load(fileInputStream);
        }
        catch (Exception exception) {
            this.goodbye("Error reading iAS Server Properties, File: " + this.propsFile.getAbsolutePath() + ", " + exception);
        }
    }

    private void trimProps() {
        Iterator iterator = this.getSetIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getValue();
            entry.setValue(string.trim());
        }
    }

    private void setComputerName() {
        try {
            this.computerName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.goodbye("Can't figure out what the computer's name is. InetAddress.getLocalHost().getHostName() threw an Exception: " + exception);
        }
    }

    private void replaceMacros() {
        String string = "%IAS_HOME%";
        String string2 = this.getIasDir();
        String string3 = "%COMPUTER_NAME%";
        String string4 = this.computerName;
        Iterator iterator = this.getSetIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string5 = (String)entry.getValue();
            string5 = StringUtils.replace((String)string5, (String)string, (String)string2);
            string5 = StringUtils.replace((String)string5, (String)string3, (String)string4);
            entry.setValue(string5);
        }
    }

    private void setReporter() {
        String string = System.getProperty(REPORTER_LEVEL);
        if (!StringUtils.ok((String)string)) {
            string = this.iasProps.getProperty(REPORTER_LEVEL);
        }
        if (StringUtils.ok((String)string)) {
            Reporter.setSeverityLevel(string);
        } else {
            Reporter.setSeverityLevel(1000);
        }
    }

    private String getIasDir() {
        String string = this.iasProps.getProperty(IAS_SERVER_HOME);
        if (StringUtils.ok((String)string)) {
            return string;
        }
        string = System.getProperty(IAS_SERVER_HOME);
        if (StringUtils.ok((String)string)) {
            return string;
        }
        string = this.iasProps.getProperty(RI_SERVER_HOME);
        if (StringUtils.ok((String)string)) {
            return string;
        }
        string = System.getProperty(RI_SERVER_HOME);
        if (StringUtils.ok((String)string)) {
            return string;
        }
        string = this.getDefaultIasHome();
        Reporter.verbose("Setting com.sun.aas.instanceRoot and com.sun.enterprise.hometo: " + string);
        this.iasProps.setProperty(IAS_SERVER_HOME, string);
        this.iasProps.setProperty(RI_SERVER_HOME, string);
        return string;
    }

    private void removePropsAlreadyInSystem() {
        Iterator iterator = this.getSetIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            if (System.getProperty(string) == null) continue;
            iterator.remove();
        }
    }

    private void fixFilePaths() {
        Iterator iterator = this.getSetIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getValue();
            if (string.indexOf(47) < 0 && string.indexOf(92) < 0) continue;
            string = OS.isUNIX() ? string.replace('\\', '/') : string.replace('/', '\\');
            entry.setValue(string);
        }
    }

    private void addToSystemProps() {
        if (this.iasProps.size() <= 0) {
            return;
        }
        Properties properties = System.getProperties();
        properties.putAll((Map<?, ?>)this.iasProps);
        System.setProperties(properties);
    }

    private void dumpNewSystemProps() {
        Map.Entry entry;
        int n = 0;
        System.out.println("About to add these properties to the system:");
        Iterator iterator = this.getSetIterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            int n2 = ((String)entry.getKey()).length();
            if (n2 <= n) continue;
            n = n2;
        }
        ++n;
        iterator = this.getSetIterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            String string = StringUtils.padRight((String)((String)entry.getKey()), (int)n);
            string = string + "= ";
            string = string + (String)entry.getValue();
            System.out.println(string);
        }
    }

    private Iterator getSetIterator() {
        Set<Map.Entry<Object, Object>> set = this.iasProps.entrySet();
        return set.iterator();
    }

    private void goodbye(String string) {
        System.out.println("****************************************************\n**** Can't start Server: " + string + "\n" + STARS);
        System.exit(1);
    }

    private String getDefaultIasHome() {
        if (OS.isWindows()) {
            return DEFAULT_IAS_WIN_HOME;
        }
        return DEFAULT_IAS_UNIX_HOME;
    }

    public static void main(String[] stringArray) {
        Reporter.setSeverityLevel(0);
        if (byron) {
            stringArray = new String[]{"C:\\j2ee\\config", "C:\\iplanet\\ias7se_src\\iplanet\\ias\\server\\src\\java\\com\\iplanet\\ias\\deployment\\ias_startup.properties"};
        }
        Reporter.verbose("Testing the default location...");
        new SystemPropertiesSetter();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            Reporter.verbose("Testing arg" + i);
            new SystemPropertiesSetter(new File(stringArray[i]));
        }
        System.out.println(SystemProps.toStringStatic());
    }
}

