/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.backend.WebModuleInfo;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFile;
import com.iplanet.ias.util.zip.ZipFileException;
import java.io.File;

public class WarExploder {
    File war;
    File dir;
    WebModuleInfo info;
    private static StringManager localStrings = StringManager.getManager(WarExploder.class);

    WarExploder(File file, File file2, String string) throws IASDeploymentException {
        this.ctor(file, file2, string);
    }

    public WarExploder(File file, File file2) throws IASDeploymentException {
        String string = FileUtils.makeFriendlyFilename(file2.getName());
        File file3 = new File(file, string);
        this.ctor(file3, file2, string);
    }

    private void ctor(File file, File file2, String string) throws IASDeploymentException {
        this.dir = file;
        this.war = file2;
        String string2 = this.war.getName();
        if (!FileUtils.isWar(string2)) {
            String string3 = localStrings.getString("enterprise.deployment.filename_not_war", string2);
            throw new IASDeploymentException(string3);
        }
        this.dir.mkdirs();
        if (!FileUtils.safeIsDirectory(this.dir)) {
            String string4 = localStrings.getString("enterprise.deployment.backend.error_creating_module_directory", this.dir);
            throw new IASDeploymentException(string4);
        }
        this.info = new WebModuleInfo(this.dir, string, this.war);
    }

    public WebModuleInfo explode() throws ZipFileException {
        ZipFile zipFile = new ZipFile(this.war, this.dir);
        zipFile.explode();
        return this.info;
    }
}

