/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.AppDD;
import com.iplanet.ias.deployment.backend.AppInfo;
import com.iplanet.ias.deployment.backend.ClientExploder;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.backend.JarExploder;
import com.iplanet.ias.deployment.backend.RarExploder;
import com.iplanet.ias.deployment.backend.WarExploder;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFile;
import com.iplanet.ias.util.zip.ZipFileException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EarExploder {
    private boolean useHomemade = false;
    private File appDir;
    private File ear;
    private AppInfo info;
    private ArrayList files;
    private String[] ejbs;
    private String[] wars;
    private String[] clients;
    private String[] rars;
    private static StringManager localStrings;
    private static final String VERIFY_ERR;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EarExploder(AppInfo appInfo) {
        if (!$assertionsDisabled && appInfo == null) {
            throw new AssertionError();
        }
        this.info = appInfo;
        this.appDir = this.info.getRootPath();
        this.ear = this.info.getArchive();
        if (!$assertionsDisabled && this.ear == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.appDir == null) {
            throw new AssertionError();
        }
    }

    public EarExploder(AppInfo appInfo, boolean bl) {
        this(appInfo);
        this.useHomemade = bl;
    }

    public void explode() throws ZipFileException, IASDeploymentException {
        ZipFile zipFile = new ZipFile(this.ear, this.appDir);
        this.files = zipFile.explode();
        this.createModulesList();
        this.verify();
        this.explodeEjbs();
        this.explodeWars();
        this.explodeRars();
        this.explodeClients();
        DirInfo.cleanupExtraDirectories();
    }

    private void explodeEjbs() throws IASDeploymentException, ZipFileException {
        for (int i = 0; this.ejbs != null && i < this.ejbs.length; ++i) {
            DirInfo dirInfo = new DirInfo(this.ejbs[i], this.appDir);
            JarExploder jarExploder = new JarExploder(dirInfo.moduleDir, dirInfo.archiveFile, dirInfo.massagedModuleName);
            jarExploder.explode();
            dirInfo.cleanup();
        }
    }

    private void explodeWars() throws IASDeploymentException, ZipFileException {
        for (int i = 0; this.wars != null && i < this.wars.length; ++i) {
            DirInfo dirInfo = new DirInfo(this.wars[i], this.appDir);
            WarExploder warExploder = new WarExploder(dirInfo.moduleDir, dirInfo.archiveFile, dirInfo.massagedModuleName);
            warExploder.explode();
            dirInfo.cleanup();
        }
    }

    private void explodeRars() throws IASDeploymentException, ZipFileException {
        for (int i = 0; this.rars != null && i < this.rars.length; ++i) {
            DirInfo dirInfo = new DirInfo(this.rars[i], this.appDir);
            RarExploder rarExploder = new RarExploder(dirInfo.moduleDir, dirInfo.archiveFile, dirInfo.massagedModuleName);
            rarExploder.explode();
            dirInfo.cleanup();
        }
    }

    private void explodeClients() throws IASDeploymentException, ZipFileException {
        for (int i = 0; this.clients != null && i < this.clients.length; ++i) {
            DirInfo dirInfo = new DirInfo(this.clients[i], this.appDir);
            ClientExploder clientExploder = new ClientExploder(dirInfo.moduleDir, dirInfo.archiveFile, dirInfo.massagedModuleName);
            clientExploder.explode();
            dirInfo.cleanup();
        }
    }

    private void verify() throws IASDeploymentException {
        this.verifyModulesExist();
    }

    private void createModulesList() throws IASDeploymentException {
        try {
            AppDD appDD = new AppDD(this.appDir, this.useHomemade);
            this.ejbs = appDD.getEjbModules();
            this.wars = appDD.getWarModules();
            this.clients = appDD.getClientModules();
            this.rars = appDD.getRarModules();
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception.toString());
        }
    }

    private void verifyModulesExist() throws IASDeploymentException {
        int n;
        String string = "Verify Error: Module specified in application.xml not found in ear file: ";
        String string2 = "Verify Error: Illegal module name in Application.xml: ";
        for (n = 0; n < this.ejbs.length; ++n) {
            if (!this.files.contains(this.ejbs[n])) {
                String string3 = localStrings.getString("enterprise.deployment.backend.verify_error_module_not_present_in_ear", this.ejbs[n]);
                throw new IASDeploymentException(string3);
            }
            if (FileUtils.isJar(this.ejbs[n])) continue;
            String string4 = localStrings.getString("enterprise.deployment.backend.verify_error_illegal_module_name", this.ejbs[n]);
            throw new IASDeploymentException(string4);
        }
        for (n = 0; n < this.wars.length; ++n) {
            if (!this.files.contains(this.wars[n])) {
                String string5 = localStrings.getString("enterprise.deployment.backend.verify_error_module_not_present_in_ear", this.wars[n]);
                throw new IASDeploymentException(string5);
            }
            if (FileUtils.isWar(this.wars[n])) continue;
            String string6 = localStrings.getString("enterprise.deployment.backend.verify_error_illegal_module_name", this.wars[n]);
            throw new IASDeploymentException(string6);
        }
        for (n = 0; n < this.rars.length; ++n) {
            if (!this.files.contains(this.rars[n])) {
                String string7 = localStrings.getString("enterprise.deployment.backend.verify_error_module_not_present_in_ear", this.rars[n]);
                throw new IASDeploymentException(string7);
            }
            if (FileUtils.isRar(this.rars[n])) continue;
            String string8 = localStrings.getString("enterprise.deployment.backend.verify_error_illegal_module_name", this.rars[n]);
            throw new IASDeploymentException(string8);
        }
        for (n = 0; n < this.clients.length; ++n) {
            if (!this.files.contains(this.clients[n])) {
                String string9 = localStrings.getString("enterprise.deployment.backend.verify_error_module_not_present_in_ear", this.clients[n]);
                throw new IASDeploymentException(string9);
            }
            if (FileUtils.isJar(this.clients[n])) continue;
            String string10 = localStrings.getString("enterprise.deployment.backend.verify_error_illegal_module_name", this.clients[n]);
            throw new IASDeploymentException(string10);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            System.out.println("Usage: java com.iplanet.ias.deployment.backend.EarExploder ear-filename Root-Directory-To-explode-In");
            return;
        }
        String string = stringArray[0];
        File file = new File(stringArray[1]);
        if (!FileUtils.isEar(string)) {
            System.out.println("Argument isn't an ear file: " + string);
            return;
        }
        String string2 = FileUtils.makeFriendlyFileNameNoExtension(string);
        File file2 = new File(file, string2);
        File file3 = new File(file2, "stubs");
        file3.mkdirs();
        AppInfo appInfo = new AppInfo(file2, string2, new File(string));
        EarExploder earExploder = new EarExploder(appInfo, true);
        try {
            earExploder.explode();
            System.out.println("" + appInfo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("**** Successful Ear Explosion ****");
        System.exit(0);
    }

    static {
        $assertionsDisabled = !EarExploder.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(EarExploder.class);
        VERIFY_ERR = localStrings.getString("enterprise.deployment.backend.earexploder_verify_error");
    }

    private static class DirInfo {
        private File appDir;
        private String moduleName;
        private String massagedModuleName;
        private File archiveFile;
        private File moduleDir;
        private static Set instances = new HashSet();

        private DirInfo(String string, File file) throws IASDeploymentException {
            this.appDir = file;
            this.moduleName = string;
            this.massagedModuleName = FileUtils.makeFriendlyFilename(this.moduleName);
            this.archiveFile = new File(this.appDir, this.removeLeadingSlashes(this.moduleName));
            this.moduleDir = new File(this.appDir, this.massagedModuleName);
            instances.add(this);
        }

        private String removeLeadingSlashes(String string) throws IASDeploymentException {
            char c;
            String string2 = string;
            while (string2.length() > 0 && ((c = string2.charAt(0)) == '/' || c == '\\')) {
                string2 = string2.substring(1);
            }
            if (string2.length() <= 0) {
                throw new IASDeploymentException("Illegal module filename: " + string);
            }
            return string2;
        }

        private void cleanup() {
            if (!this.archiveFile.delete()) {
                this.archiveFile.deleteOnExit();
            }
        }

        private static void cleanupExtraDirectories() {
            Iterator iterator = instances.iterator();
            while (iterator.hasNext()) {
                DirInfo dirInfo = (DirInfo)iterator.next();
                for (File file = dirInfo.archiveFile.getParentFile(); file != null && !file.equals(dirInfo.appDir); file = file.getParentFile()) {
                    File file2 = file;
                    if (!FileUtils.safeIsDirectory(file2) || file2.delete()) continue;
                    file2.deleteOnExit();
                }
            }
            instances.clear();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("DirInfo Dump:\n");
            stringBuffer.append("appDir: " + this.appDir.getPath());
            stringBuffer.append("\nmoduleName: " + this.moduleName);
            stringBuffer.append("\nmassagedModuleName: " + this.massagedModuleName);
            stringBuffer.append("\narchiveFile: " + this.archiveFile.getPath());
            stringBuffer.append("\nmoduleDir: " + this.moduleDir.getPath());
            return stringBuffer.toString();
        }
    }
}

