/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;

public class DirNameManager {
    private File parent;
    private File oldDir;
    private String name;
    private int startingVersion = 1;
    private static StringManager localStrings = StringManager.getManager(DirNameManager.class);

    DirNameManager(File file, File file2, String string) throws IASDeploymentException {
        if (file == null) {
            String string2 = localStrings.getString("enterprise.deployment.backend.null_parent_dir");
            throw new IASDeploymentException(string2);
        }
        file.mkdirs();
        try {
            this.parent = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            this.parent = file.getAbsoluteFile();
        }
        if (!this.parent.exists()) {
            String string3 = localStrings.getString("enterprise.deployment.backend.parent_dir_does_not_exist");
            throw new IASDeploymentException(string3);
        }
        if (!this.parent.isDirectory()) {
            String string4 = localStrings.getString("enterprise.deployment.backend.parent_dir_not_a_directory");
            throw new IASDeploymentException(string4);
        }
        if (!StringUtils.ok((String)string)) {
            String string5 = localStrings.getString("enterprise.deployment.backend.dirnamemanager_null_name");
            throw new IASDeploymentException(string5);
        }
        this.name = string;
        this.oldDir = file2;
    }

    File getNewDir() throws IASDeploymentException {
        File file;
        this.setStartingVersion();
        while ((file = new File(this.parent, this.name + "_" + this.startingVersion++)).exists()) {
        }
        return file;
    }

    private void setStartingVersion() {
        this.startingVersion = 1;
        if (this.oldDir == null) {
            return;
        }
        String string = this.oldDir.getName();
        if (!StringUtils.ok((String)string)) {
            return;
        }
        int n = string.lastIndexOf(95);
        if (n < 0) {
            return;
        }
        if (n + 1 >= string.length()) {
            return;
        }
        String string2 = string.substring(n + 1);
        try {
            this.startingVersion = Integer.parseInt(string2) + 1;
        }
        catch (NumberFormatException numberFormatException) {
            this.startingVersion = 1;
        }
        if (this.startingVersion < 1) {
            this.startingVersion = 1;
        }
    }
}

