/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.DeployableObjectType;
import com.iplanet.ias.deployment.backend.DeploymentCommand;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.instance.ApplicationEnvironment;
import com.iplanet.ias.instance.AppsManager;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ModuleEnvironment;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.ObjectAnalyzer;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileSource;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;
import java.util.List;
import java.util.Properties;

public class DeploymentRequest {
    private FileSource fileSource = null;
    private DeployableObjectType type = null;
    private DeploymentCommand command = null;
    private String name = null;
    private String contextRoot = null;
    private InstanceEnvironment instanceEnv = null;
    private ApplicationEnvironment appEnv = null;
    private ModuleEnvironment moduleEnv = null;
    private File clientJar = null;
    private File deployedDirectory = null;
    private File jspDirectory = null;
    private File stubsDirectory = null;
    private boolean shared = false;
    private boolean forced = false;
    private boolean isVerified = false;
    private boolean isVerifying = false;
    private boolean debug = false;
    private boolean noEJBC = false;
    private boolean precompileJSP = false;
    private List parentClasspath = null;
    private ClassLoader parentClassLoader = null;
    private List ejbClasspath = null;
    private ClassLoader ejbClassLoader = null;
    private boolean isAdminServer = true;
    private Properties optionalAttributes = null;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DeploymentRequest(InstanceEnvironment instanceEnvironment, DeployableObjectType deployableObjectType, DeploymentCommand deploymentCommand) throws IASDeploymentException {
        this.instanceEnv = instanceEnvironment;
        this.setType(deployableObjectType);
        this.setCommand(deploymentCommand);
    }

    public void verify() throws IASDeploymentException {
        if (this.isVerified) {
            return;
        }
        if (this.isFileSourceRequired() && this.fileSource == null) {
            String string = localStrings.getString("enterprise.deployment.backend.file_source_required");
            throw new IASDeploymentException(string);
        }
        if (this.isNameRequired() && this.name == null) {
            String string = localStrings.getString("enterprise.deployment.backend.name_required");
            throw new IASDeploymentException(string);
        }
        if (this.isContextRootRequired() && this.contextRoot == null) {
            String string = localStrings.getString("enterprise.deployment.backend.context_root_required");
            throw new IASDeploymentException(string);
        }
        if (this.name == null) {
            this.createName();
        }
        if (!FileUtils.isLegalFilename(this.name)) {
            String string = localStrings.getString("enterprise.deployment.backend.illegal_characters_in_component_name", FileUtils.getIllegalFilenameCharacters());
            throw new IASDeploymentException(string);
        }
        this.setEnv();
        this.checkForRedeploy();
        this.isVerified = true;
    }

    public void setName(String string) throws IASDeploymentException {
        if (StringUtils.ok((String)string)) {
            this.name = string;
        } else if (this.isNameRequired()) {
            String string2 = localStrings.getString("enterprise.deployment.backend.null_setname");
            throw new IASDeploymentException(string2);
        }
    }

    public void setFileSource(String string) throws IASDeploymentException {
        this.setFileSource(new File(string));
    }

    public void setFileSource(File file) throws IASDeploymentException {
        block3: {
            this.fileSource = null;
            if (file == null && !this.isFileSourceRequired()) {
                return;
            }
            try {
                this.fileSource = new FileSource(file);
            }
            catch (Exception exception) {
                if (!this.isFileSourceRequired()) break block3;
                throw new IASDeploymentException("DeploymentRequest.setFileSource()" + exception);
            }
        }
    }

    public void setShared(boolean bl) throws IASDeploymentException {
        if (!this.isEjbModule()) {
            String string = localStrings.getString("enterprise.deployment.backend.cannot_set_shared_flag");
            throw new IASDeploymentException(string);
        }
        this.shared = bl;
    }

    public void setForced(boolean bl) {
        this.forced = bl;
    }

    public void setPrecompileJSP(boolean bl) {
        this.precompileJSP = bl;
    }

    public boolean getPrecompileJSP() {
        return this.precompileJSP;
    }

    public void iAmNotAnAdminServer() {
        this.isAdminServer = false;
    }

    boolean amIAnAdminServer() {
        return this.isAdminServer;
    }

    public boolean isForced() {
        return this.forced;
    }

    public File getClientJar() {
        return this.clientJar;
    }

    public boolean isApplication() {
        return DeployableObjectType.APP.equals(this.type);
    }

    public void setContextRoot(String string) {
        this.contextRoot = string;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public boolean isModule() {
        return this.isWebModule() || this.isEjbModule() || this.isConnectorModule();
    }

    public boolean isSharedModule() {
        return this.isModule() && this.shared;
    }

    public boolean isStandAloneModule() {
        return this.isModule() && !this.shared;
    }

    public boolean isWebModule() {
        return DeployableObjectType.WEB.equals(this.type);
    }

    public boolean isEjbModule() {
        return DeployableObjectType.EJB.equals(this.type);
    }

    public boolean isConnectorModule() {
        return DeployableObjectType.CONN.equals(this.type);
    }

    public boolean isDeploy() throws IASDeploymentException {
        if (this.command == null) {
            String string = localStrings.getString("enterprise.deployment.backend.no_command");
            throw new IASDeploymentException(string);
        }
        return this.command.equals(DeploymentCommand.DEPLOY);
    }

    public boolean isReDeploy() throws IASDeploymentException {
        if (this.command == null) {
            String string = localStrings.getString("enterprise.deployment.backend.no_command");
            throw new IASDeploymentException(string);
        }
        return this.command.equals(DeploymentCommand.REDEPLOY);
    }

    public boolean isUnDeploy() throws IASDeploymentException {
        if (this.command == null) {
            String string = localStrings.getString("enterprise.deployment.backend.no_command");
            throw new IASDeploymentException(string);
        }
        return this.command.equals(DeploymentCommand.UNDEPLOY);
    }

    public boolean isArchive() throws IASDeploymentException {
        if (this.isUnDeploy()) {
            String string = localStrings.getString("enterprise.deployment.backend.invalid_isarchive_call");
            throw new IASDeploymentException(string);
        }
        return this.getFileSource().isArchive();
    }

    public boolean isDirectory() throws IASDeploymentException {
        if (this.isUnDeploy()) {
            return false;
        }
        return this.getFileSource().isDirectory();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return ObjectAnalyzer.toString(this);
    }

    public void setDebug(boolean bl) {
        this.debug = true;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setNoEJBC() {
        this.noEJBC = true;
    }

    public boolean getNoEJBC() {
        return this.noEJBC;
    }

    public void setVerifying(boolean bl) {
        this.isVerifying = bl;
    }

    public boolean isVerifying() {
        return this.isVerifying;
    }

    public File getDeployedDirectory() {
        if (!FileUtils.safeIsDirectory(this.deployedDirectory)) {
            this.deployedDirectory = null;
        }
        return this.deployedDirectory;
    }

    public File getStubsDirectory() {
        if (!FileUtils.safeIsDirectory(this.stubsDirectory)) {
            this.stubsDirectory = null;
        }
        return this.stubsDirectory;
    }

    public File getJSPDirectory() {
        if (!FileUtils.safeIsDirectory(this.jspDirectory)) {
            this.jspDirectory = null;
        }
        return this.jspDirectory;
    }

    void setClientJar(File file) {
        this.clientJar = file;
    }

    FileSource getFileSource() {
        return this.fileSource;
    }

    DeployableObjectType getType() {
        return this.type;
    }

    DeploymentCommand getCommand() {
        return this.command;
    }

    String getInstanceName() {
        return this.instanceEnv.getName();
    }

    InstanceEnvironment getInstanceEnv() {
        return this.instanceEnv;
    }

    ApplicationEnvironment getAppEnv() throws IASDeploymentException {
        if (!this.isApplication()) {
            String string = localStrings.getString("enterprise.deployment.backend.illegal_getapplicationenv_call");
            throw new IASDeploymentException(string);
        }
        return this.appEnv;
    }

    ModuleEnvironment getModuleEnv() throws IASDeploymentException {
        if (!this.isModule()) {
            String string = localStrings.getString("enterprise.deployment.backend.illegal_getmoduleenv_call");
            throw new IASDeploymentException(string);
        }
        return this.moduleEnv;
    }

    boolean isEar() {
        return this.isApplication() && this.fileSource.isArchive() && FileUtils.isEar(this.fileSource.getSource());
    }

    boolean isWar() {
        return this.isWebModule() && this.fileSource.isArchive() && FileUtils.isWar(this.fileSource.getSource());
    }

    boolean isEjbJar() {
        return this.isEjbModule() && this.fileSource.isArchive() && FileUtils.isJar(this.fileSource.getSource());
    }

    void setParentClassLoader(ClassLoader classLoader) {
        this.parentClassLoader = classLoader;
    }

    ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    void setParentClasspath(List list) {
        this.parentClasspath = list;
    }

    List getParentClasspath() {
        return this.parentClasspath;
    }

    public void setOptionalAttributes(Properties properties) {
        this.optionalAttributes = properties;
    }

    public Properties getOptionalAttributes() {
        return this.optionalAttributes;
    }

    void setEjbClassLoader(ClassLoader classLoader) {
        this.ejbClassLoader = classLoader;
    }

    ClassLoader getEjbClassLoader() {
        return this.ejbClassLoader;
    }

    void setEjbClasspath(List list) {
        this.ejbClasspath = list;
    }

    List getEjbClasspath() {
        return this.ejbClasspath;
    }

    public void setDeployedDirectory(File file) {
        this.deployedDirectory = file;
    }

    public void setStubsDirectory(File file) {
        this.stubsDirectory = file;
    }

    public void setJSPDirectory(File file) {
        this.jspDirectory = file;
    }

    private boolean isFileSourceRequired() throws IASDeploymentException {
        return !this.isUnDeploy();
    }

    private boolean isNameRequired() throws IASDeploymentException {
        return !this.isDeploy();
    }

    private boolean isContextRootRequired() throws IASDeploymentException {
        return this.isWebModule() && (this.isDeploy() || this.isReDeploy());
    }

    private void setType(DeployableObjectType deployableObjectType) throws IASDeploymentException {
        this.type = deployableObjectType;
        this.shared = this.isConnectorModule();
    }

    void setCommand(DeploymentCommand deploymentCommand) throws IASDeploymentException {
        this.command = deploymentCommand;
        if (this.command == null) {
            String string = localStrings.getString("enterprise.deployment.backend.null_command_type");
            throw new IASDeploymentException(string);
        }
    }

    private void setEnv() throws IASDeploymentException {
        if (this.instanceEnv == null) {
            String string = localStrings.getString("enterprise.deployment.backend.null_instanceenvironment");
            throw new IASDeploymentException(string);
        }
        if (this.isApplication()) {
            this.appEnv = new ApplicationEnvironment(this.instanceEnv, this.name);
        } else if (this.isWebModule()) {
            this.moduleEnv = new ModuleEnvironment(this.instanceEnv, this.name, DeployableObjectType.WEB);
        } else if (this.isEjbModule()) {
            this.moduleEnv = new ModuleEnvironment(this.instanceEnv, this.name, DeployableObjectType.EJB);
        } else if (this.isConnectorModule()) {
            this.moduleEnv = new ModuleEnvironment(this.instanceEnv, this.name, DeployableObjectType.CONN);
        } else {
            String string = localStrings.getString("enterprise.deployment.backend.unknown_deployable_object", this.getClass().getName());
            throw new IASDeploymentException(string);
        }
    }

    private void createName() {
        String string = this.fileSource.getSource().getName();
        this.name = this.isEar() ? FileUtils.makeFriendlyFilenameNoExtension(string) : FileUtils.makeFriendlyFilename(string);
    }

    private void checkForRedeploy() throws IASDeploymentException {
        if (this.isUnDeploy()) {
            return;
        }
        if (!($assertionsDisabled || this.appEnv != null && this.moduleEnv == null || this.appEnv == null && this.moduleEnv != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isVerified) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !StringUtils.ok((String)this.name)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.instanceEnv == null) {
            throw new AssertionError();
        }
        if (this.moduleEnv != null) {
            return;
        }
        try {
            AppsManager appsManager = new AppsManager(this.instanceEnv);
            boolean bl = appsManager.isRegistered(this.name);
            if (this.forced && bl && this.isDeploy()) {
                this.command = DeploymentCommand.REDEPLOY;
            }
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    static {
        $assertionsDisabled = !DeploymentRequest.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(DeploymentRequest.class);
    }
}

