/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.WebModule;
import com.iplanet.ias.deployment.backend.AppDD;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.instance.AppsManager;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.WebModulesManager;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class ContextRootChecker {
    private static Map serverXMLtimeStampMap;
    private static Map instanceMap;
    private InstanceEnvironment iEnv;
    private String[] contextRoots;
    private AppsManager appMgr;
    private WebModulesManager webMgr;
    private String instanceName;
    private String appName = null;
    private String webName = null;
    private String matchDescription = null;
    private static final long fileWriteLatencyMilliSec = 5000L;
    private final Logger logger = DeploymentLogger.get();
    private static StringManager localStrings;
    private static final String ctorErr = "Internal Error: call to ContextRootChecker.ContextRootChecker with ";
    private static final String undeployErr;
    static final /* synthetic */ boolean $assertionsDisabled;

    ContextRootChecker(InstanceEnvironment instanceEnvironment, String[] stringArray, AppsManager appsManager, String string) throws IASDeploymentException {
        this.preCtor(instanceEnvironment, stringArray);
        this.appMgr = appsManager;
        this.appName = string;
        if (appsManager == null) {
            String string2 = localStrings.getString("enterprise.deployment.backend.null_appsmanager_object");
            throw new IASDeploymentException(string2);
        }
        if (!StringUtils.ok((String)string)) {
            String string3 = localStrings.getString("enterprise.deployment.backend.null_appName");
            throw new IASDeploymentException(string3);
        }
        try {
            this.webMgr = new WebModulesManager(instanceEnvironment);
        }
        catch (ConfigException configException) {
            String string4 = localStrings.getString("enterprise.deployment.backend.error_creating_webmodulesmanager", configException);
            throw new IASDeploymentException(string4, configException);
        }
    }

    ContextRootChecker(InstanceEnvironment instanceEnvironment, String[] stringArray, WebModulesManager webModulesManager, String string) throws IASDeploymentException {
        this.preCtor(instanceEnvironment, stringArray);
        this.webMgr = webModulesManager;
        this.webName = string;
        if (webModulesManager == null) {
            String string2 = localStrings.getString("enterprise.deployment.backend.null_webmodulesmanager_object");
            throw new IASDeploymentException(string2);
        }
        if (!StringUtils.ok((String)string)) {
            String string3 = localStrings.getString("enterprise.deployment.backend.null_webname");
            throw new IASDeploymentException(string3);
        }
        try {
            this.appMgr = new AppsManager(instanceEnvironment);
        }
        catch (ConfigException configException) {
            String string4 = localStrings.getString("enterprise.deployment.backend.error_creating_appsmanager", configException);
            throw new IASDeploymentException(string4, configException);
        }
    }

    void check() throws IASDeploymentException {
        if (this.alreadyExists()) {
            String string = localStrings.getString("enterprise.deployment.backend.context_root_exists", this.matchDescription);
            throw new IASDeploymentException(string);
        }
    }

    static synchronized void checkTimeStamp(InstanceEnvironment instanceEnvironment) {
        if (!$assertionsDisabled && instanceEnvironment == null) {
            throw new AssertionError();
        }
        String string = instanceEnvironment.getName();
        Long l = (Long)serverXMLtimeStampMap.get(string);
        if (l == null) {
            instanceMap.remove(instanceEnvironment.getName());
            return;
        }
        Long l2 = ContextRootChecker.getFileTimeStamp(instanceEnvironment);
        if (l2 > l) {
            instanceMap.remove(instanceEnvironment.getName());
            serverXMLtimeStampMap.remove(string);
        }
    }

    static synchronized void undeploy(InstanceEnvironment instanceEnvironment, String string) throws IASDeploymentException {
        if (!StringUtils.ok((String)string)) {
            throw new IASDeploymentException(undeployErr);
        }
        Map map = (Map)instanceMap.get(instanceEnvironment.getName());
        if (map == null) {
            return;
        }
        map.remove(string);
        ContextRootChecker.setTimeStamp(instanceEnvironment);
    }

    static synchronized void update(InstanceEnvironment instanceEnvironment, AppsManager appsManager, String string) throws IASDeploymentException {
        if (!$assertionsDisabled && instanceMap == null) {
            throw new AssertionError();
        }
        if (!StringUtils.ok((String)string)) {
            String string2 = localStrings.getString("enterprise.deployment.backend.null_appid_argument");
            throw new IASDeploymentException(string2);
        }
        Map map = (Map)instanceMap.get(instanceEnvironment.getName());
        if (map == null) {
            return;
        }
        try {
            File file = new File(appsManager.getLocation(string));
            AppDD appDD = new AppDD(file);
            String[] stringArray = appDD.getContextRoots();
            AppInfo appInfo = new AppInfo(appDD.getFile(), stringArray);
            map.put(string, appInfo);
        }
        catch (Exception exception) {
            String string3 = localStrings.getString("enterprise.deployment.backend.error_updating_appmap", exception);
            throw new IASDeploymentException(string3, exception);
        }
        ContextRootChecker.setTimeStamp(instanceEnvironment);
    }

    private void preCtor(InstanceEnvironment instanceEnvironment, String[] stringArray) throws IASDeploymentException {
        if (!$assertionsDisabled && instanceMap == null) {
            throw new AssertionError();
        }
        this.iEnv = instanceEnvironment;
        this.contextRoots = stringArray;
        if (instanceEnvironment == null) {
            String string = localStrings.getString("enterprise.deployment.backend.null_instanceenvironment_object");
            throw new IASDeploymentException(string);
        }
        if (stringArray == null) {
            String string = localStrings.getString("enterprise.deployment.backend.null_contextroot");
            throw new IASDeploymentException(string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            String string = localStrings.getString("enterprise.deployment.backend.null_contextroot_number", new Integer(i));
            throw new IASDeploymentException(string);
        }
        this.instanceName = instanceEnvironment.getName();
    }

    private boolean alreadyExists() throws IASDeploymentException {
        if (this.contextRoots.length <= 0) {
            return false;
        }
        if (this.alreadyExistsInWebModule()) {
            return true;
        }
        return this.alreadyExistsInApplication();
    }

    private boolean alreadyExistsInWebModule() throws IASDeploymentException {
        try {
            WebModule[] webModuleArray = this.webMgr.listWebModules();
            if (webModuleArray == null || webModuleArray.length == 0) {
                return false;
            }
            for (int i = 0; i < webModuleArray.length; ++i) {
                WebModule webModule = webModuleArray[i];
                String string = webModule.getContextRoot();
                for (int j = 0; j < this.contextRoots.length; ++j) {
                    if (!string.equals(this.contextRoots[j]) || this.webName != null && this.webName.equals(webModule.getName())) continue;
                    this.matchDescription = "Stand-alone Web Module: " + webModule.getName();
                    return true;
                }
            }
        }
        catch (ConfigException configException) {
            String string = localStrings.getString("enterprise.deployment.backend.config_exception_in_alreadyexistsinwebmodule");
            throw new IASDeploymentException(string, configException);
        }
        return false;
    }

    private void checkAppFileStamps() {
        Map map = (Map)instanceMap.get(this.instanceName);
        if (map == null) {
            return;
        }
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.appName != null && string != null && string.equals(this.appName)) continue;
            AppInfo appInfo = (AppInfo)map.get(string);
            File file = appInfo.appXML;
            long l = appInfo.fileTimeStamp;
            if (file == null || !file.exists()) {
                instanceMap.remove(this.instanceName);
                return;
            }
            long l2 = file.lastModified();
            if (l2 <= l) continue;
            instanceMap.remove(this.instanceName);
            return;
        }
    }

    private boolean alreadyExistsInApplication() throws IASDeploymentException {
        this.checkAppFileStamps();
        Map map = this.getAppMap();
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.appName != null && string.equals(this.appName)) continue;
            AppInfo appInfo = (AppInfo)map.get(string);
            String[] stringArray = appInfo.contextRoots;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                for (int j = 0; j < this.contextRoots.length; ++j) {
                    String string3 = this.contextRoots[j];
                    if (!string2.equals(string3) || this.appName != null && string.equals(this.appName)) continue;
                    this.matchDescription = "Application: " + string;
                    return true;
                }
            }
        }
        return false;
    }

    private synchronized Map getAppMap() {
        HashMap<String, AppInfo> hashMap = (HashMap<String, AppInfo>)instanceMap.get(this.instanceName);
        if (hashMap != null) {
            return hashMap;
        }
        List list = this.appMgr.listIds();
        hashMap = new HashMap<String, AppInfo>();
        instanceMap.put(this.instanceName, hashMap);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!StringUtils.ok((String)string)) continue;
            try {
                if (!this.appMgr.isEnabled(string)) continue;
                File file = new File(this.appMgr.getLocation(string));
                AppDD appDD = new AppDD(file);
                String[] stringArray = appDD.getContextRoots();
                AppInfo appInfo = new AppInfo(appDD.getFile(), stringArray);
                hashMap.put(string, appInfo);
            }
            catch (Exception exception) {
                this.logger.warning("Exception in createAppsList: " + exception);
            }
        }
        ContextRootChecker.setTimeStamp(this.iEnv);
        return hashMap;
    }

    private static Long getFileTimeStamp(InstanceEnvironment instanceEnvironment) {
        long l;
        File file = new File(instanceEnvironment.getBackupConfigFilePath());
        File file2 = new File(instanceEnvironment.getConfigFilePath());
        long l2 = file.lastModified();
        long l3 = l2 > (l = file2.lastModified()) ? l2 : l;
        return new Long(l3);
    }

    private static void setTimeStamp(InstanceEnvironment instanceEnvironment) {
        serverXMLtimeStampMap.put(instanceEnvironment.getName(), new Long(5000L + System.currentTimeMillis()));
    }

    static {
        $assertionsDisabled = !ContextRootChecker.class.desiredAssertionStatus();
        serverXMLtimeStampMap = new HashMap();
        instanceMap = new HashMap();
        localStrings = StringManager.getManager(ContextRootChecker.class);
        undeployErr = localStrings.getString("enterprise.deployment.backend.undeploy_error");
    }

    private static class AppInfo {
        String[] contextRoots;
        long fileTimeStamp;
        File appXML;

        AppInfo(File file, String[] stringArray) {
            this.appXML = file;
            this.contextRoots = stringArray;
            this.fileTimeStamp = this.appXML.lastModified();
        }
    }
}

