/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ConnectorModule;
import com.iplanet.ias.connectors.deployment.IASConnectorDescriptor;
import com.iplanet.ias.deployment.backend.ConnectorModuleInfo;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.backend.ModuleDeployer;
import com.iplanet.ias.deployment.backend.RarExploder;
import com.iplanet.ias.instance.BaseManager;
import com.iplanet.ias.instance.ConnectorModulesManager;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ModuleEnvironment;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFileException;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.ResultsReport;
import com.sun.enterprise.tools.verifier.Verifier;
import java.util.logging.Level;

public class ConnectorModuleDeployer
extends ModuleDeployer {
    private ConnectorModulesManager connModulesMgr = null;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    ConnectorModuleDeployer(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        super(deploymentRequest);
    }

    public void cleanup_internal() {
        try {
            if (this.request.isUnDeploy()) {
                this.liquidate();
            } else if (this.request.isReDeploy() && this.isArchive() && this.oldModuleDir != null) {
                FileUtils.whack(this.oldModuleDir);
            }
        }
        catch (Exception exception) {
            this.logger.warning("Exception caught and ignored in cleanup_internal()");
        }
    }

    protected BaseManager createConfigManager(InstanceEnvironment instanceEnvironment, ModuleEnvironment moduleEnvironment) throws IASDeploymentException, ConfigException {
        this.connModulesMgr = new ConnectorModulesManager(instanceEnvironment);
        return this.connModulesMgr;
    }

    protected void preDeploy() throws IASDeploymentException {
        if (!$assertionsDisabled && this.moduleDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !StringUtils.ok((String)this.moduleName)) {
            throw new AssertionError();
        }
        try {
            if (this.isRegistered()) {
                String string = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
                throw new IASDeploymentException(string);
            }
            this.liquidateModuleDirAndStubsDirIfTheyHappenToExist();
            if (this.request.isDirectory()) {
                this.moduleInfo = new ConnectorModuleInfo(this.moduleDir, this.moduleName);
            } else {
                RarExploder rarExploder = new RarExploder(this.moduleDir, this.request.getFileSource().getFile(), this.moduleName);
                this.moduleInfo = rarExploder.explode();
            }
            this.register();
            this.runVerifier();
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception.toString(), exception);
        }
    }

    protected void rollbackRedeploy() throws IASDeploymentException {
        if (this.isArchive() && FileUtils.safeIsDirectory(this.moduleDir)) {
            FileUtils.whack(this.moduleDir);
        }
        this.rollbackRedeployRegister();
    }

    protected void preRedeploy() throws IASDeploymentException, ConfigException {
        if (!this.isRegistered()) {
            String string = localStrings.getString("enterprise.deployment.backend.redeploy_error_module_not_registered");
            throw new IASDeploymentException(string);
        }
        this.setOldDirs();
        if (this.request.isDirectory()) {
            this.moduleInfo = new ConnectorModuleInfo(this.moduleDir, this.moduleName);
        } else {
            try {
                RarExploder rarExploder = new RarExploder(this.moduleDir, this.request.getFileSource().getFile(), this.moduleName);
                this.moduleInfo = rarExploder.explode();
            }
            catch (ZipFileException zipFileException) {
                throw new IASDeploymentException(zipFileException.toString(), zipFileException);
            }
        }
        this.redeployRegister();
        this.runVerifier();
    }

    protected void postRedeploy() throws IASDeploymentException, ConfigException {
        this.backupFiles();
        this.saveHotConfigRedeploy();
    }

    protected void deploy() throws IASDeploymentException, ConfigException {
        try {
            IASConnectorDescriptor iASConnectorDescriptor = new IASConnectorDescriptor(this.moduleDir.getPath(), this.moduleName);
            iASConnectorDescriptor.verify();
            String string = iASConnectorDescriptor.getJndiName();
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            this.checkJNDINameDoesNotExist(string);
        }
        catch (com.iplanet.ias.connectors.deployment.IASDeploymentException iASDeploymentException) {
            throw new IASDeploymentException(iASDeploymentException.getMessage());
        }
    }

    protected final String whatTypeAmI() {
        return "Connector Module";
    }

    private void runVerifier() throws IASDeploymentException {
        if (this.request.isVerifying()) {
            try {
                String string = this.moduleDir.getCanonicalPath();
                ConnectorDescriptor connectorDescriptor = ConnectorModulesManager.getDescriptor(this.moduleName, string, true, true);
                Verifier verifier = new Verifier();
                ResultsReport resultsReport = verifier.verifyStdAloneRar(connectorDescriptor);
                int n = resultsReport.getFailedCount();
                int n2 = resultsReport.getWarningCount();
                int n3 = resultsReport.getErrorCount();
                this.logger.log(Level.INFO, "enterprise.deployment_verifier_result", new Object[]{String.valueOf(n), String.valueOf(n2), String.valueOf(n3)});
                if (n > 0) {
                    String string2 = localStrings.getString("enterprise.deployment.backend.verifier_error", String.valueOf(n));
                    throw new IASDeploymentException(string2);
                }
            }
            catch (IASDeploymentException iASDeploymentException) {
                throw iASDeploymentException;
            }
            catch (Exception exception) {
                throw new IASDeploymentException(exception);
            }
        }
    }

    private void checkJNDINameDoesNotExist(String string) throws IASDeploymentException {
        String string2 = null;
        String string3 = null;
        try {
            InstanceEnvironment instanceEnvironment = this.getInstanceEnv();
            ConnectorModulesManager connectorModulesManager = new ConnectorModulesManager(instanceEnvironment);
            ConnectorModule[] connectorModuleArray = connectorModulesManager.listConnectorModules();
            if (connectorModuleArray != null) {
                for (int i = 0; i < connectorModuleArray.length; ++i) {
                    IASConnectorDescriptor iASConnectorDescriptor;
                    String string4;
                    ConnectorModule connectorModule = connectorModuleArray[i];
                    if (!connectorModule.isEnabled()) continue;
                    string2 = connectorModule.getLocation();
                    string3 = connectorModule.getName();
                    if (string3.equals(this.moduleName) || !string.equals(string4 = (iASConnectorDescriptor = new IASConnectorDescriptor(string2, string3)).getJndiName())) continue;
                    String string5 = iASConnectorDescriptor.getIASRaName();
                    String string6 = localStrings.getString("enterprise.deployment.backend.deploy_error_jndi_exists", string, string5);
                    throw new IASDeploymentException(string6);
                }
            }
        }
        catch (ConfigException configException) {
            this.logger.fine("Failed to read connector modules from server.xml file " + configException.getMessage());
            String string7 = localStrings.getString("enterprise.deployment.backend.listconnectormodules") + configException.getMessage();
            throw new IASDeploymentException(string7);
        }
        catch (com.iplanet.ias.connectors.deployment.IASDeploymentException iASDeploymentException) {
            this.logger.fine("Failed to create IASConnectorDescriptor " + string2 + " " + string3 + iASDeploymentException.getMessage());
            String string8 = localStrings.getString("enterprise.deployment.backend.cannot_create_connector_descriptor", string2, string3);
            throw new IASDeploymentException(string8);
        }
    }

    static {
        $assertionsDisabled = !ConnectorModuleDeployer.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(ConnectorModuleDeployer.class);
    }
}

