/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.AppDD;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.deployment.backend.EjbFullJarMaker;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.backend.MetaJarMaker;
import com.iplanet.ias.util.diagnostics.SystemProps;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFileException;
import com.iplanet.ias.util.zip.ZipItem;
import com.iplanet.ias.util.zip.ZipWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

class ClientJarMaker {
    private File clientJar;
    private File tempClientJar = null;
    private File rootDir;
    private File[] ejbMetaJars;
    private File[] ejbModuleDirs;
    private File[] ejbClassFiles;
    private String[] ejbMetaJarEntryNames;
    private File[] appClientMetaJars;
    private File[] appClientModuleDirs;
    private File[] appClientClassFiles;
    private String[] appClientMetaJarEntryNames;
    private File[] appMetaFiles;
    private ZipItem[] allFiles;
    private AppDD appDD = null;
    private static boolean useHomemadeParser;
    private final Logger logger = DeploymentLogger.get();
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClientJarMaker(File file, File file2) throws IASDeploymentException {
        try {
            this.clientJar = file2;
            this.rootDir = file;
            if (!FileUtils.safeIsDirectory(file)) {
                String string = localStrings.getString("enterprise.deployment.backend.bad_app_directory", file.getPath());
                throw new IASDeploymentException(string);
            }
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            throw new IASDeploymentException("" + exception, exception);
        }
    }

    void createAppClient(ZipItem[] zipItemArray) throws IASDeploymentException, ZipFileException {
        try {
            this.createAppDD();
            this.createEjbMetaJars();
            this.createAppClientMetaJars();
            this.createAppMetaFileList();
            this.createEjbClassFileList();
            this.createAppClientClassFileList();
            this.createAllFilesList(zipItemArray);
            this.createClientJar();
            this.cleanup();
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            throw new IASDeploymentException("" + exception, exception);
        }
    }

    void createAppDD() throws IASDeploymentException {
        try {
            this.appDD = new AppDD(this.rootDir, useHomemadeParser);
        }
        catch (Exception exception) {
            String string = localStrings.getString("enterprise.deployment.backend.error_creating_appdd", exception);
            throw new IASDeploymentException(string, exception);
        }
    }

    void createModuleClient(ZipItem[] zipItemArray) throws IASDeploymentException {
        try {
            new EjbFullJarMaker(this.clientJar, this.rootDir, zipItemArray);
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            throw new IASDeploymentException("" + exception, exception);
        }
    }

    private void createEjbMetaJars() throws IASDeploymentException {
        if (!$assertionsDisabled && this.ejbMetaJars != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.appDD == null) {
            throw new AssertionError();
        }
        String[] stringArray = this.appDD.getEjbModules();
        this.ejbModuleDirs = new File[stringArray.length];
        this.ejbMetaJars = new File[stringArray.length];
        this.ejbMetaJarEntryNames = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.ejbMetaJars[i] = this.createTempFile(string, this.rootDir);
            this.ejbModuleDirs[i] = new File(this.rootDir, FileUtils.makeFriendlyFilename(string));
            this.ejbMetaJarEntryNames[i] = string;
            this.createEjbMetaJar(this.ejbMetaJars[i], this.ejbModuleDirs[i]);
        }
    }

    private void createAppClientMetaJars() throws IASDeploymentException {
        if (!$assertionsDisabled && this.appClientMetaJars != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.appDD == null) {
            throw new AssertionError();
        }
        String[] stringArray = this.appDD.getClientModules();
        int n = stringArray.length;
        this.appClientModuleDirs = new File[n];
        this.appClientMetaJars = new File[n];
        this.appClientMetaJarEntryNames = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            this.appClientMetaJars[i] = this.createTempFile(string, this.rootDir);
            this.appClientModuleDirs[i] = new File(this.rootDir, FileUtils.makeFriendlyFilename(string));
            this.appClientMetaJarEntryNames[i] = string;
            this.createAppClientMetaJar(this.appClientMetaJars[i], this.appClientModuleDirs[i]);
        }
    }

    private void createEjbMetaJar(File file, File file2) throws IASDeploymentException {
        if (!FileUtils.safeIsDirectory(file2)) {
            String string = localStrings.getString("enterprise.deployment.backend.ejb_subdirectory_does_not_exist", this.getClass().getName(), file2.getPath());
            throw new IASDeploymentException(string);
        }
        new MetaJarMaker(file, file2);
    }

    private void createAppClientMetaJar(File file, File file2) throws IASDeploymentException {
        if (!FileUtils.safeIsDirectory(file2)) {
            String string = localStrings.getString("enterprise.deployment.backend.appclient_subdirectory_does_not_exist", this.getClass().getName(), file2.getPath());
            throw new IASDeploymentException(string);
        }
        new MetaJarMaker(file, file2);
    }

    private void createAppMetaFileList() {
        this.appMetaFiles = new File(this.rootDir, "META-INF").listFiles();
    }

    private void createEjbClassFileList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.ejbModuleDirs.length; ++i) {
            List list = FileUtils.searchDir(this.ejbModuleDirs[i], ".class");
            if (list == null) continue;
            arrayList.addAll(list);
        }
        this.ejbClassFiles = new File[arrayList.size()];
        this.ejbClassFiles = arrayList.toArray(this.ejbClassFiles);
    }

    private void createAppClientClassFileList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.appClientModuleDirs.length; ++i) {
            List list = FileUtils.searchDir(this.appClientModuleDirs[i], ".class");
            if (list == null) continue;
            arrayList.addAll(list);
        }
        this.appClientClassFiles = new File[arrayList.size()];
        this.appClientClassFiles = arrayList.toArray(this.appClientClassFiles);
    }

    private void createAllFilesList(ZipItem[] zipItemArray) throws IASDeploymentException, ZipFileException {
        int n;
        String string;
        int n2;
        int n3 = this.ejbMetaJars.length + this.appMetaFiles.length + this.ejbClassFiles.length;
        int n4 = this.rootDir.getPath().length() + 1;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<ZipItem> arrayList = new ArrayList<ZipItem>();
        if (zipItemArray != null) {
            for (n2 = 0; n2 < zipItemArray.length; ++n2) {
                string = zipItemArray[n2].getName();
                if (!hashSet.add(string)) {
                    this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string + ", Filename: " + zipItemArray[n2].getFile());
                    continue;
                }
                arrayList.add(zipItemArray[n2]);
            }
        }
        File[] fileArray = this.ejbMetaJars;
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            string = this.ejbMetaJarEntryNames[n2];
            if (!hashSet.add(string)) {
                this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string + ", Filename: " + fileArray[n2]);
                continue;
            }
            arrayList.add(new ZipItem(fileArray[n2], string));
        }
        fileArray = this.appClientMetaJars;
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            string = this.appClientMetaJarEntryNames[n2];
            if (!hashSet.add(string)) {
                this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string + ", Filename: " + fileArray[n2]);
                continue;
            }
            arrayList.add(new ZipItem(fileArray[n2], string));
        }
        fileArray = this.appMetaFiles;
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            string = fileArray[n2].getPath().substring(n4).replace('\\', '/');
            if (!hashSet.add(string)) {
                this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string + ", Filename: " + fileArray[n2]);
                continue;
            }
            arrayList.add(new ZipItem(fileArray[n2], string));
        }
        fileArray = this.ejbClassFiles;
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            string = fileArray[n2].getPath().substring(n4);
            n = string.indexOf(File.separatorChar);
            if (n < 0) {
                throw new IASDeploymentException("Internal Error - didn't find a '" + File.separatorChar + "' in the filename: " + string);
            }
            if (!hashSet.add(string = string.substring(n + 1).replace('\\', '/'))) {
                this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string + ", Filename: " + fileArray[n2]);
                continue;
            }
            arrayList.add(new ZipItem(fileArray[n2], string));
        }
        fileArray = this.appClientClassFiles;
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            string = fileArray[n2].getPath().substring(n4);
            n = string.indexOf(File.separatorChar);
            if (n < 0) {
                String string2 = localStrings.getString("enterprise.deployment.backend.did_not_find_separator", File.separator, string);
                throw new IASDeploymentException(string2);
            }
            if (!hashSet.add(string = string.substring(n + 1).replace('\\', '/'))) {
                this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string + ", Filename: " + fileArray[n2]);
                continue;
            }
            arrayList.add(new ZipItem(fileArray[n2], string));
        }
        this.logger.info("" + n3 + " total files, " + arrayList.size() + " files added to jar file");
        this.allFiles = new ZipItem[arrayList.size()];
        this.allFiles = arrayList.toArray(this.allFiles);
    }

    private void createClientJar() throws ZipFileException {
        ZipWriter zipWriter = new ZipWriter(this.clientJar.getPath(), this.rootDir.getPath(), this.allFiles);
        zipWriter.safeWrite();
    }

    private void cleanup() {
        int n;
        if (!$assertionsDisabled && this.ejbMetaJars == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.appClientMetaJars == null) {
            throw new AssertionError();
        }
        for (n = 0; n < this.ejbMetaJars.length; ++n) {
            if (this.ejbMetaJars[n].delete()) continue;
            this.ejbMetaJars[n].deleteOnExit();
        }
        for (n = 0; n < this.appClientMetaJars.length; ++n) {
            if (this.appClientMetaJars[n].delete()) continue;
            this.appClientMetaJars[n].deleteOnExit();
        }
        if (this.tempClientJar != null && this.tempClientJar.exists() && !this.tempClientJar.delete()) {
            this.tempClientJar.deleteOnExit();
        }
    }

    private File createTempFile(String string, File file) {
        if (string == null || string.length() < 3) {
            string = "tmp";
        }
        try {
            return File.createTempFile(string, ".jar", file);
        }
        catch (Exception exception) {
            return new File(file, string + ".tmp");
        }
    }

    public static void main(String[] stringArray) {
        useHomemadeParser = true;
        if (stringArray == null || stringArray.length != 2) {
            if (System.getProperty("user.name").equals("bnevins")) {
                stringArray = new String[]{"C:/temp/ConverterUser", "C:/temp/ConverterUser/TestClient.jar"};
            } else {
                System.out.println(SystemProps.toStringStatic());
                System.out.println("Usage:  ClientJarMaker app-dir client-jar-name");
                System.exit(1);
            }
        }
        try {
            ClientJarMaker clientJarMaker = new ClientJarMaker(new File(stringArray[0]), new File(stringArray[1]));
            clientJarMaker.createAppClient(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    static {
        $assertionsDisabled = !ClientJarMaker.class.desiredAssertionStatus();
        useHomemadeParser = false;
        localStrings = StringManager.getManager(ClientJarMaker.class);
    }
}

