/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.backend.AppDeployerBase;
import com.iplanet.ias.deployment.backend.AppInfo;
import com.iplanet.ias.deployment.backend.ContextRootChecker;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;
import java.util.logging.Level;

public class AppUnDeployer
extends AppDeployerBase {
    private String failureMessage = "Undeployment Failed -- rolled back undeployment";
    private String successMessage = "Undeployment Successful for ";
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    AppUnDeployer(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        super(deploymentRequest);
    }

    public void doRequest() throws IASDeploymentException {
        try {
            this.begin();
            this.undeploy();
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            String string = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
            this.logger.log(Level.WARNING, string, exception);
            throw new IASDeploymentException(string, exception);
        }
        finally {
            this.finish();
        }
    }

    public void cleanup_internal() {
        try {
            this.liquidate();
        }
        catch (Exception exception) {
            this.rollback();
            this.logger.warning("Caught an Exception in liquidate: " + exception);
        }
    }

    protected AppInfo createAppInfo() throws IASDeploymentException {
        if (!$assertionsDisabled && this.getAppDir() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getAppName() == null) {
            throw new AssertionError();
        }
        return new AppInfo(this.getAppDir(), this.getAppName());
    }

    protected final File setAppDir() throws IASDeploymentException {
        try {
            return new File(this.getAppMgr().getLocation(this.getAppName()));
        }
        catch (ConfigException configException) {
            String string = localStrings.getString("enterprise.deployment.backend.error_getting_app_directory", configException);
            throw new IASDeploymentException(string, configException);
        }
    }

    private void undeploy() throws IASDeploymentException {
        try {
            this.getAppMgr().remove(this.getAppName());
            this.saveHotConfig();
            ContextRootChecker.undeploy(this.getInstanceEnv(), this.getAppName());
            this.addToSummary(this.successMessage + this.getAppName());
        }
        catch (Exception exception) {
            this.rollback();
            if (exception instanceof IASDeploymentException) {
                throw (IASDeploymentException)exception;
            }
            throw new IASDeploymentException(exception);
        }
    }

    private void rollback() {
        try {
            if (this.getAppMgr().isEnabled(this.getAppName())) {
                this.logger.info("App to be undeployed is enabled. Disabling it first.");
                this.getAppMgr().setEnable(this.getAppName(), false);
                this.saveHotConfig();
            }
        }
        catch (Throwable throwable) {
            this.logger.log(Level.WARNING, "enterprise.deployment_rollback_error", throwable);
        }
    }

    private void liquidate() throws IASDeploymentException, ConfigException {
        Object object;
        try {
            object = new File(this.getAppEnv().getAppBackupPath());
            if (FileUtils.safeIsDirectory((File)object)) {
                this.logger.fine("Deleting BackupDir: " + FileUtils.safeGetCanonicalPath((File)object) + ", isDir: " + FileUtils.safeIsDirectory((File)object));
                FileUtils.whack((File)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.getInstanceEnv();
        File file = this.getAppDir();
        File file2 = this.getStubsDir();
        File file3 = this.getJSPDir();
        if (!($assertionsDisabled || object != null && file != null && file2 != null && file3 != null)) {
            throw new AssertionError();
        }
        if (((InstanceEnvironment)object).isIASOwned(file)) {
            if (FileUtils.safeIsDirectory(file)) {
                FileUtils.whack(file);
                this.logger.fine("Deleted Application Directory: " + file.getPath());
            } else {
                this.logger.warning("Can't delete Application Directory -- it isn't a directory: " + file.getPath());
            }
        } else {
            this.logger.fine("Did NOT delete Application Directory (Directory-Deployment): " + file.getPath());
        }
        if (FileUtils.safeIsDirectory(file2)) {
            FileUtils.whack(file2);
        } else {
            this.logger.finest("Can't delete Stubs Directory -- it isn't a directory: " + FileUtils.safeGetCanonicalPath(file2));
        }
        if (FileUtils.safeIsDirectory(file3)) {
            FileUtils.whack(file3);
        } else {
            this.logger.finest("Can't delete JSP Directory -- it isn't a directory: " + FileUtils.safeGetCanonicalPath(file3));
        }
    }

    static {
        $assertionsDisabled = !AppUnDeployer.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(AppUnDeployer.class);
    }
}

