/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.backend.AppDD;
import com.iplanet.ias.deployment.backend.AppDeployerBase;
import com.iplanet.ias.deployment.backend.ContextRootChecker;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.DeploymentUtils;
import com.iplanet.ias.deployment.backend.DirNameManager;
import com.iplanet.ias.deployment.backend.EJBCompiler;
import com.iplanet.ias.deployment.backend.EarExploder;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.backend.JSPCompiler;
import com.iplanet.ias.ejb.codegen.IASEJBCTimes;
import com.iplanet.ias.instance.ApplicationEnvironment;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileSource;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFileException;
import com.iplanet.ias.util.zip.ZipItem;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class AppDeployer
extends AppDeployerBase {
    private static final String stars = "\n*********************\n";
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    AppDeployer(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        super(deploymentRequest);
    }

    public void doRequest() throws IASDeploymentException {
        try {
            this.begin();
            this.predeploy();
            this.deploy();
        }
        catch (Exception exception) {
            this.rollback();
            String string = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
            this.logger.log(Level.WARNING, string, exception);
            throw new IASDeploymentException(string, exception);
        }
        finally {
            this.finish();
        }
    }

    public void cleanup_internal() {
    }

    protected void predeploy() throws IASDeploymentException {
        this.liquidateAppDirAndStubsDirIfTheyHappenToExist();
    }

    protected void deploy() throws IASDeploymentException {
        try {
            if (this.isArchive()) {
                this.explodeArchive();
            }
            this.checkContextRoot();
            this.prePopulateConfig();
            ZipItem[] zipItemArray = this.runEJBC();
            this.runJSPC();
            this.createClientJar(zipItemArray);
            this.postDeploy();
            this.addToSummary(this.getSuccessMessage() + this.getAppName() + stars);
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    protected void rollback() {
        try {
            try {
                if (this.getAppInfo() != null && this.getAppMgr().isRegistered(this.getAppName())) {
                    this.getAppMgr().remove(this.getAppInfo().getName());
                    this.saveColdConfig();
                }
            }
            catch (Throwable throwable) {
                this.logger.warning("Got a Throwable trying to call getAppMgr().removeApp(): " + throwable);
            }
            this.DeleteOrKeepFailedStubs(this.getStubsDir());
            if (FileUtils.safeIsDirectory(this.getJSPDir())) {
                FileUtils.whack(this.getJSPDir());
            }
            if (this.isArchive() && FileUtils.safeIsDirectory(this.getAppDir())) {
                FileUtils.whack(this.getAppDir());
            }
        }
        catch (Throwable throwable) {
            this.logger.log(Level.WARNING, "enterprise.deployment_rollback_error", throwable);
        }
    }

    private void liquidateAppDirAndStubsDirIfTheyHappenToExist() throws IASDeploymentException {
        if (FileUtils.safeIsDirectory(this.getAppDir()) && this.isArchive()) {
            FileUtils.whack(this.getAppDir());
        }
        if (FileUtils.safeIsDirectory(this.getStubsDir())) {
            FileUtils.whack(this.getStubsDir());
        }
        if (FileUtils.safeIsDirectory(this.getJSPDir())) {
            FileUtils.whack(this.getJSPDir());
        }
    }

    private void explodeArchive() throws ZipFileException, IASDeploymentException {
        EarExploder earExploder = new EarExploder(this.getAppInfo());
        earExploder.explode();
    }

    private ZipItem[] runEJBC() throws IASDeploymentException {
        ZipItem[] zipItemArray = null;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            DeploymentUtils.setParentClassLoader(classLoader, this.getAppMgr(), this.request);
            IASEJBCTimes iASEJBCTimes = new IASEJBCTimes();
            EJBCompiler eJBCompiler = new EJBCompiler(this.getAppName(), this.getAppDir(), this.getOldAppDir(), this.getClientJar(), this.getStubsDir(), this.getOldStubsDir(), this.getAppMgr(), this.request, iASEJBCTimes);
            zipItemArray = eJBCompiler.compile();
            this.addEJBCTime(iASEJBCTimes);
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "enterprise.deployment_ejbc_error", exception);
            String string = localStrings.getString("enterprise.deployment.backend.ejbc_error");
            throw new IASDeploymentException(string, exception);
        }
        return zipItemArray;
    }

    private void runJSPC() throws IASDeploymentException {
        if (!this.request.getPrecompileJSP()) {
            return;
        }
        AppDD appDD = this.getAppDD();
        String[] stringArray = appDD.getWarModules();
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = FileUtils.makeFriendlyFilename(stringArray[i]);
            File file = new File(this.getJSPDir(), string);
            File file2 = new File(this.getAppDir(), string);
            long l = System.currentTimeMillis();
            JSPCompiler jSPCompiler = new JSPCompiler(file2, file, this.request.getEjbClasspath());
            jSPCompiler.compile();
            this.addJSPCTime(System.currentTimeMillis() - l);
        }
    }

    protected void postDeploy() throws ConfigException, IASDeploymentException {
        if (this.isDirectory()) {
            this.postDeployDirectory();
        } else {
            this.postDeployArchive();
        }
        this.postPopulateConfig();
        ContextRootChecker.update(this.getInstanceEnv(), this.getAppMgr(), this.getAppName());
    }

    private void postDeployArchive() throws ConfigException, IASDeploymentException {
    }

    private void postDeployDirectory() throws IASDeploymentException {
        File file = new File(this.getAppEnv().getAppBackupPath());
        try {
            FileUtils.whack(file);
            FileUtils.copyTree(this.getAppDir(), file);
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.backend.error_making_backup", file.getPath());
            throw new IASDeploymentException(string);
        }
    }

    protected File setAppDir() throws IASDeploymentException {
        File file;
        ApplicationEnvironment applicationEnvironment = this.getAppEnv();
        if (this.isArchive()) {
            File file2 = new File(this.getInstanceEnv().getApplicationRepositoryPath());
            DirNameManager dirNameManager = new DirNameManager(file2, null, this.getAppName());
            file = dirNameManager.getNewDir();
        } else if (this.isDirectory()) {
            FileSource fileSource = this.request.getFileSource();
            if (!fileSource.exists()) {
                String string = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", fileSource.toString());
                throw new IASDeploymentException(string);
            }
            if (!$assertionsDisabled && !fileSource.isDirectory()) {
                throw new AssertionError();
            }
            file = fileSource.getFile();
        } else {
            String string = localStrings.getString("enterprise.deployment.backend.deployment_not_dir_or_archive");
            throw new IASDeploymentException(string);
        }
        file.mkdirs();
        return file;
    }

    protected File getOldStubsDir() {
        return null;
    }

    protected File getOldAppDir() {
        return null;
    }

    protected String whatAreYou() {
        return "Deployment";
    }

    protected final String getSuccessMessage() {
        return "\n*********************\n**** " + this.whatAreYou() + " successful for " + this.getAppName() + " ****" + stars;
    }

    protected final String getFailureMessage() {
        return "\n*********************\n**** " + this.whatAreYou() + " failed for " + this.getAppName() + " ****" + stars;
    }

    static {
        $assertionsDisabled = !AppDeployer.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(AppDeployer.class);
    }
}

