/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.deployment.DescriptorConstants;
import com.iplanet.ias.deployment.ModuleConfigEnv;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ModuleConfigEnvImpl
implements ModuleConfigEnv,
DescriptorConstants {
    private File _moduleDir = null;
    private String _moduleId = null;
    private String _xmlFilename = null;
    private String _iasxmlFilename = null;
    private boolean _iasxmlRequired = false;
    private boolean _validateXml = false;
    private static StringManager localStrings = StringManager.getManager(ModuleConfigEnvImpl.class);
    private boolean verify = false;

    public ModuleConfigEnvImpl(String string, String string2, boolean bl) {
        this(new File(string), string2, bl);
    }

    public ModuleConfigEnvImpl(File file, String string, boolean bl) {
        this._moduleDir = file;
        this._moduleId = string;
        this._validateXml = bl;
    }

    public String getId() {
        return this._moduleId;
    }

    public boolean isValidating() {
        return this._validateXml;
    }

    public InputStream getXmlFile() throws AppConfigException {
        try {
            return this.getInputStream(this._xmlFilename);
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
    }

    public OutputStream getXmlOutFile() throws AppConfigException {
        try {
            return this.getOutputStream(this._xmlFilename);
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
    }

    public InputStream getIASXmlFile() throws AppConfigException {
        try {
            return this.getInputStream(this._iasxmlFilename, this._iasxmlRequired);
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
    }

    public OutputStream getIASXmlOutFile() throws AppConfigException {
        try {
            return this.getOutputStream(this._iasxmlFilename);
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
    }

    public InputStream getManifestFile() {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(MANIFEST_ENTRY, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inputStream;
    }

    public String getMainClassName() throws AppConfigException {
        String string = null;
        try {
            InputStream inputStream = this.getManifestFile();
            if (inputStream != null) {
                string = ModuleConfigEnvImpl.getMainClassNameFrom(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
        return string;
    }

    public String getXmlFilename() {
        return this._xmlFilename;
    }

    public String getIASXmlFilename() {
        return this._iasxmlFilename;
    }

    public InputStream getFile(String string, boolean bl) throws AppConfigException {
        try {
            return this.getInputStream(string, bl);
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
    }

    protected void setXmlFilename(String string) {
        this._xmlFilename = string;
    }

    protected void setIASXmlFilename(String string, boolean bl) {
        this._iasxmlFilename = string;
        this._iasxmlRequired = bl;
    }

    protected String getDir() {
        String string = null;
        try {
            string = this._moduleDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, true);
    }

    private InputStream getInputStream(String string, boolean bl) throws IOException {
        File file = new File(this._moduleDir, string);
        BufferedInputStream bufferedInputStream = null;
        if (bl || file.isFile()) {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        return bufferedInputStream;
    }

    private OutputStream getOutputStream(String string) throws IOException {
        File file = new File(this._moduleDir, string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        return bufferedOutputStream;
    }

    private static String getMainClassNameFrom(InputStream inputStream) throws IOException {
        Manifest manifest = new Manifest(inputStream);
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null && attributes.get(Attributes.Name.MAIN_CLASS) != null) {
            return (String)attributes.get(Attributes.Name.MAIN_CLASS);
        }
        String string = localStrings.getString("enterprise.deployment.incorrect_manifest_format");
        throw new IOException(string);
    }

    public boolean isVerifying() {
        return this.verify;
    }

    public void setVerifying(boolean bl) {
        this.verify = bl;
    }
}

