/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.JarInfo;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.io.Repository;
import com.iplanet.ias.util.zip.ZipFile;
import com.iplanet.ias.util.zip.ZipFileException;
import java.io.File;

public class JarExploder {
    Repository rep;
    File jar;
    File dir;
    JarInfo info;
    private static StringManager localStrings = StringManager.getManager(JarExploder.class);

    public JarExploder(Repository repository, File file) {
        this.rep = repository;
        this.jar = file;
        String string = this.jar.getName();
        if (!FileUtils.isJar(string)) {
            String string2 = localStrings.getString("enterprise.deployment.filename_not_jar", string);
            throw new IllegalArgumentException(string2);
        }
        String string3 = FileUtils.makeFriendlyFilename(string);
        this.dir = new File(this.rep.getAppDir(), string3);
        this.dir.mkdir();
        this.info = new JarInfo(this.jar, this.dir);
    }

    public JarInfo explode() throws ZipFileException {
        ZipFile zipFile = new ZipFile(this.jar, this.dir);
        this.info.setFiles(zipFile.explode());
        return this.info;
    }
}

