/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.IASEjbBundleDescriptor;
import com.iplanet.ias.deployment.IASEjbCMPFinder;
import com.iplanet.ias.deployment.QueryParser;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.xml.ParseException;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IASEjbCMPEntityDescriptor
extends EjbCMPEntityDescriptor {
    private Class ejbClass = null;
    private String pcImplClassName;
    private String concreteImplClassName;
    private String mappingProperties;
    private ClassLoader jcl = null;
    private boolean one_one_cmp = false;
    private static final boolean debug = true;
    private String actualEjbClassName = null;
    private static StringManager localStrings = StringManager.getManager(IASEjbCMPEntityDescriptor.class);
    private static final Logger _logger = DeploymentLogger.get();
    private static final String JDOSTATE = "_JDOState";
    private static final char DOT = '.';
    private static final String MAPPINGEXT = ".mapping";
    private Collection finders = null;
    private Collection selectors = null;
    private QueryParser queryParser = null;
    private static final Map conversionTable = IASEjbCMPEntityDescriptor.createConversionTable();
    private Map oneOneFinders = new HashMap();
    private List arrOneOneFinders = new ArrayList();
    String moduleDir = null;

    private void addAllInterfaceMethodsIn(Collection collection, Class clazz) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            collection.add(methodArray[i]);
        }
    }

    private void addAllUniqueInterfaceMethodsIn(Collection collection, Class clazz) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (this.findEquivalentMethod(collection, methodArray[i]) != null) continue;
            collection.add(methodArray[i]);
        }
    }

    public Collection getAllUniqueMethods() {
        HashSet hashSet = new HashSet();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllUniqueInterfaceMethodsIn(hashSet, this.jcl.loadClass(this.getHomeClassName()));
                this.addAllUniqueInterfaceMethodsIn(hashSet, this.jcl.loadClass(this.getRemoteClassName()));
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllUniqueInterfaceMethodsIn(hashSet, this.jcl.loadClass(this.getLocalHomeClassName()));
                this.addAllUniqueInterfaceMethodsIn(hashSet, this.jcl.loadClass(this.getLocalClassName()));
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "enterprise.deployment_error_loading_class_excp", throwable);
            throw new RuntimeException(throwable.getMessage());
        }
        return hashSet;
    }

    public Collection getAllMethods() {
        HashSet hashSet = new HashSet();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(hashSet, this.jcl.loadClass(this.getHomeClassName()));
                this.addAllInterfaceMethodsIn(hashSet, this.jcl.loadClass(this.getRemoteClassName()));
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(hashSet, this.jcl.loadClass(this.getLocalHomeClassName()));
                this.addAllInterfaceMethodsIn(hashSet, this.jcl.loadClass(this.getLocalClassName()));
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "enterprise.deployment_error_loading_class_excp", throwable);
            throw new RuntimeException(throwable.getMessage());
        }
        return hashSet;
    }

    private Method findEquivalentMethod(Collection collection, Method method) {
        Method method2 = null;
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Method method3 = (Method)iterator.next();
            if (!this.methodsEqual(method3, method, false)) continue;
            method2 = method3;
            break;
        }
        return method2;
    }

    private boolean methodsEqual(Method method, Method method2, boolean bl) {
        String string;
        boolean bl2 = false;
        String string2 = method.getName();
        if (string2.equals(string = method2.getName())) {
            Class<?>[] classArray;
            Class<?>[] classArray2;
            String string3 = method.getDeclaringClass().getName();
            String string4 = method2.getDeclaringClass().getName();
            if ((!bl || string3.equals(string4)) && (classArray2 = method.getParameterTypes()).length == (classArray = method2.getParameterTypes()).length) {
                bl2 = true;
                for (int i = 0; i < classArray2.length; ++i) {
                    String string5;
                    String string6 = classArray2[i].getName();
                    if (string6.equals(string5 = classArray[i].getName())) continue;
                    bl2 = false;
                    break;
                }
            }
        }
        return bl2;
    }

    private Class getEjbClass() {
        if (this.ejbClass == null) {
            String string = super.getEjbClassName();
            _logger.fine("@@@@@@ Ejb name is  " + string);
            if (this.jcl == null) {
                String string2 = localStrings.getString("enterprise.deployment.error_missing_classloader", "IASEjbCMPEntityDescriptor.getEjbClass");
                _logger.log(Level.WARNING, string2);
                throw new RuntimeException(string2);
            }
            try {
                this.ejbClass = Class.forName(string, true, this.jcl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string3 = localStrings.getString("enterprise.deployment.error_cannot_find_ejbclass", string, "IASEjbCMPEntityDescriptor.getEjbClass");
                _logger.log(Level.WARNING, string3);
                throw new RuntimeException(string3);
            }
        }
        return this.ejbClass;
    }

    public Collection getFinders() {
        if (this.finders == null) {
            Object object;
            Object object2;
            Class<?> clazz;
            String string = super.getEjbClassName();
            Class clazz2 = this.getEjbClass();
            if (super.isRemoteInterfacesSupported()) {
                clazz = null;
                _logger.fine("@@@@@@ " + string + " : Remote Interface is supported ");
                try {
                    clazz = clazz2.getClassLoader().loadClass(super.getHomeClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    _logger.log(Level.WARNING, "enterprise.deployment_class_not_found", classNotFoundException);
                    return null;
                }
                this.finders = this.getFinders(clazz);
                object2 = this.finders.iterator();
                while (object2.hasNext()) {
                    object = (Method)object2.next();
                    _logger.fine("@@@@ adding Remote interface method " + ((Method)object).getName());
                }
            }
            if (super.isLocalInterfacesSupported()) {
                clazz = null;
                _logger.fine("@@@@@@ " + string + ":  Local Interface is supported ");
                try {
                    clazz = clazz2.getClassLoader().loadClass(super.getLocalHomeClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    _logger.log(Level.WARNING, "enterprise.deployment_class_not_found", classNotFoundException);
                    return null;
                }
                object2 = this.getFinders(clazz);
                if (this.finders == null) {
                    this.finders = object2;
                } else if (object2 != null) {
                    _logger.fine("@@@@@@ Trying to remove the Common Elements from HashSet....... ");
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Method method = (Method)object.next();
                        if (this.findEquivalentMethod(this.finders, method) != null) continue;
                        _logger.fine("@@@@ adding local interface method " + method.getName());
                        this.finders.add(method);
                    }
                }
            }
            if (this.finders == null) {
                this.finders = new HashSet();
            }
        }
        return this.finders;
    }

    public Collection getFinders(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        HashSet<Method> hashSet = new HashSet<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("find")) continue;
            hashSet.add(methodArray[i]);
        }
        return hashSet;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.jcl = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.jcl;
    }

    public Collection getAllPersistentFields() {
        int n;
        PersistenceDescriptor persistenceDescriptor = this.getPersistenceDescriptor();
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPersistentFieldInfo();
        PersistentFieldInfo[] persistentFieldInfoArray2 = persistenceDescriptor.getPkeyFieldInfo();
        HashMap<String, PersistentFieldInfo> hashMap = new HashMap<String, PersistentFieldInfo>();
        for (n = 0; n < persistentFieldInfoArray.length; ++n) {
            hashMap.put(persistentFieldInfoArray[n].name, persistentFieldInfoArray[n]);
        }
        for (n = 0; n < persistentFieldInfoArray2.length; ++n) {
            hashMap.put(persistentFieldInfoArray2[n].name, persistentFieldInfoArray2[n]);
        }
        return hashMap.values();
    }

    public Collection getPersistentFields() {
        PersistenceDescriptor persistenceDescriptor = this.getPersistenceDescriptor();
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPersistentFieldInfo();
        HashMap<String, PersistentFieldInfo> hashMap = new HashMap<String, PersistentFieldInfo>();
        for (int i = 0; i < persistentFieldInfoArray.length; ++i) {
            hashMap.put(persistentFieldInfoArray[i].name, persistentFieldInfoArray[i]);
        }
        return hashMap.values();
    }

    public Collection getPrimaryKeyFields() {
        PersistenceDescriptor persistenceDescriptor = this.getPersistenceDescriptor();
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
        HashMap<String, PersistentFieldInfo> hashMap = new HashMap<String, PersistentFieldInfo>();
        for (int i = 0; i < persistentFieldInfoArray.length; ++i) {
            hashMap.put(persistentFieldInfoArray[i].name, persistentFieldInfoArray[i]);
        }
        return hashMap.values();
    }

    public Collection getSelectors() {
        if (this.selectors == null) {
            this.selectors = new HashSet();
            Class clazz = this.getEjbClass();
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().startsWith("ejbSelect")) continue;
                this.selectors.add(methodArray[i]);
            }
        }
        return this.selectors;
    }

    public String getBaseName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public IASEjbCMPEntityDescriptor() {
        this.pcImplClassName = null;
        this.concreteImplClassName = null;
        this.mappingProperties = null;
    }

    public IASEjbCMPEntityDescriptor(EjbDescriptor ejbDescriptor) {
        super(ejbDescriptor);
        this.setPersistenceType(CONTAINER_PERSISTENCE);
        if (ejbDescriptor instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)ejbDescriptor;
        }
    }

    public void setPcImplClassName(String string) {
        this.pcImplClassName = string;
    }

    protected String getModuleName() {
        String string = super.getEjbBundleDescriptor().getName();
        return string.substring(0, string.length() - 3);
    }

    public String getUniqueName() {
        if (this.actualEjbClassName == null) {
            this.actualEjbClassName = this.getBaseName(super.getEjbClassName());
        }
        String string = this.actualEjbClassName;
        if (this.isRemoteInterfacesSupported()) {
            string = string + "_" + this.getName() + "_" + this.getBaseName(this.getHomeClassName()) + "_" + this.getBaseName(this.getRemoteClassName());
        }
        if (this.isLocalInterfacesSupported()) {
            string = string + "_" + this.getName() + "_" + this.getBaseName(this.getLocalHomeClassName()) + "_" + this.getBaseName(this.getLocalClassName());
        }
        return this.actualEjbClassName + this.getUniqueNumber(string);
    }

    public String getUniqueNumber(String string) {
        String string2 = "" + string.hashCode();
        string2 = string2.replace('-', '_');
        return string2;
    }

    public String getPcImplClassName() {
        String string = this.getPackageName(this.getEjbClassName());
        this.pcImplClassName = this.getUniqueName() + JDOSTATE;
        if (string != null) {
            this.pcImplClassName = string + '.' + this.pcImplClassName;
        }
        _logger.fine("##### PCImplClass Name is " + this.pcImplClassName);
        return this.pcImplClassName;
    }

    public void setConcreteImplClassName(String string) {
        this.concreteImplClassName = string;
    }

    public String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public String getEjbImplClassName() {
        String string = this.getPackageName(super.getEjbClassName());
        String string2 = this.getConcreteImplClassName();
        if (string != null) {
            string2 = string + '.' + string2;
        }
        return string2;
    }

    public String getConcreteImplClassName() {
        this.concreteImplClassName = this.getUniqueName() + "_ConcreteImpl";
        return this.concreteImplClassName;
    }

    public boolean isOneOneCmp() {
        return this.one_one_cmp;
    }

    public void setOneOneCmp(boolean bl) {
        this.one_one_cmp = bl;
    }

    public void setModuleDir(String string) {
        this.moduleDir = this.moduleDir;
    }

    public String getModuleDir() {
        if (this.moduleDir != null) {
            return this.moduleDir;
        }
        return null;
    }

    public void setMappingProperties(String string) {
        this.mappingProperties = string;
    }

    public String getMappingProperties() {
        if (this.mappingProperties == null) {
            _logger.fine("Module Root is :" + this.getModuleDir());
            _logger.fine("Mapping Property is :" + this.getModuleDir() + File.separator + this.getModuleName() + MAPPINGEXT);
            IASEjbBundleDescriptor iASEjbBundleDescriptor = (IASEjbBundleDescriptor)this.getEjbBundleDescriptor();
            this.mappingProperties = iASEjbBundleDescriptor.getModuleDirName() + File.separator + this.getPcImplClassName().replace('.', File.separatorChar) + MAPPINGEXT;
        }
        _logger.fine("#######MappingProperty name is " + this.mappingProperties);
        return this.mappingProperties;
    }

    public boolean classesChanged() {
        return false;
    }

    public String toString() {
        String string = super.toString();
        string = string + "\n cmpVersion " + this.getCMPVersion();
        return string;
    }

    public void setQueryParser(QueryParser queryParser) {
        this.queryParser = queryParser;
    }

    public QueryParser getQueryParser() {
        return this.queryParser;
    }

    private static Map createConversionTable() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Boolean", "java.lang.Boolean");
        hashMap.put("Byte", "java.lang.Byte");
        hashMap.put("Character", "java.lang.Character");
        hashMap.put("Double", "java.lang.Double");
        hashMap.put("Float", "java.lang.Float");
        hashMap.put("Integer", "java.lang.Integer");
        hashMap.put("Long", "java.lang.Long");
        hashMap.put("Number", "java.lang.Number");
        hashMap.put("Short", "java.lang.Short");
        hashMap.put("String", "java.lang.String");
        hashMap.put("Object", "java.lang.Object");
        return hashMap;
    }

    private String getFullyQualifiedType(String string) {
        String string2 = (String)conversionTable.get(string);
        return string2 == null ? string : string2;
    }

    public void addOneOneFinder(IASEjbCMPFinder iASEjbCMPFinder) throws ParseException {
        this.arrOneOneFinders.add(iASEjbCMPFinder);
    }

    public Map getOneOneFinders() {
        if (!this.arrOneOneFinders.isEmpty()) {
            if (this.queryParser == null) {
                String string = localStrings.getString("enterprise.deployment.error_missing_queryparser", "IASEjbCMPEntityDescriptor.getOneOneFinders");
                _logger.log(Level.WARNING, string);
                throw new RuntimeException(string);
            }
            Iterator iterator = this.arrOneOneFinders.iterator();
            while (iterator.hasNext()) {
                IASEjbCMPFinder iASEjbCMPFinder = (IASEjbCMPFinder)iterator.next();
                String string = this.generateKey(iASEjbCMPFinder, this.queryParser);
                this.oneOneFinders.put(string, iASEjbCMPFinder);
            }
            this.arrOneOneFinders.clear();
        }
        return this.oneOneFinders;
    }

    private String generateKey(IASEjbCMPFinder iASEjbCMPFinder, QueryParser queryParser) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iASEjbCMPFinder.getMethodName());
        stringBuffer.append("(");
        String string = iASEjbCMPFinder.getQueryParameterDeclaration();
        Iterator iterator = queryParser.parameterTypeIterator(string);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append(this.getFullyQualifiedType(string2));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString().intern();
    }

    public IASEjbCMPFinder getIASEjbCMPFinder(Method method) {
        if (this.findEquivalentMethod(this.getFinders(), method) == null) {
            return null;
        }
        String string = method.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(classArray[i].getName());
        }
        stringBuffer.append(")");
        return (IASEjbCMPFinder)this.getOneOneFinders().get(stringBuffer.toString());
    }
}

