/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.AppConfigEnv;
import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.deployment.DescriptorConstants;
import com.iplanet.ias.deployment.EjbModuleConfigEnv;
import com.iplanet.ias.deployment.xml.IASEjbRuntimeDescriptorNode;
import com.iplanet.ias.security.Audit;
import com.iplanet.ias.tools.common.dd.SunBaseBean;
import com.iplanet.ias.tools.common.dd.cmpmapping.SunCmpMappings;
import com.iplanet.ias.tools.common.dd.ejb.SunEjbJar;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ArchivistFactory;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.netbeans.modules.schema2beans.BaseBean;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class EjbBundleXmlReader
implements DescriptorConstants {
    private static StringManager localStrings = StringManager.getManager(EjbBundleXmlReader.class);

    public static EjbBundleDescriptor load(AppConfigEnv appConfigEnv, String string, String string2, ClassLoader classLoader, Application application) throws AppConfigException {
        try {
            InputStream inputStream = appConfigEnv.getEjbModuleXmlFile(string, string2);
            InputStream inputStream2 = appConfigEnv.getModuleManifestFile(string);
            InputStream inputStream3 = appConfigEnv.getEjbModuleIASXmlFile(string, string2);
            EjbBundleDescriptor ejbBundleDescriptor = EjbBundleXmlReader.load(inputStream, string, classLoader, inputStream2, inputStream3, application, appConfigEnv.isValidating());
            if (appConfigEnv.isVerifying()) {
                InputStream inputStream4 = appConfigEnv.getEjbModuleIASCmpFile(string, null);
                EjbBundleXmlReader.setSunDescriptors(appConfigEnv.getEjbModuleIASXmlFile(string, string2), inputStream4, ejbBundleDescriptor, appConfigEnv.isValidating());
                ejbBundleDescriptor.fillDocType(appConfigEnv.getEjbModuleXmlFile(string, string2));
            }
            return ejbBundleDescriptor;
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
        catch (IOException iOException) {
            String string3 = localStrings.getString("enterprise.deployment.xml_into_obj_io_error");
            throw new AppConfigException(string3, iOException);
        }
    }

    public static Application loadStdAloneModule(EjbModuleConfigEnv ejbModuleConfigEnv, ClassLoader classLoader) throws AppConfigException, IOException {
        if (classLoader == null) {
            String string = localStrings.getString("enterprise.deployment.null_classloader");
            throw new IllegalArgumentException(string);
        }
        String string = ejbModuleConfigEnv.getId();
        Application application = new Application();
        application.setRegistrationName(string);
        application.setName("module_" + string);
        application.setVirtual(true);
        File file = new File("temp");
        ApplicationArchivist applicationArchivist = ArchivistFactory.createApplicationArchivist(file, application);
        applicationArchivist.setClassLoader(classLoader);
        application.setDummyArchivist(applicationArchivist);
        InputStream inputStream = ejbModuleConfigEnv.getXmlFile();
        InputStream inputStream2 = ejbModuleConfigEnv.getIASXmlFile();
        InputStream inputStream3 = ejbModuleConfigEnv.getManifestFile();
        EjbBundleDescriptor ejbBundleDescriptor = EjbBundleXmlReader.load(inputStream, string, classLoader, inputStream3, inputStream2, application, ejbModuleConfigEnv.isValidating());
        if (ejbModuleConfigEnv.isVerifying()) {
            EjbBundleXmlReader.setSunDescriptors(ejbModuleConfigEnv.getIASXmlFile(), ejbModuleConfigEnv.getIASCmpFile(), ejbBundleDescriptor, ejbModuleConfigEnv.isValidating());
            ejbBundleDescriptor.fillDocType(ejbModuleConfigEnv.getXmlFile());
        }
        application.addEjbBundleDescriptor(ejbBundleDescriptor);
        Audit.showACL(application);
        return application;
    }

    public static EjbBundleDescriptor load(InputStream inputStream, String string, ClassLoader classLoader, InputStream inputStream2, InputStream inputStream3, Application application, boolean bl) throws AppConfigException, IOException {
        if (classLoader == null) {
            String string2 = localStrings.getString("enterprise.deployment.null_classloader");
            throw new IllegalArgumentException(string2);
        }
        EjbBundleNode ejbBundleNode = null;
        try {
            ejbBundleNode = EjbBundleNode.read(inputStream, bl);
        }
        catch (ParseException parseException) {
            String string3 = localStrings.getString("enterprise.deployment.error_parsing_dd", parseException.getSAXException().getMessage());
            throw new AppConfigException(string3, parseException);
        }
        inputStream.close();
        EjbBundleDescriptor ejbBundleDescriptor = null;
        try {
            ejbBundleDescriptor = ejbBundleNode.getDescriptor();
        }
        catch (ContentTransformationException contentTransformationException) {
            String string4 = localStrings.getString("enterprise.deployment.error_converting_xml", string, contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string4, contentTransformationException);
        }
        EjbBundleArchivist ejbBundleArchivist = new EjbBundleArchivist(string, ejbBundleDescriptor);
        if (inputStream2 != null) {
            ejbBundleArchivist.setManifestClasspaths(new Manifest(inputStream2));
            inputStream2.close();
        }
        ejbBundleArchivist.setClassLoader(classLoader);
        ejbBundleNode.completeLoadingDescriptor(ejbBundleDescriptor);
        try {
            IASEjbRuntimeDescriptorNode iASEjbRuntimeDescriptorNode = IASEjbRuntimeDescriptorNode.read(inputStream3, bl);
            iASEjbRuntimeDescriptorNode.updateIASEjbRuntimeInformation(ejbBundleDescriptor, application);
        }
        catch (ParseException parseException) {
            SAXParseException sAXParseException = (SAXParseException)parseException.getSAXException();
            String string5 = localStrings.getString("enterprise.deployment.error_parsing_sun_dd", new Integer(sAXParseException.getLineNumber()), sAXParseException.getLocalizedMessage());
            throw new AppConfigException(string5, sAXParseException);
        }
        catch (ContentTransformationException contentTransformationException) {
            String string6 = localStrings.getString("enterprise.deployment.error_converting_xml", string, contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string6, contentTransformationException);
        }
        inputStream3.close();
        return ejbBundleDescriptor;
    }

    public static void setSunDescriptors(InputStream inputStream, InputStream inputStream2, EjbBundleDescriptor ejbBundleDescriptor, boolean bl) throws AppConfigException {
        XMLValidationHandler xMLValidationHandler = new XMLValidationHandler(bl);
        SunBaseBean sunBaseBean = EjbBundleXmlReader.createSunEjbDescriptorObj(inputStream, bl);
        ejbBundleDescriptor.setSunDescriptor((SunEjbJar)sunBaseBean);
        try {
            if (inputStream2 != null) {
                sunBaseBean = (SunCmpMappings)BaseBean.createGraph((Class)SunCmpMappings.class, (InputStream)inputStream2, (boolean)bl, (EntityResolver)xMLValidationHandler, (ErrorHandler)xMLValidationHandler);
                String string = "META-INF/sun-cmp-mappings.xml";
                ejbBundleDescriptor.setIasCmpMappingObject((SunCmpMappings)sunBaseBean);
            }
        }
        catch (Exception exception) {
            String string = localStrings.getString("enterprise.deployment.error_creating_cmp_xml_graph");
            throw new AppConfigException(string, exception);
        }
    }

    public static EjbBundleDescriptor open(AppConfigEnv appConfigEnv, String string, String string2, ClassLoader classLoader, Application application) throws AppConfigException {
        try {
            InputStream inputStream = appConfigEnv.getEjbModuleXmlFile(string, string2);
            InputStream inputStream2 = appConfigEnv.getModuleManifestFile(string);
            InputStream inputStream3 = appConfigEnv.getEjbModuleIASXmlFile(string, string2);
            EjbBundleDescriptor ejbBundleDescriptor = EjbBundleXmlReader.open(inputStream, string, classLoader, inputStream2, inputStream3, application, appConfigEnv.isValidating());
            if (appConfigEnv.isVerifying()) {
                ejbBundleDescriptor.fillDocType(appConfigEnv.getEjbModuleXmlFile(string, string2));
            }
            return ejbBundleDescriptor;
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
        catch (IOException iOException) {
            String string3 = localStrings.getString("enterprise.deployment.xml_into_obj_io_error");
            throw new AppConfigException(string3, iOException);
        }
    }

    public static EjbBundleDescriptor open(InputStream inputStream, String string, ClassLoader classLoader, InputStream inputStream2, InputStream inputStream3, Application application, boolean bl) throws AppConfigException, IOException {
        if (classLoader == null) {
            String string2 = localStrings.getString("enterprise.deployment.null_classloader");
            throw new IllegalArgumentException(string2);
        }
        EjbBundleNode ejbBundleNode = null;
        try {
            ejbBundleNode = EjbBundleNode.read(inputStream, bl);
        }
        catch (ParseException parseException) {
            String string3 = localStrings.getString("enterprise.deployment.error_parsing_dd", parseException.getSAXException().getMessage());
            throw new AppConfigException(string3, parseException);
        }
        inputStream.close();
        EjbBundleDescriptor ejbBundleDescriptor = null;
        try {
            ejbBundleDescriptor = ejbBundleNode.getDescriptor();
        }
        catch (ContentTransformationException contentTransformationException) {
            String string4 = localStrings.getString("enterprise.deployment.error_converting_xml", string, contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string4, contentTransformationException);
        }
        EjbBundleArchivist ejbBundleArchivist = new EjbBundleArchivist(string, ejbBundleDescriptor);
        if (inputStream2 != null) {
            ejbBundleArchivist.setManifestClasspaths(new Manifest(inputStream2));
            inputStream2.close();
        }
        ejbBundleArchivist.setClassLoader(classLoader);
        ejbBundleNode.completeLoadingDescriptor(ejbBundleDescriptor);
        if (inputStream3 != null) {
            SunEjbJar sunEjbJar = EjbBundleXmlReader.createSunEjbDescriptorObj(inputStream3, bl);
            ejbBundleDescriptor.setSunDescriptor(sunEjbJar);
            inputStream3.close();
        }
        return ejbBundleDescriptor;
    }

    public static SunEjbJar createSunEjbDescriptorObj(InputStream inputStream, boolean bl) throws AppConfigException {
        try {
            XMLValidationHandler xMLValidationHandler = new XMLValidationHandler(bl);
            SunEjbJar sunEjbJar = (SunEjbJar)BaseBean.createGraph((Class)SunEjbJar.class, (InputStream)inputStream, (boolean)bl, (EntityResolver)xMLValidationHandler, (ErrorHandler)xMLValidationHandler);
            return sunEjbJar;
        }
        catch (Exception exception) {
            String string = localStrings.getString("enterprise.deployment.error_creating_ejb_xml_graph");
            throw new AppConfigException(string, exception);
        }
    }
}

