/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.ArchiveInfo;
import com.iplanet.ias.deployment.JarInfo;
import com.iplanet.ias.deployment.WarInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class EarInfo
extends ArchiveInfo {
    private ArrayList jars = new ArrayList();
    private ArrayList wars = new ArrayList();

    EarInfo(File file, File file2) {
        super(file, file2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        Iterator iterator = this.jars.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        iterator = this.wars.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        return stringBuffer.toString();
    }

    public List getAllStringPaths() {
        File[] fileArray;
        Object object;
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(this.getRootPath());
        File[] fileArray2 = this.jars.iterator();
        while (fileArray2.hasNext()) {
            object = (JarInfo)fileArray2.next();
            fileArray = ((JarInfo)object).getAllPaths();
            if (fileArray == null) continue;
            hashSet.addAll(Arrays.asList(fileArray));
        }
        fileArray2 = this.wars.iterator();
        while (fileArray2.hasNext()) {
            object = (WarInfo)fileArray2.next();
            fileArray = ((WarInfo)object).getAllPaths();
            if (fileArray == null) continue;
            hashSet.addAll(Arrays.asList(fileArray));
        }
        fileArray2 = new File[hashSet.size()];
        hashSet.toArray(fileArray2);
        Arrays.sort(fileArray2, new FilenameComparator());
        object = new ArrayList();
        for (int i = 0; i < fileArray2.length; ++i) {
            try {
                ((ArrayList)object).add(fileArray2[i].getCanonicalPath());
                continue;
            }
            catch (IOException iOException) {
                ((ArrayList)object).add(fileArray2[i].getAbsolutePath());
            }
        }
        return object;
    }

    public File[] getAllPaths() {
        File[] fileArray;
        ArchiveInfo archiveInfo;
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(this.getRootPath());
        File[] fileArray2 = this.jars.iterator();
        while (fileArray2.hasNext()) {
            archiveInfo = (JarInfo)fileArray2.next();
            fileArray = ((JarInfo)archiveInfo).getAllPaths();
            if (fileArray == null) continue;
            hashSet.addAll(Arrays.asList(fileArray));
        }
        fileArray2 = this.wars.iterator();
        while (fileArray2.hasNext()) {
            archiveInfo = (WarInfo)fileArray2.next();
            fileArray = ((WarInfo)archiveInfo).getAllPaths();
            if (fileArray == null) continue;
            hashSet.addAll(Arrays.asList(fileArray));
        }
        fileArray2 = new File[hashSet.size()];
        hashSet.toArray(fileArray2);
        Arrays.sort(fileArray2, new FilenameComparator());
        return fileArray2;
    }

    void addJarInfo(JarInfo jarInfo) {
        this.jars.add(jarInfo);
    }

    List getJarInfos() {
        return this.jars;
    }

    void addWarInfo(WarInfo warInfo) {
        this.wars.add(warInfo);
    }

    List getWarInfos() {
        return this.wars;
    }

    private static class FilenameComparator
    implements Comparator {
        private FilenameComparator() {
        }

        public int compare(Object object, Object object2) {
            return object.toString().compareToIgnoreCase(object2.toString());
        }
    }
}

