/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.AppConfigEnv;
import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.deployment.DescriptorConstants;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFileException;
import com.iplanet.ias.util.zip.ZipWriter;
import com.sun.enterprise.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class EarConfigEnvImpl
implements AppConfigEnv,
DescriptorConstants {
    private String _earName = null;
    private String _appDir = null;
    private String _appId = null;
    private boolean _validateXml = false;
    private boolean _ejbModulesOnly = false;
    private boolean _verify = false;
    private static final String DIR_SUFFIX = "assembly-";
    private static final String EX_SUFFIX = "~";
    private static StringManager localStrings = StringManager.getManager(EarConfigEnvImpl.class);

    public EarConfigEnvImpl(File file) throws AppConfigException {
        this(file, file.getName());
    }

    public EarConfigEnvImpl(File file, String string) throws AppConfigException {
        this(file, string, false);
    }

    public EarConfigEnvImpl(File file, String string, boolean bl) throws AppConfigException {
        try {
            this._appDir = FileUtil.getTempDirectory().getCanonicalPath() + File.separator + DIR_SUFFIX + System.currentTimeMillis();
            this._earName = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            String string2 = localStrings.getString("enterprise.deployment.error_getting_temp_dir", this._appDir);
            throw new AppConfigException(string2, iOException);
        }
        this._appId = string;
        this._validateXml = bl;
        if (file.exists()) {
            try {
                com.iplanet.ias.util.zip.ZipFile zipFile = new com.iplanet.ias.util.zip.ZipFile(file, new File(this._appDir));
                zipFile.explode();
            }
            catch (ZipFileException zipFileException) {
                String string3 = localStrings.getString("enterprise.deployment.error_exploding_ear", this._earName);
                throw new AppConfigException(string3, zipFileException);
            }
        }
    }

    public EarConfigEnvImpl(File file, String string, String string2, boolean bl) throws AppConfigException {
        this._appDir = string2;
        this._appId = string;
        this._validateXml = bl;
        try {
            this._earName = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            String string3 = localStrings.getString("enterprise.deployment.error_getting_ear_location", file.getPath());
            throw new AppConfigException(string3, iOException);
        }
        if (file.exists()) {
            try {
                com.iplanet.ias.util.zip.ZipFile zipFile = new com.iplanet.ias.util.zip.ZipFile(file, new File(this._appDir));
                zipFile.explode();
            }
            catch (ZipFileException zipFileException) {
                String string4 = localStrings.getString("enterprise.deployment.error_exploding_ear", this._earName);
                throw new AppConfigException(string4, zipFileException);
            }
        }
    }

    public EarConfigEnvImpl(String string, String string2, boolean bl) {
        this._appDir = string;
        this._appId = string2;
        this._validateXml = bl;
    }

    public String getId() {
        return this._appId;
    }

    public String getAppDir() {
        return this._appDir;
    }

    public boolean isValidating() {
        return this._validateXml;
    }

    public InputStream getApplicationXmlFile() throws AppConfigException {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(APPLICATION_DD_ENTRY);
        }
        catch (Throwable throwable) {
            File file = new File(this._appDir, APPLICATION_DD_ENTRY);
            String string = localStrings.getString("enterprise.deployment.error_reading_file", file.getPath());
            throw new AppConfigException(string, throwable);
        }
        return inputStream;
    }

    public OutputStream getApplicationXmlOutFile() throws AppConfigException {
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream(APPLICATION_DD_ENTRY);
        }
        catch (Throwable throwable) {
            File file = new File(this._appDir, APPLICATION_DD_ENTRY);
            String string = localStrings.getString("enterprise.deployment.error_writing_file", file.getPath());
            throw new AppConfigException(string, throwable);
        }
        return outputStream;
    }

    public InputStream getApplicationIASXmlFile() throws AppConfigException {
        InputStream inputStream = null;
        File file = new File(this._appDir, IAS_APPLICATION_DD_ENTRY);
        if (file.exists()) {
            try {
                inputStream = this.getInputStream(IAS_APPLICATION_DD_ENTRY);
            }
            catch (Throwable throwable) {
                File file2 = new File(this._appDir, IAS_APPLICATION_DD_ENTRY);
                String string = localStrings.getString("enterprise.deployment.error_reading_file", file2.getPath());
                throw new AppConfigException(string, throwable);
            }
        }
        return inputStream;
    }

    public OutputStream getApplicationIASXmlOutFile() throws AppConfigException {
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream(IAS_APPLICATION_DD_ENTRY);
        }
        catch (Throwable throwable) {
            File file = new File(this._appDir, IAS_APPLICATION_DD_ENTRY);
            String string = localStrings.getString("enterprise.deployment.error_writing_file", file.getPath());
            throw new AppConfigException(string, throwable);
        }
        return outputStream;
    }

    public OutputStream getEjbModuleXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, "META-INF/ejb-jar.xml");
    }

    public InputStream getEjbModuleXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, "META-INF/ejb-jar.xml");
    }

    public InputStream getEjbModuleIASXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, "META-INF/sun-ejb-jar.xml");
    }

    public OutputStream getEjbModuleIASXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, "META-INF/sun-ejb-jar.xml");
    }

    public InputStream getEjbModuleIASCmpFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, "META-INF/sun-cmp-mappings.xml");
    }

    public InputStream getWebModuleXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, "WEB-INF/web.xml");
    }

    public OutputStream getWebModuleXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, "WEB-INF/web.xml");
    }

    public InputStream getWebModuleIASXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, "WEB-INF/sun-web.xml");
    }

    public OutputStream getWebModuleIASXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, "WEB-INF/sun-web.xml");
    }

    public Iterator getAllTagLibs(String string) throws AppConfigException {
        ArrayList<BufferedInputStream> arrayList = new ArrayList<BufferedInputStream>();
        try {
            ZipFile zipFile = new ZipFile(this._appDir + File.separator + string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (!string2.startsWith("WEB-INF") || !string2.endsWith(".tld")) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                arrayList.add(bufferedInputStream);
            }
        }
        catch (Throwable throwable) {
            throw new AppConfigException(throwable);
        }
        return arrayList.iterator();
    }

    public InputStream getClientModuleXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, "META-INF/application-client.xml");
    }

    public OutputStream getClientModuleXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, "META-INF/application-client.xml");
    }

    public InputStream getClientModuleIASXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, "META-INF/sun-application-client.xml");
    }

    public OutputStream getClientModuleIASXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, "META-INF/sun-application-client.xml");
    }

    public InputStream getRarModuleXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, "META-INF/ra.xml");
    }

    public OutputStream getRarModuleXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, "META-INF/ra.xml");
    }

    public InputStream getRarModuleIASXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, "META-INF/sun-ra.xml");
    }

    public OutputStream getRarModuleIASXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, "META-INF/sun-ra.xml");
    }

    public InputStream getModuleManifestFile(String string) {
        InputStream inputStream = null;
        try {
            String string2 = this._appDir + File.separator + string;
            inputStream = this.getZipInputStream(new ZipFile(string2), "META-INF/MANIFEST.MF", false);
        }
        catch (IOException iOException) {
        }
        catch (AppConfigException appConfigException) {
            // empty catch block
        }
        return inputStream;
    }

    public String getAppMainClassName() throws AppConfigException {
        String string = null;
        try {
            InputStream inputStream = this.getAppManifestFile();
            if (inputStream != null) {
                string = EarConfigEnvImpl.getMainClassNameFrom(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
        return string;
    }

    public String getModuleMainClassName(String string) throws AppConfigException {
        String string2 = null;
        try {
            InputStream inputStream = this.getModuleManifestFile(string);
            if (inputStream != null) {
                string2 = EarConfigEnvImpl.getMainClassNameFrom(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
        return string2;
    }

    public void assemble() throws AppConfigException {
        try {
            File file = new File(this._appDir);
            if (file.exists()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (!FileUtils.hasExtension(fileArray[i], EX_SUFFIX) || !fileArray[i].isDirectory()) continue;
                        String string = fileArray[i].getCanonicalPath();
                        String string2 = string.substring(0, string.length() - 1);
                        ZipWriter zipWriter = new ZipWriter(string2, string);
                        zipWriter.write();
                        FileUtils.liquidate(fileArray[i]);
                    }
                }
                ZipWriter zipWriter = new ZipWriter(this._earName, this._appDir);
                zipWriter.write();
                FileUtils.liquidate(file);
            }
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.ioerror_creating_ear", this._earName);
            throw new AppConfigException(string, iOException);
        }
        catch (ZipFileException zipFileException) {
            String string = localStrings.getString("enterprise.deployment.error_creating_ear", this._earName);
            throw new AppConfigException(string, zipFileException);
        }
    }

    public void setEjbModulesOnly(boolean bl) {
        this._ejbModulesOnly = bl;
    }

    public boolean isEjbModulesOnly() {
        return this._ejbModulesOnly;
    }

    public void setVerifying(boolean bl) {
        this._verify = bl;
    }

    public boolean isVerifying() {
        return this._verify;
    }

    private InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, true);
    }

    private InputStream getZipInputStream(String string, String string2) throws AppConfigException, IOException {
        return this.getZipInputStream(new ZipFile(string), string2, true);
    }

    private InputStream getInputStream(String string, boolean bl) throws IOException {
        File file = new File(this._appDir, string);
        BufferedInputStream bufferedInputStream = null;
        if (bl || file.isFile()) {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        return bufferedInputStream;
    }

    private InputStream getZipInputStream(ZipFile zipFile, String string, boolean bl) throws AppConfigException {
        try {
            BufferedInputStream bufferedInputStream = null;
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null && bl) {
                String string2 = localStrings.getString("enterprise.deployment.application_entry_missing", string, zipFile.toString());
                throw new AppConfigException(string2);
            }
            if (bl || zipFile != null) {
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            }
            return bufferedInputStream;
        }
        catch (IOException iOException) {
            String string3 = localStrings.getString("enterprise.deployment.zip_io_error", string, zipFile.toString());
            throw new AppConfigException(string3);
        }
    }

    private OutputStream getOutputStream(String string) throws IOException {
        File file = new File(this._appDir, string);
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        return bufferedOutputStream;
    }

    private InputStream getAppManifestFile() {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(MANIFEST_ENTRY, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inputStream;
    }

    private static String getMainClassNameFrom(InputStream inputStream) throws IOException {
        Manifest manifest = new Manifest(inputStream);
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null && attributes.get(Attributes.Name.MAIN_CLASS) != null) {
            return (String)attributes.get(Attributes.Name.MAIN_CLASS);
        }
        String string = localStrings.getString("enterprise.deployment.incorrect_manifest_format");
        throw new IOException(string);
    }

    private InputStream getXmlFile(String string, String string2, String string3) throws AppConfigException {
        InputStream inputStream = null;
        String string4 = null;
        try {
            boolean bl = true;
            if (string3.equals("WEB-INF/sun-web.xml") || string3.equals("META-INF/sun-cmp-mappings.xml")) {
                bl = false;
            }
            if (string2 != null) {
                if (string3.indexOf("sun-") >= 0) {
                    File file = new File(string2);
                    String string5 = "sun-" + file.getName();
                    File file2 = new File(file.getParent(), string5);
                    string4 = file2.getPath();
                } else {
                    string4 = string2;
                }
                inputStream = this.getInputStream(string4, bl);
            } else {
                string4 = this._appDir + File.separator + string;
                inputStream = this.getZipInputStream(new ZipFile(string4), string3, bl);
            }
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
        catch (Throwable throwable) {
            String string6 = string4 + " [" + string3 + "]";
            String string7 = localStrings.getString("enterprise.deployment.error_reading_file", string4);
            throw new AppConfigException(string7, throwable);
        }
        return inputStream;
    }

    private OutputStream getXmlOutFile(String string, String string2, String string3) throws AppConfigException {
        OutputStream outputStream = null;
        String string4 = null;
        try {
            if (string2 != null) {
                if (string3.indexOf("sun-") >= 0) {
                    File file = new File(string2);
                    String string5 = "sun-" + file.getName();
                    File file2 = new File(file.getParent(), string5);
                    string4 = file2.getPath();
                } else {
                    string4 = string2;
                }
                outputStream = this.getOutputStream(string4);
            } else {
                String string6 = this._appDir + File.separator + string;
                String string7 = string6 + EX_SUFFIX;
                File file = new File(string6);
                File file3 = new File(string7);
                if (file.exists()) {
                    try {
                        com.iplanet.ias.util.zip.ZipFile zipFile = new com.iplanet.ias.util.zip.ZipFile(file, file3);
                        zipFile.explode();
                    }
                    catch (ZipFileException zipFileException) {
                        throw new AppConfigException("Unable to explode jar!", zipFileException);
                    }
                } else {
                    file3.mkdirs();
                }
                string4 = string + EX_SUFFIX + File.separator + string3;
                outputStream = this.getOutputStream(string4);
            }
        }
        catch (Throwable throwable) {
            String string8 = string4 + " [" + string3 + "]";
            String string9 = localStrings.getString("enterprise.deployment.error_writing_file", string8);
            throw new AppConfigException(string9, throwable);
        }
        return outputStream;
    }
}

