/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DOLDiagnostic {
    private static final Logger _logger = DeploymentLogger.get();

    public static void log(Application application) {
        try {
            Application application2 = application;
            if (_logger.isLoggable(Level.FINE)) {
                Object object;
                StringBuffer stringBuffer = new StringBuffer("\nDOL Summary");
                stringBuffer.append("\n\nApplication Name: " + application2.getName());
                stringBuffer.append("\n   Unique ID: " + application2.getUniqueId());
                stringBuffer.append("\n   Virtual: " + application2.isVirtual());
                if (application2.isPassByReferenceDefined()) {
                    stringBuffer.append("\n   Pass By Reference: " + application2.getPassByReference());
                } else {
                    stringBuffer.append("\n   Pass By Reference: " + application2.getPassByReference() + " (default)");
                }
                stringBuffer.append("\n");
                Iterator iterator = application2.getWebBundleDescriptors().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    object = (WebBundleDescriptor)iterator.next();
                    stringBuffer.append("\n   Web Bundle [" + n + "]");
                    if (!((Descriptor)object).getName().equals("")) {
                        stringBuffer.append("\n      Name: " + ((Descriptor)object).getName());
                    }
                    stringBuffer.append("\n      Context Root: " + ((WebBundleDescriptor)object).getContextRoot());
                    stringBuffer.append("\n");
                }
                object = application2.getEjbBundleDescriptors().iterator();
                int n2 = 0;
                while (object.hasNext()) {
                    EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)object.next();
                    stringBuffer.append("\n   EJB Bundle [" + n2 + "]");
                    stringBuffer.append("\n      Name: " + ejbBundleDescriptor.getName());
                    stringBuffer.append("\n");
                    Iterator iterator2 = ejbBundleDescriptor.getEjbs().iterator();
                    int n3 = 0;
                    while (iterator2.hasNext()) {
                        EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator2.next();
                        stringBuffer.append("\n      EJB [" + n3 + "]");
                        if (ejbDescriptor.getName() != null) {
                            stringBuffer.append("\n         Name: " + ejbDescriptor.getName());
                        }
                        if (ejbDescriptor.getJndiName() != null) {
                            stringBuffer.append("\n         JNDI Name: " + ejbDescriptor.getJndiName());
                        }
                        if (ejbDescriptor.getType() != null) {
                            stringBuffer.append("\n         Type:  " + ejbDescriptor.getType());
                        }
                        if (ejbDescriptor.getHomeClassName() != null) {
                            stringBuffer.append("\n         Home Class Name: " + ejbDescriptor.getHomeClassName());
                        }
                        if (ejbDescriptor.getLocalClassName() != null) {
                            stringBuffer.append("\n         Local Class Name: " + ejbDescriptor.getLocalClassName());
                        }
                        if (ejbDescriptor.getLocalHomeClassName() != null) {
                            stringBuffer.append("\n         Local Home Class Name: " + ejbDescriptor.getLocalHomeClassName());
                        }
                        if (ejbDescriptor.getRemoteClassName() != null) {
                            stringBuffer.append("\n         Remote Class Name: " + ejbDescriptor.getRemoteClassName());
                        }
                        stringBuffer.append("\n         Local Interfaces Supported: " + ejbDescriptor.isLocalInterfacesSupported());
                        stringBuffer.append("\n         Remote Interfaces Supported: " + ejbDescriptor.isRemoteInterfacesSupported());
                        if (ejbDescriptor.getIASEjbExtraDescriptors().getCommitOption() != null) {
                            stringBuffer.append("\n         Commit Option: " + ejbDescriptor.getIASEjbExtraDescriptors().getCommitOption());
                        }
                        stringBuffer.append("\n         Read Only Bean: " + ejbDescriptor.getIASEjbExtraDescriptors().isIsReadOnlyBean());
                        stringBuffer.append("\n         Refresh Period In Seconds: " + ejbDescriptor.getIASEjbExtraDescriptors().getRefreshPeriodInSeconds());
                        stringBuffer.append("\n         JMS Max Messages Load: " + ejbDescriptor.getIASEjbExtraDescriptors().getJmsMaxMessagesLoad());
                        if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache() != null) {
                            stringBuffer.append("\n         Bean Cache: ");
                            if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache().getCacheIdleTimeoutInSeconds() != -1) {
                                stringBuffer.append("\n            Cache Idle Timeout In Seconds: " + ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache().getCacheIdleTimeoutInSeconds());
                            }
                            if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache().getMaxCacheSize() != -1) {
                                stringBuffer.append("\n            Maximum Cache Size: " + ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache().getMaxCacheSize());
                            }
                            if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache().getRemovalTimeoutInSeconds() != -1) {
                                stringBuffer.append("\n            Removal Timout In Seconds: " + ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache().getRemovalTimeoutInSeconds());
                            }
                            if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache().getVictimSelectionPolicy() != null) {
                                stringBuffer.append("\n            Victim Selection Policy: " + ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache().getVictimSelectionPolicy());
                            }
                            if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache().isIsCacheOverflowAllowed() != null) {
                                stringBuffer.append("\n            Cache Overflow Allowed: " + ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache().isIsCacheOverflowAllowed());
                            }
                        }
                        if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool() != null) {
                            stringBuffer.append("\n         Bean Pool: ");
                            if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool().getMaxPoolSize() != -1) {
                                stringBuffer.append("\n            Max Pool Size: " + ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool().getMaxPoolSize());
                            }
                            if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool().getMaxWaitTimeInMillis() != -1) {
                                stringBuffer.append("\n            Maximum Wait Time in Milliseconds: " + ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool().getMaxWaitTimeInMillis());
                            }
                            if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool().getPoolIdleTimeoutInSeconds() != -1) {
                                stringBuffer.append("\n            Pool Idle Timeout In Seconds: " + ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool().getPoolIdleTimeoutInSeconds());
                            }
                            if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool().getPoolResizeQuantity() != -1) {
                                stringBuffer.append("\n            Pool Resize Quantity: " + ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool().getPoolResizeQuantity());
                            }
                            if (ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool().getSteadyPoolSize() != -1) {
                                stringBuffer.append("\n            Steady Pool Size: " + ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool().getSteadyPoolSize());
                            }
                        }
                        Iterator iterator3 = ejbDescriptor.getResourceReferenceDescriptors().iterator();
                        int n4 = 0;
                        while (iterator3.hasNext()) {
                            ResourceReferenceDescriptor resourceReferenceDescriptor = (ResourceReferenceDescriptor)iterator3.next();
                            stringBuffer.append("\n         Resource Reference [" + n4 + "]");
                            if (resourceReferenceDescriptor.getJndiName() != null) {
                                stringBuffer.append("\n            JNDI Name: " + resourceReferenceDescriptor.getJndiName());
                            }
                            if (resourceReferenceDescriptor.getType() != null) {
                                stringBuffer.append("\n            Type: " + resourceReferenceDescriptor.getType());
                            }
                            ++n4;
                        }
                        ++n3;
                        stringBuffer.append("\n         Pass By Reference: " + ejbDescriptor.getIASEjbExtraDescriptors().getPassByReference());
                        if (!ejbDescriptor.getIASEjbExtraDescriptors().isPassByReferenceDefined()) {
                            if (application2.isPassByReferenceDefined()) {
                                stringBuffer.append(" (application default)");
                            } else {
                                stringBuffer.append(" (default)");
                            }
                        }
                        stringBuffer.append("\n");
                    }
                    ++n2;
                }
                if (stringBuffer != null) {
                    _logger.fine(stringBuffer.toString());
                }
            }
        }
        catch (Exception exception) {
            _logger.fine("Error writing DOL Summary");
        }
    }
}

