/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.AppConfigEnv;
import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.deployment.DescriptorConstants;
import com.iplanet.ias.deployment.RarModuleConfigEnv;
import com.iplanet.ias.tools.common.dd.connector.SunConnector;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ArchivistFactory;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.netbeans.modules.schema2beans.BaseBean;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class ConnectorXmlReader
implements DescriptorConstants {
    private static StringManager localStrings = StringManager.getManager(ConnectorXmlReader.class);

    public static ConnectorDescriptor load(AppConfigEnv appConfigEnv, String string, String string2) throws AppConfigException, IOException {
        InputStream inputStream = appConfigEnv.getRarModuleXmlFile(string, string2);
        InputStream inputStream2 = appConfigEnv.getRarModuleIASXmlFile(string, string2);
        InputStream inputStream3 = appConfigEnv.getModuleManifestFile(string);
        ConnectorDescriptor connectorDescriptor = ConnectorXmlReader.load(inputStream, string, inputStream3, inputStream2, appConfigEnv.isValidating());
        if (inputStream != null) {
            inputStream.close();
        }
        if (inputStream2 != null) {
            inputStream2.close();
        }
        if (inputStream3 != null) {
            inputStream3.close();
        }
        if (appConfigEnv.isVerifying()) {
            connectorDescriptor.fillDocType(appConfigEnv.getRarModuleXmlFile(string, string2));
        }
        return connectorDescriptor;
    }

    public static Application loadStdAloneModule(RarModuleConfigEnv rarModuleConfigEnv) throws AppConfigException, IOException {
        String string = rarModuleConfigEnv.getId();
        Application application = new Application();
        application.setRegistrationName(string);
        application.setName("module_" + string);
        application.setVirtual(true);
        File file = new File("temp");
        ApplicationArchivist applicationArchivist = ArchivistFactory.createApplicationArchivist(file, application);
        application.setDummyArchivist(applicationArchivist);
        InputStream inputStream = rarModuleConfigEnv.getXmlFile();
        InputStream inputStream2 = rarModuleConfigEnv.getIASXmlFile();
        InputStream inputStream3 = rarModuleConfigEnv.getManifestFile();
        ConnectorDescriptor connectorDescriptor = ConnectorXmlReader.load(inputStream, string, inputStream3, inputStream2, rarModuleConfigEnv.isValidating());
        if (inputStream != null) {
            inputStream.close();
        }
        if (inputStream2 != null) {
            inputStream2.close();
        }
        if (inputStream3 != null) {
            inputStream3.close();
        }
        if (rarModuleConfigEnv.isVerifying()) {
            connectorDescriptor.fillDocType(rarModuleConfigEnv.getXmlFile());
        }
        application.addRarDescriptor(connectorDescriptor);
        return application;
    }

    public static ConnectorDescriptor load(InputStream inputStream, String string, InputStream inputStream2, InputStream inputStream3, boolean bl) throws AppConfigException, IOException {
        ConnectorNode connectorNode = null;
        try {
            connectorNode = ConnectorNode.read(inputStream, bl);
        }
        catch (ParseException parseException) {
            String string2 = localStrings.getString("enterprise.deployment.error_parsing_rar_dd", parseException.getSAXException().getMessage());
            throw new AppConfigException(string2, parseException);
        }
        ConnectorDescriptor connectorDescriptor = null;
        try {
            connectorDescriptor = connectorNode.getDescriptor();
        }
        catch (ContentTransformationException contentTransformationException) {
            String string3 = localStrings.getString("enterprise.deployment.error_converting_rar_xml", string, contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string3, contentTransformationException);
        }
        ConnectorArchivist connectorArchivist = new ConnectorArchivist(string, connectorDescriptor);
        if (inputStream2 != null) {
            connectorArchivist.setManifestClasspaths(new Manifest(inputStream2));
        }
        if (inputStream3 != null) {
            SunConnector sunConnector = ConnectorXmlReader.createSunConnectorDescriptorObj(inputStream3, bl);
            connectorDescriptor.setSunDescriptor(sunConnector);
        }
        return connectorDescriptor;
    }

    public static ConnectorDescriptor open(AppConfigEnv appConfigEnv, String string, String string2) throws AppConfigException, IOException {
        InputStream inputStream;
        InputStream inputStream2 = appConfigEnv.getRarModuleXmlFile(string, string2);
        ConnectorNode connectorNode = null;
        try {
            connectorNode = ConnectorNode.read(inputStream2, appConfigEnv.isValidating());
        }
        catch (ParseException parseException) {
            String string3 = localStrings.getString("enterprise.deployment.error_parsing_rar_dd", parseException.getSAXException().getMessage());
            throw new AppConfigException(string3, parseException);
        }
        inputStream2.close();
        ConnectorDescriptor connectorDescriptor = null;
        try {
            connectorDescriptor = connectorNode.getDescriptor();
        }
        catch (ContentTransformationException contentTransformationException) {
            String string4 = localStrings.getString("enterprise.deployment.error_converting_rar_xml", string, contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string4, contentTransformationException);
        }
        ConnectorArchivist connectorArchivist = new ConnectorArchivist(string, connectorDescriptor);
        InputStream inputStream3 = appConfigEnv.getModuleManifestFile(string);
        if (inputStream3 != null) {
            connectorArchivist.setManifestClasspaths(new Manifest(inputStream3));
            inputStream3.close();
        }
        if ((inputStream = appConfigEnv.getRarModuleIASXmlFile(string, string2)) != null) {
            SunConnector sunConnector = ConnectorXmlReader.createSunConnectorDescriptorObj(inputStream, appConfigEnv.isValidating());
            connectorDescriptor.setSunDescriptor(sunConnector);
            inputStream.close();
        }
        if (appConfigEnv.isVerifying()) {
            connectorDescriptor.fillDocType(appConfigEnv.getRarModuleXmlFile(string, string2));
        }
        return connectorDescriptor;
    }

    public static SunConnector createSunConnectorDescriptorObj(InputStream inputStream, boolean bl) throws AppConfigException {
        try {
            XMLValidationHandler xMLValidationHandler = new XMLValidationHandler(bl);
            SunConnector sunConnector = (SunConnector)BaseBean.createGraph((Class)SunConnector.class, (InputStream)inputStream, (boolean)bl, (EntityResolver)xMLValidationHandler, (ErrorHandler)xMLValidationHandler);
            return sunConnector;
        }
        catch (Exception exception) {
            String string = localStrings.getString("enterprise.deployment.error_creating_connector_xml_graph");
            throw new AppConfigException(string, exception);
        }
    }
}

