/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.DescriptorConstants;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFile;
import com.iplanet.ias.util.zip.ZipFileException;
import com.iplanet.ias.util.zip.ZipItem;
import com.sun.enterprise.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ClientJarArchivist
implements DescriptorConstants {
    private File archive = null;
    private File clientJar = null;
    private static StringManager localStrings = StringManager.getManager(ClientJarArchivist.class);
    private static final String TMP_JAR_PREFIX = "client-archivist";
    private static final boolean debug = false;
    private static final Logger _logger = DeploymentLogger.get();

    public ClientJarArchivist(File file, File file2) {
        this.archive = file;
        this.clientJar = file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createClientJar(ZipItem[] zipItemArray) throws IOException, ZipFileException {
        boolean bl;
        if (!this.clientJar.exists() && (bl = this.clientJar.getParentFile().mkdirs())) {
            String string = localStrings.getString("enterprise.deployment.error_creating_client_jar", this.clientJar.getPath());
            throw new IOException(string);
        }
        JarFile jarFile = new JarFile(this.archive);
        ZipOutputStream zipOutputStream = this.getZipOutputStream(this.clientJar);
        int i = 0;
        while (true) {
            block15: {
                BufferedInputStream bufferedInputStream;
                FileInputStream fileInputStream;
                block16: {
                    Object var10_12;
                    if (i >= zipItemArray.length) {
                        this.makeClientJar(jarFile, zipOutputStream);
                        zipOutputStream.close();
                        return;
                    }
                    fileInputStream = null;
                    bufferedInputStream = null;
                    try {
                        try {
                            String string = zipItemArray[i].getName();
                            File file = zipItemArray[i].getFile();
                            fileInputStream = new FileInputStream(file);
                            bufferedInputStream = new BufferedInputStream(fileInputStream);
                            zipOutputStream.putNextEntry(new ZipEntry(string));
                            FileUtils.copyWithoutClose(bufferedInputStream, zipOutputStream);
                        }
                        catch (ZipException zipException) {
                            var10_12 = null;
                            if (zipOutputStream != null) {
                                zipOutputStream.closeEntry();
                            }
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            if (bufferedInputStream != null) {
                                bufferedInputStream.close();
                            }
                            break block15;
                        }
                        var10_12 = null;
                        if (zipOutputStream == null) break block16;
                    }
                    catch (Throwable throwable) {
                        var10_12 = null;
                        if (zipOutputStream != null) {
                            zipOutputStream.closeEntry();
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                        throw throwable;
                    }
                    zipOutputStream.closeEntry();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            ++i;
        }
    }

    private void makeClientJar(JarFile jarFile, ZipOutputStream zipOutputStream) throws IOException, ZipFileException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (string == null || string.endsWith(".war") || string.endsWith(".rar") || zipEntry.getSize() <= 0L) continue;
            this.addJarEntry(jarFile, zipEntry, zipOutputStream);
            if (!string.endsWith(".jar")) continue;
            File file = null;
            File file2 = null;
            try {
                file2 = FileUtil.getTempDirectory();
                file = File.createTempFile(TMP_JAR_PREFIX, ".jar", file2);
                ZipFile.extractJar(string, jarFile, file);
            }
            catch (IOException iOException) {
                String string2 = "client-archivist.jar";
                String string3 = null;
                string3 = file2 != null ? localStrings.getString("enterprise.deployment.error_creating_tmparchive", file2.getAbsolutePath() + "/" + string2) : localStrings.getString("enterprise.deployment.error_creating_tmparchive", string2);
                _logger.log(Level.INFO, string3 + " : " + iOException.getMessage());
                throw new IOException(string3 + iOException.getMessage());
            }
            this.makeClientJar(new JarFile(file), zipOutputStream);
            file.delete();
        }
    }

    private void addJarEntry(JarFile jarFile, ZipEntry zipEntry, ZipOutputStream zipOutputStream) throws IOException {
        try {
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            ZipEntry zipEntry2 = new ZipEntry(zipEntry);
            zipEntry2.setCompressedSize(-1L);
            zipOutputStream.putNextEntry(zipEntry2);
            FileUtils.copyWithoutClose(inputStream, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (ZipException zipException) {
            // empty catch block
        }
    }

    private ZipOutputStream getZipOutputStream(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        return zipOutputStream;
    }
}

