/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.AppConfigEnv;
import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.deployment.DescriptorConstants;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class AppConfigEnvImpl
implements AppConfigEnv,
DescriptorConstants {
    private String _appDir = null;
    private String _appId = null;
    private boolean _validateXml = false;
    private boolean _ejbModulesOnly = false;
    private boolean _verify = false;
    private static StringManager localStrings = StringManager.getManager(AppConfigEnvImpl.class);

    public AppConfigEnvImpl(String string, String string2, boolean bl) {
        this._appDir = string;
        this._appId = string2;
        this._validateXml = bl;
    }

    public String getId() {
        return this._appId;
    }

    public boolean isValidating() {
        return this._validateXml;
    }

    public void assemble() {
    }

    public InputStream getApplicationXmlFile() throws AppConfigException {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(APPLICATION_DD_ENTRY);
        }
        catch (Throwable throwable) {
            File file = new File(this._appDir, APPLICATION_DD_ENTRY);
            String string = localStrings.getString("enterprise.deployment.error_reading_file", file.getPath());
            throw new AppConfigException(string, throwable);
        }
        return inputStream;
    }

    public OutputStream getApplicationXmlOutFile() throws AppConfigException {
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream(APPLICATION_DD_ENTRY);
        }
        catch (Throwable throwable) {
            File file = new File(this._appDir, APPLICATION_DD_ENTRY);
            String string = localStrings.getString("enterprise.deployment.error_writing_file", file.getPath());
            throw new AppConfigException(string, throwable);
        }
        return outputStream;
    }

    public InputStream getApplicationIASXmlFile() throws AppConfigException {
        InputStream inputStream = null;
        File file = new File(this._appDir, IAS_APPLICATION_DD_ENTRY);
        if (file.exists()) {
            try {
                inputStream = this.getInputStream(IAS_APPLICATION_DD_ENTRY);
            }
            catch (Throwable throwable) {
                File file2 = new File(this._appDir, IAS_APPLICATION_DD_ENTRY);
                String string = localStrings.getString("enterprise.deployment.error_reading_file", file2.getPath());
                throw new AppConfigException(string, throwable);
            }
        }
        return inputStream;
    }

    public OutputStream getApplicationIASXmlOutFile() throws AppConfigException {
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream(IAS_APPLICATION_DD_ENTRY);
        }
        catch (Throwable throwable) {
            File file = new File(this._appDir, IAS_APPLICATION_DD_ENTRY);
            String string = localStrings.getString("enterprise.deployment.error_writing_file", file.getPath());
            throw new AppConfigException(string, throwable);
        }
        return outputStream;
    }

    public OutputStream getEjbModuleXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, EJB_DD_ENTRY);
    }

    public InputStream getEjbModuleXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, EJB_DD_ENTRY);
    }

    public InputStream getEjbModuleIASXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, IAS_EJB_DD_ENTRY);
    }

    public OutputStream getEjbModuleIASXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, IAS_EJB_DD_ENTRY);
    }

    public InputStream getEjbModuleIASCmpFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, IAS_CMP_MAPPING_DD_ENTRY);
    }

    public InputStream getWebModuleXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, WEB_DD_ENTRY);
    }

    public OutputStream getWebModuleXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, WEB_DD_ENTRY);
    }

    public InputStream getWebModuleIASXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, IAS_WEB_DD_ENTRY);
    }

    public OutputStream getWebModuleIASXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, IAS_WEB_DD_ENTRY);
    }

    public Iterator getAllTagLibs(String string) throws AppConfigException {
        ArrayList<BufferedInputStream> arrayList = new ArrayList<BufferedInputStream>();
        try {
            String string2 = FileUtils.makeFriendlyFilename(string);
            File file = new File(this._appDir, string2 + File.separator + "WEB-INF");
            File[] fileArray = FileUtils.listAllFiles(file, ".tld");
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    arrayList.add(bufferedInputStream);
                }
            }
        }
        catch (Throwable throwable) {
            throw new AppConfigException(throwable);
        }
        return arrayList.iterator();
    }

    public InputStream getClientModuleXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, APP_CLIENT_DD_ENTRY);
    }

    public OutputStream getClientModuleXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, APP_CLIENT_DD_ENTRY);
    }

    public InputStream getClientModuleIASXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, IAS_APP_CLIENT_DD_ENTRY);
    }

    public OutputStream getClientModuleIASXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, IAS_APP_CLIENT_DD_ENTRY);
    }

    public InputStream getRarModuleXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, RAR_DD_ENTRY);
    }

    public OutputStream getRarModuleXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, RAR_DD_ENTRY);
    }

    public InputStream getRarModuleIASXmlFile(String string, String string2) throws AppConfigException {
        return this.getXmlFile(string, string2, IAS_RAR_DD_ENTRY);
    }

    public OutputStream getRarModuleIASXmlOutFile(String string, String string2) throws AppConfigException {
        return this.getXmlOutFile(string, string2, IAS_RAR_DD_ENTRY);
    }

    public InputStream getModuleManifestFile(String string) {
        InputStream inputStream = null;
        String string2 = null;
        try {
            string2 = FileUtils.makeFriendlyFilename(string) + File.separator + MANIFEST_ENTRY;
            inputStream = this.getInputStream(string2, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inputStream;
    }

    public String getAppMainClassName() throws AppConfigException {
        String string = null;
        try {
            InputStream inputStream = this.getAppManifestFile();
            if (inputStream != null) {
                string = AppConfigEnvImpl.getMainClassNameFrom(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
        return string;
    }

    public String getModuleMainClassName(String string) throws AppConfigException {
        String string2 = null;
        try {
            String string3 = FileUtils.makeFriendlyFilename(string);
            InputStream inputStream = this.getModuleManifestFile(string3);
            if (inputStream != null) {
                string2 = AppConfigEnvImpl.getMainClassNameFrom(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
        return string2;
    }

    public void setEjbModulesOnly(boolean bl) {
        this._ejbModulesOnly = bl;
    }

    public boolean isEjbModulesOnly() {
        return this._ejbModulesOnly;
    }

    public void setVerifying(boolean bl) {
        this._verify = bl;
    }

    public boolean isVerifying() {
        return this._verify;
    }

    private InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, true);
    }

    private InputStream getInputStream(String string, boolean bl) throws IOException {
        File file = new File(this._appDir, string);
        BufferedInputStream bufferedInputStream = null;
        if (bl || file.isFile()) {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        return bufferedInputStream;
    }

    private OutputStream getOutputStream(String string) throws IOException {
        File file = new File(this._appDir, string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        return bufferedOutputStream;
    }

    private InputStream getAppManifestFile() {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(MANIFEST_ENTRY, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inputStream;
    }

    private static String getMainClassNameFrom(InputStream inputStream) throws IOException {
        Manifest manifest = new Manifest(inputStream);
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null && attributes.get(Attributes.Name.MAIN_CLASS) != null) {
            return (String)attributes.get(Attributes.Name.MAIN_CLASS);
        }
        String string = localStrings.getString("enterprise.deployment.incorrect_manifest_format");
        throw new IOException(string);
    }

    private InputStream getXmlFile(String string, String string2, String string3) throws AppConfigException {
        InputStream inputStream = null;
        String string4 = null;
        try {
            String string5 = FileUtils.makeFriendlyFilename(string);
            boolean bl = true;
            if (string3.equals(IAS_WEB_DD_ENTRY) || string3.equals(IAS_CMP_MAPPING_DD_ENTRY)) {
                bl = false;
            }
            if (string2 != null) {
                if (string3.indexOf("sun-") >= 0) {
                    File file = new File(string2);
                    String string6 = "sun-" + file.getName();
                    File file2 = new File(file.getParent(), string6);
                    string4 = file2.getPath();
                } else {
                    string4 = string2;
                }
            } else {
                string4 = string5 + File.separator + string3;
            }
            inputStream = this.getInputStream(string4, bl);
        }
        catch (Throwable throwable) {
            File file = new File(this._appDir, string4);
            String string7 = localStrings.getString("enterprise.deployment.error_reading_file", file.getPath());
            throw new AppConfigException(string7, throwable);
        }
        return inputStream;
    }

    private OutputStream getXmlOutFile(String string, String string2, String string3) throws AppConfigException {
        OutputStream outputStream = null;
        String string4 = null;
        try {
            String string5 = FileUtils.makeFriendlyFilename(string);
            if (string2 != null) {
                if (string3.indexOf("sun-") >= 0) {
                    File file = new File(string2);
                    String string6 = "sun-" + file.getName();
                    File file2 = new File(file.getParent(), string6);
                    string4 = file2.getPath();
                } else {
                    string4 = string2;
                }
            } else {
                string4 = string5 + File.separator + string3;
            }
            outputStream = this.getOutputStream(string4);
        }
        catch (Throwable throwable) {
            File file = new File(this._appDir, string4);
            String string7 = localStrings.getString("enterprise.deployment.error_writing_file", file.getPath());
            throw new AppConfigException(string7, throwable);
        }
        return outputStream;
    }
}

