/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.AppConfigEnv;
import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.deployment.DescriptorConstants;
import com.iplanet.ias.deployment.xml.IASApplicationClientRuntimeDescriptorNode;
import com.iplanet.ias.tools.common.dd.appclient.SunApplicationClient;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.netbeans.modules.schema2beans.BaseBean;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class AppClientXmlReader
implements DescriptorConstants {
    public static boolean validateThis = false;
    private static StringManager localStrings = StringManager.getManager(AppClientXmlReader.class);

    public static ApplicationClientDescriptor load(AppConfigEnv appConfigEnv, String string, String string2) throws AppConfigException, IOException {
        InputStream inputStream = appConfigEnv.getClientModuleXmlFile(string, string2);
        ApplicationClientNode applicationClientNode = null;
        try {
            applicationClientNode = ApplicationClientNode.read(inputStream, appConfigEnv.isValidating());
        }
        catch (ParseException parseException) {
            String string3 = localStrings.getString("enterprise.deployment.error_parsing_appclient_dd", parseException.getSAXException().getMessage());
            throw new AppConfigException(string3, parseException);
        }
        inputStream.close();
        ApplicationClientDescriptor applicationClientDescriptor = null;
        try {
            applicationClientDescriptor = applicationClientNode.getDescriptor();
        }
        catch (ContentTransformationException contentTransformationException) {
            String string4 = localStrings.getString("enterprise.deployment.error_converting_appclient_xml", string, contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string4, contentTransformationException);
        }
        ApplicationClientArchivist applicationClientArchivist = new ApplicationClientArchivist(string, applicationClientDescriptor);
        InputStream inputStream2 = appConfigEnv.getModuleManifestFile(string);
        if (inputStream2 != null) {
            applicationClientArchivist.setManifestClasspaths(new Manifest(inputStream2));
            inputStream2.close();
        }
        applicationClientDescriptor.setArchivist(applicationClientArchivist);
        if (string2 != null) {
            try {
                applicationClientDescriptor.setMainClassName(appConfigEnv.getModuleMainClassName(string));
            }
            catch (AppConfigException appConfigException) {
                applicationClientDescriptor.setMainClassName(appConfigEnv.getAppMainClassName());
            }
        } else {
            applicationClientDescriptor.setMainClassName(appConfigEnv.getModuleMainClassName(string));
        }
        InputStream inputStream3 = appConfigEnv.getClientModuleIASXmlFile(string, string2);
        try {
            IASApplicationClientRuntimeDescriptorNode iASApplicationClientRuntimeDescriptorNode = IASApplicationClientRuntimeDescriptorNode.read(inputStream3, appConfigEnv.isValidating());
            iASApplicationClientRuntimeDescriptorNode.updateRuntimeInformation(applicationClientDescriptor);
        }
        catch (ParseException parseException) {
            SAXParseException sAXParseException = (SAXParseException)parseException.getSAXException();
            String string5 = localStrings.getString("enterprise.deployment.error_parsing_sun_appclient_dd", new Integer(sAXParseException.getLineNumber()), sAXParseException.getLocalizedMessage());
            throw new AppConfigException(string5, sAXParseException);
        }
        catch (ContentTransformationException contentTransformationException) {
            String string6 = localStrings.getString("enterprise.deployment.error_converting_sun_appclient_xml", string, contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string6, contentTransformationException);
        }
        inputStream3.close();
        if (appConfigEnv.isVerifying()) {
            applicationClientDescriptor.fillDocType(appConfigEnv.getClientModuleXmlFile(string, string2));
        }
        return applicationClientDescriptor;
    }

    public static ApplicationClientDescriptor load(File file, String string) throws AppConfigException, IOException {
        JarFile jarFile = new JarFile(file);
        ZipEntry zipEntry = jarFile.getEntry("META-INF/application-client.xml");
        if (zipEntry == null) {
            String string2 = localStrings.getString("enterprise.deployment.appclient_entry_missing", "META-INF/application-client.xml", file.getPath());
            throw new AppConfigException(string2);
        }
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        ApplicationClientNode applicationClientNode = null;
        try {
            applicationClientNode = ApplicationClientNode.read(inputStream, validateThis);
        }
        catch (ParseException parseException) {
            String string3 = localStrings.getString("enterprise.deployment.error_parsing_appclient_dd", parseException.getSAXException().getMessage());
            throw new AppConfigException(string3, parseException);
        }
        inputStream.close();
        ApplicationClientDescriptor applicationClientDescriptor = null;
        try {
            applicationClientDescriptor = applicationClientNode.getDescriptor();
        }
        catch (ContentTransformationException contentTransformationException) {
            String string4 = localStrings.getString("enterprise.deployment.error_converting_appclient_xml", file == null ? "" : file.getAbsolutePath(), contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string4, contentTransformationException);
        }
        ApplicationClientArchivist applicationClientArchivist = new ApplicationClientArchivist(string, applicationClientDescriptor);
        applicationClientArchivist.setArchiveCanonicalPath(file.getCanonicalPath());
        applicationClientDescriptor.setArchivist(applicationClientArchivist);
        Manifest manifest = jarFile.getManifest();
        applicationClientArchivist.setManifestClasspaths(manifest);
        applicationClientDescriptor.setMainClassName(AppClientXmlReader.getMainClassName(manifest));
        ZipEntry zipEntry2 = jarFile.getEntry("META-INF/sun-application-client.xml");
        if (zipEntry2 == null) {
            String string5 = localStrings.getString("enterprise.deployment.appclient_entry_missing", "META-INF/sun-application-client.xml", file.getPath());
            throw new AppConfigException(string5);
        }
        InputStream inputStream2 = jarFile.getInputStream(zipEntry2);
        try {
            IASApplicationClientRuntimeDescriptorNode iASApplicationClientRuntimeDescriptorNode = IASApplicationClientRuntimeDescriptorNode.read(inputStream2, validateThis);
            iASApplicationClientRuntimeDescriptorNode.updateRuntimeInformation(applicationClientDescriptor);
        }
        catch (ParseException parseException) {
            SAXParseException sAXParseException = (SAXParseException)parseException.getSAXException();
            String string6 = localStrings.getString("enterprise.deployment.error_parsing_sun_appclient_dd", new Integer(sAXParseException.getLineNumber()), sAXParseException.getLocalizedMessage());
            throw new AppConfigException(string6, sAXParseException);
        }
        catch (ContentTransformationException contentTransformationException) {
            String string7 = localStrings.getString("enterprise.deployment.error_converting_sun_appclient_xml", file == null ? "" : file.getAbsolutePath(), contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string7, contentTransformationException);
        }
        inputStream2.close();
        return applicationClientDescriptor;
    }

    public static ApplicationClientDescriptor load(File file, InputStream inputStream, InputStream inputStream2, String string) throws AppConfigException, IOException {
        JarFile jarFile = new JarFile(file);
        ApplicationClientNode applicationClientNode = null;
        try {
            applicationClientNode = ApplicationClientNode.read(inputStream, false);
        }
        catch (ParseException parseException) {
            String string2 = localStrings.getString("enterprise.deployment.error_parsing_appclient_dd", parseException.getSAXException().getMessage());
            throw new AppConfigException(string2, parseException);
        }
        inputStream.close();
        ApplicationClientDescriptor applicationClientDescriptor = null;
        try {
            applicationClientDescriptor = applicationClientNode.getDescriptor();
        }
        catch (ContentTransformationException contentTransformationException) {
            String string3 = localStrings.getString("enterprise.deployment.error_converting_appclient_xml", file == null ? "" : file.getAbsolutePath(), contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string3, contentTransformationException);
        }
        ApplicationClientArchivist applicationClientArchivist = new ApplicationClientArchivist(string, applicationClientDescriptor);
        applicationClientArchivist.setArchiveCanonicalPath(file.getCanonicalPath());
        applicationClientDescriptor.setArchivist(applicationClientArchivist);
        Manifest manifest = jarFile.getManifest();
        applicationClientArchivist.setManifestClasspaths(manifest);
        applicationClientDescriptor.setMainClassName(AppClientXmlReader.getMainClassName(manifest));
        try {
            IASApplicationClientRuntimeDescriptorNode iASApplicationClientRuntimeDescriptorNode = IASApplicationClientRuntimeDescriptorNode.read(inputStream2, false);
            iASApplicationClientRuntimeDescriptorNode.updateRuntimeInformation(applicationClientDescriptor);
        }
        catch (ParseException parseException) {
            SAXParseException sAXParseException = (SAXParseException)parseException.getSAXException();
            String string4 = localStrings.getString("enterprise.deployment.error_parsing_sun_appclient_dd", new Integer(sAXParseException.getLineNumber()), sAXParseException.getLocalizedMessage());
            throw new AppConfigException(string4, sAXParseException);
        }
        catch (ContentTransformationException contentTransformationException) {
            String string5 = localStrings.getString("enterprise.deployment.error_converting_sun_appclient_xml", file == null ? "" : file.getAbsolutePath(), contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string5, contentTransformationException);
        }
        inputStream2.close();
        return applicationClientDescriptor;
    }

    private static String getMainClassName(Manifest manifest) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null && attributes.get(Attributes.Name.MAIN_CLASS) != null) {
            return (String)attributes.get(Attributes.Name.MAIN_CLASS);
        }
        String string = localStrings.getString("enterprise.deployment.incorrect_manifest_format");
        throw new IOException(string);
    }

    public static ApplicationClientDescriptor open(AppConfigEnv appConfigEnv, String string, String string2) throws AppConfigException, IOException {
        InputStream inputStream = appConfigEnv.getClientModuleXmlFile(string, string2);
        ApplicationClientNode applicationClientNode = null;
        try {
            applicationClientNode = ApplicationClientNode.read(inputStream, appConfigEnv.isValidating());
        }
        catch (ParseException parseException) {
            String string3 = localStrings.getString("enterprise.deployment.error_parsing_appclient_dd", parseException.getSAXException().getMessage());
            throw new AppConfigException(string3, parseException);
        }
        inputStream.close();
        ApplicationClientDescriptor applicationClientDescriptor = null;
        try {
            applicationClientDescriptor = applicationClientNode.getDescriptor();
        }
        catch (ContentTransformationException contentTransformationException) {
            String string4 = localStrings.getString("enterprise.deployment.error_converting_appclient_xml", string, contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string4, contentTransformationException);
        }
        ApplicationClientArchivist applicationClientArchivist = new ApplicationClientArchivist(string, applicationClientDescriptor);
        InputStream inputStream2 = appConfigEnv.getModuleManifestFile(string);
        if (inputStream2 != null) {
            applicationClientArchivist.setManifestClasspaths(new Manifest(inputStream2));
            inputStream2.close();
        }
        applicationClientDescriptor.setArchivist(applicationClientArchivist);
        if (string2 != null) {
            try {
                applicationClientDescriptor.setMainClassName(appConfigEnv.getModuleMainClassName(string));
            }
            catch (AppConfigException appConfigException) {
                applicationClientDescriptor.setMainClassName(appConfigEnv.getAppMainClassName());
            }
        } else {
            applicationClientDescriptor.setMainClassName(appConfigEnv.getModuleMainClassName(string));
        }
        InputStream inputStream3 = appConfigEnv.getClientModuleIASXmlFile(string, string2);
        if (inputStream3 != null) {
            SunApplicationClient sunApplicationClient = AppClientXmlReader.createSunAppClientDescriptorObj(inputStream3, appConfigEnv.isValidating());
            applicationClientDescriptor.setSunDescriptor(sunApplicationClient);
            inputStream3.close();
        }
        return applicationClientDescriptor;
    }

    public static SunApplicationClient createSunAppClientDescriptorObj(InputStream inputStream, boolean bl) throws AppConfigException {
        try {
            XMLValidationHandler xMLValidationHandler = new XMLValidationHandler(bl);
            SunApplicationClient sunApplicationClient = (SunApplicationClient)BaseBean.createGraph((Class)SunApplicationClient.class, (InputStream)inputStream, (boolean)bl, (EntityResolver)xMLValidationHandler, (ErrorHandler)xMLValidationHandler);
            return sunApplicationClient;
        }
        catch (Exception exception) {
            String string = localStrings.getString("enterprise.deployment.error_creating_appclient_xml_graph");
            throw new AppConfigException(string, exception);
        }
    }

    public static ApplicationClientDescriptor load(File file, String string, boolean bl) throws AppConfigException, IOException {
        validateThis = bl;
        return AppClientXmlReader.load(file, string);
    }
}

