/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.corba.ee.internal.iiop;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.types.Gauge;
import com.iplanet.ias.admin.monitor.types.MonitoredAttributeType;
import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.iplanet.ias.util.threadpool.FastThreadPool;
import java.util.Map;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;

public class ThreadPoolMonitor
extends BaseMonitorMBean {
    public static final String THREAD_POOL_SIZE = "thread-pool-size";
    public static final String WAITING_THREAD_COUNT = "waiting-thread-count";
    private FastThreadPool threadPool;
    private Object[][] attrNameTypeArray;
    private Map attrNameTypeMap;
    private MBeanInfo mBeanInfo;

    public ThreadPoolMonitor(FastThreadPool fastThreadPool) {
        this.threadPool = fastThreadPool;
        this.attrNameTypeArray = this.getAttrNameTypeArray();
        this.attrNameTypeMap = ThreadPoolMonitor.createAttrNameTypeMap(this.attrNameTypeArray);
        this.mBeanInfo = ThreadPoolMonitor.createMBeanInfo(this.attrNameTypeMap);
    }

    public void startMonitoring() {
    }

    public void stopMonitoring() {
    }

    protected Object[][] getAttrNameTypeArray() {
        return new Object[][]{{THREAD_POOL_SIZE, new Gauge(Integer.TYPE)}, {WAITING_THREAD_COUNT, new Gauge(Integer.TYPE)}};
    }

    public MonitoredAttributeType getAttributeType(String string) {
        MonitoredAttributeType monitoredAttributeType = null;
        if (this.attrNameTypeMap != null && string != null) {
            monitoredAttributeType = (MonitoredAttributeType)this.attrNameTypeMap.get(string);
        }
        return monitoredAttributeType;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"));
        }
        if (this.threadPool == null) {
            return null;
        }
        if (string.equals(THREAD_POOL_SIZE)) {
            return new Integer(this.threadPool.getPoolSize());
        }
        if (string.equals(WAITING_THREAD_COUNT)) {
            return new Integer(this.threadPool.getWaitCount());
        }
        throw new AttributeNotFoundException("Cannot find " + string + " attribute");
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"));
        }
        if (this.threadPool == null) {
            return null;
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        int[] nArray = this.threadPool.getMonitoredValues();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (stringArray[i].equals(THREAD_POOL_SIZE)) {
                    attributeList.add(new Attribute(stringArray[i], new Integer(nArray[0])));
                    continue;
                }
                if (!stringArray[i].equals(WAITING_THREAD_COUNT)) continue;
                attributeList.add(new Attribute(stringArray[i], new Integer(nArray[1])));
                continue;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{stringArray[i]};
                LogWrap.logger.log(Level.INFO, "iiop.monitored_attribute_failure", objectArray);
                LogWrap.logger.log(Level.INFO, "iiop.monitored_attribute_failure_exception", exception);
            }
        }
        return attributeList;
    }

    public Map getMonitoringMetaData() {
        return this.attrNameTypeMap;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }
}

