/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.corba.ee.internal.iiop;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.types.Gauge;
import com.iplanet.ias.admin.monitor.types.MonitoredAttributeType;
import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.iiop.ConnectionTable;
import java.util.Map;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;

public class ConnectionMonitor
extends BaseMonitorMBean {
    public static final String INBOUND_CONNECTIONS = "total-inbound-connections";
    public static final String OUTBOUND_CONNECTIONS = "total-outbound-connections";
    private ConnectionTable connectionTable;
    private Object[][] attrNameTypeArray;
    private Map attrNameTypeMap;
    private MBeanInfo mBeanInfo;

    public ConnectionMonitor(ConnectionTable connectionTable) {
        this.connectionTable = connectionTable;
        this.attrNameTypeArray = this.getAttrNameTypeArray();
        this.attrNameTypeMap = ConnectionMonitor.createAttrNameTypeMap(this.attrNameTypeArray);
        this.mBeanInfo = ConnectionMonitor.createMBeanInfo(this.attrNameTypeMap);
    }

    public void startMonitoring() {
    }

    public void stopMonitoring() {
    }

    protected Object[][] getAttrNameTypeArray() {
        return new Object[][]{{INBOUND_CONNECTIONS, new Gauge(Integer.TYPE)}, {OUTBOUND_CONNECTIONS, new Gauge(Integer.TYPE)}};
    }

    public MonitoredAttributeType getAttributeType(String string) {
        MonitoredAttributeType monitoredAttributeType = null;
        if (this.attrNameTypeMap != null && string != null) {
            monitoredAttributeType = (MonitoredAttributeType)this.attrNameTypeMap.get(string);
        }
        return monitoredAttributeType;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"));
        }
        if (this.connectionTable == null) {
            return null;
        }
        if (string.equals(INBOUND_CONNECTIONS)) {
            return new Integer(this.connectionTable.getInboundConnectionCount());
        }
        if (string.equals(OUTBOUND_CONNECTIONS)) {
            return new Integer(this.connectionTable.getOutboundConnectionCount());
        }
        throw new AttributeNotFoundException("Cannot find " + string + " attribute");
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"));
        }
        if (this.connectionTable == null) {
            return null;
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        int[] nArray = this.connectionTable.getMonitoredValues();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (stringArray[i].equals(INBOUND_CONNECTIONS)) {
                    attributeList.add(new Attribute(stringArray[i], new Integer(nArray[0])));
                    continue;
                }
                if (!stringArray[i].equals(OUTBOUND_CONNECTIONS)) continue;
                attributeList.add(new Attribute(stringArray[i], new Integer(nArray[1])));
                continue;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{stringArray[i]};
                LogWrap.logger.log(Level.INFO, "iiop.monitored_attribute_failure", objectArray);
                LogWrap.logger.log(Level.INFO, "iiop.monitored_attribute_failure_exception", exception);
            }
        }
        return attributeList;
    }

    public Map getMonitoringMetaData() {
        return this.attrNameTypeMap;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }
}

