/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.connectors.deployment;

import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.ConnectorModule;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.connectors.deployment.IASConnectorDescriptor;
import com.iplanet.ias.connectors.deployment.IASDeploymentException;
import com.iplanet.ias.connectors.deployment.Util;
import com.iplanet.ias.connectors.util.xml.ConnectorDeploymentObject;
import com.iplanet.ias.connectors.util.xml.InstancePropertiesObject;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;

public class IASDeployedObjectsManager {
    private Hashtable rapropTable = new Hashtable();
    private Hashtable instpropTable = new Hashtable();
    private Hashtable jndiNameTable = new Hashtable();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(IASDeployedObjectsManager.class);

    public IASDeployedObjectsManager() throws IASDeploymentException {
    }

    public IASDeployedObjectsManager(String string, String string2) throws NamingException, IASDeploymentException {
        this();
    }

    public Set getRAInstancesList() {
        Set set = this.instpropTable.keySet();
        return set;
    }

    public Set getConnectorsList() {
        Set set = this.rapropTable.keySet();
        return set;
    }

    public InstancePropertiesObject getInstanceProperties(String string) throws IASDeploymentException {
        InstancePropertiesObject instancePropertiesObject = null;
        instancePropertiesObject = (InstancePropertiesObject)this.instpropTable.get(string);
        Map map = instancePropertiesObject.mappedProperties();
        ConnectorDeploymentObject connectorDeploymentObject = null;
        connectorDeploymentObject = this.getRAProperties(instancePropertiesObject.getRaName());
        Map map2 = connectorDeploymentObject.mappedProperties();
        Set set = map2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (map.containsKey(string2)) continue;
            map.put(string2, map2.get(string2));
        }
        return instancePropertiesObject;
    }

    public ConnectorDeploymentObject getRAProperties(String string) throws IASDeploymentException {
        ConnectorDeploymentObject connectorDeploymentObject = null;
        connectorDeploymentObject = (ConnectorDeploymentObject)this.rapropTable.get(string);
        return connectorDeploymentObject;
    }

    public void putRAProperties(String string, ConnectorDeploymentObject connectorDeploymentObject) throws IASDeploymentException {
        this.rapropTable.put(string, connectorDeploymentObject);
    }

    public void putInstanceProperties(String string, InstancePropertiesObject instancePropertiesObject) throws IASDeploymentException {
        this.instpropTable.put(string, instancePropertiesObject);
    }

    public void putJndiName(String string, String string2) throws IASDeploymentException {
        this.jndiNameTable.put(string, string2);
    }

    public String getJndiName(String string) throws IASDeploymentException {
        return (String)this.jndiNameTable.get(string);
    }

    public void removeRAProperties(String string) throws IASDeploymentException {
        ConnectorDeploymentObject connectorDeploymentObject = (ConnectorDeploymentObject)this.rapropTable.remove(string);
    }

    public void removeInstanceProperties(String string) throws IASDeploymentException {
        InstancePropertiesObject instancePropertiesObject = (InstancePropertiesObject)this.instpropTable.remove(string);
    }

    public void removeJndiName(String string) throws IASDeploymentException {
        String string2 = (String)this.jndiNameTable.remove(string);
    }

    public boolean isRAExists(String string) throws IASDeploymentException {
        Set set = this.getConnectorsList();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!string.equalsIgnoreCase((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isInstanceExists(String string) throws IASDeploymentException {
        Set set = this.getRAInstancesList();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!string.equalsIgnoreCase((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public Vector getRAInstancesList(String string) throws IASDeploymentException {
        ConnectorDeploymentObject connectorDeploymentObject = null;
        if (!this.isRAExists(string)) {
            _logger.log(Level.FINE, "Failed to getRAInstancesList,Resource Adapter " + string + " does not exist");
            String string2 = localStrings.getString("connectors.deployment.RA_DOES_NOT_EXIST", string);
            throw new IASDeploymentException(string2);
        }
        connectorDeploymentObject = this.getRAProperties(string);
        Vector vector = connectorDeploymentObject.instanceList();
        return vector;
    }

    public Vector getRAJarsList(String string) throws IASDeploymentException {
        ConnectorDeploymentObject connectorDeploymentObject = null;
        if (!this.isRAExists(string)) {
            _logger.log(Level.FINE, "Failed to getRAInstancesList,Resource Adapter " + string + " does not exist");
            String string2 = localStrings.getString("connectors.deployment.RA_DOES_NOT_EXIST", string);
            throw new IASDeploymentException(string2);
        }
        connectorDeploymentObject = this.getRAProperties(string);
        Vector vector = connectorDeploymentObject.jarList();
        return vector;
    }

    public Vector getRANativesList(String string) throws IASDeploymentException {
        ConnectorDeploymentObject connectorDeploymentObject = null;
        if (!this.isRAExists(string)) {
            _logger.log(Level.FINE, "Failed to getRAInstancesList,Resource Adapter " + string + " does not exist");
            String string2 = localStrings.getString("connectors.deployment.RA_DOES_NOT_EXIST", string);
            throw new IASDeploymentException(string2);
        }
        connectorDeploymentObject = this.getRAProperties(string);
        Vector vector = connectorDeploymentObject.nativeList();
        return vector;
    }

    private Vector castEnum(NamingEnumeration namingEnumeration) {
        Vector<String> vector = new Vector<String>();
        NameClassPair nameClassPair = null;
        while (namingEnumeration.hasMoreElements()) {
            nameClassPair = (NameClassPair)namingEnumeration.nextElement();
            vector.addElement(nameClassPair.getName());
        }
        return vector;
    }

    private ConnectorModule[] getConnectors() throws IASDeploymentException {
        Applications applications = null;
        ServerContext serverContext = ApplicationServer.getServerContext();
        _logger.log(Level.FINE, "Server Context=" + serverContext);
        ConfigContext configContext = serverContext.getConfigContext();
        _logger.log(Level.FINE, "Config Context=" + configContext);
        try {
            applications = (Applications)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_APPLICATIONS);
        }
        catch (ConfigException configException) {
            _logger.log(Level.FINE, "Failed to read appplication from server.xml file ", configException);
            String string = localStrings.getString("connectors.deployment.SHOULD_NOT_HAPPEN");
            throw new IASDeploymentException(string);
        }
        return applications.getConnectorModule();
    }

    private Vector getConnectorJars(String string) {
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        String[] stringArray = file.list();
        String string2 = null;
        _logger.log(Level.FINE, "LEN=" + stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            _logger.log(Level.FINE, "name=" + string2);
            if (!this.isJarFile(string2)) continue;
            vector.add(string + Util.fileseparator + string2);
        }
        return vector;
    }

    private boolean isJarFile(String string) {
        if (string.indexOf(".") > 0) {
            String string2 = string.substring(string.indexOf("."));
            _logger.log(Level.FINE, "in isJarFile:name=" + string + " ends=" + string2);
            String string3 = System.getProperty("os.name");
            if (string3.equals("Windows NT") ? string2.equalsIgnoreCase(".jar") : string.endsWith(".jar")) {
                return true;
            }
        }
        return false;
    }

    private void loadConnectors() throws IASDeploymentException {
        _logger.log(Level.FINE, "******loading connectors");
        String string = null;
        String string2 = null;
        ConnectorModule[] connectorModuleArray = this.getConnectors();
        if (connectorModuleArray != null) {
            for (int i = 0; i < connectorModuleArray.length; ++i) {
                ConnectorModule connectorModule = connectorModuleArray[i];
                if (!connectorModule.isEnabled()) continue;
                _logger.log(Level.FINE, "location=" + connectorModule.getLocation());
                string = connectorModule.getLocation();
                string2 = connectorModule.getName();
                try {
                    this.loadOneConnector(string, string2, null);
                    continue;
                }
                catch (IASDeploymentException iASDeploymentException) {
                    // empty catch block
                }
            }
        }
    }

    public void loadOneConnector(IASConnectorDescriptor iASConnectorDescriptor, ClassLoader classLoader) throws IASDeploymentException {
        _logger.log(Level.FINE, "in loadOneConnector with IASConnectorDescriptor");
        String string = iASConnectorDescriptor.getIASDirectory();
        String string2 = iASConnectorDescriptor.getJndiName();
        ConnectorDeploymentObject connectorDeploymentObject = iASConnectorDescriptor.getConnectorDeploymentObject();
        InstancePropertiesObject instancePropertiesObject = iASConnectorDescriptor.getInstancePropertiesObject();
        this.loadOneConnector(connectorDeploymentObject, instancePropertiesObject, string2, string, classLoader);
    }

    public void loadOneConnector(ConnectorDeploymentObject connectorDeploymentObject, InstancePropertiesObject instancePropertiesObject, String string, String string2, ClassLoader classLoader) throws IASDeploymentException {
        this.putJndiName(instancePropertiesObject.getRaName(), string);
        this.putRAProperties(instancePropertiesObject.getRaName(), connectorDeploymentObject);
        this.putInstanceProperties(string, instancePropertiesObject);
        _logger.log(Level.FINE, "**** after putInstanceProperties");
        ConnectorClassLoader connectorClassLoader = null;
        if (classLoader == null) {
            connectorClassLoader = ConnectorClassLoader.getInstance();
        }
        try {
            if (connectorClassLoader != null) {
                connectorClassLoader.appendURL(new File(string2).toURL());
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "Failed to add file to ConnectorClassLoader " + string2, exception);
            String string3 = localStrings.getString("connectors.deployment.SHOULD_NOT_HAPPEN");
            throw new IASDeploymentException(string3);
        }
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        try {
            _logger.log(Level.FINE, "**** before javax.naming.Reference");
            Reference reference = new Reference(connectorDeploymentObject.getConnectionImplClass(), "com.iplanet.ias.connectors.deployment.IASConnectionFactoryFactory", null);
            _logger.log(Level.FINE, "nm= " + namingManager.toString() + " nm class = " + namingManager.getClass().getName());
            namingManager.publishObject(string, (Object)reference, true);
        }
        catch (NamingException namingException) {
            _logger.log(Level.FINE, "Failed to put ref for " + string, namingException);
            String string4 = localStrings.getString("connectors.deployment.SHOULD_NOT_HAPPEN");
            throw new IASDeploymentException(string4);
        }
        _logger.log(Level.FINE, "***** after put ref");
    }

    public void loadOneConnector(String string, String string2, ClassLoader classLoader) throws IASDeploymentException {
        _logger.log(Level.FINE, "in loadOneConnector " + string + " " + string2);
        IASConnectorDescriptor iASConnectorDescriptor = new IASConnectorDescriptor(string, string2);
        ConnectorDeploymentObject connectorDeploymentObject = iASConnectorDescriptor.getConnectorDeploymentObject();
        InstancePropertiesObject instancePropertiesObject = iASConnectorDescriptor.getInstancePropertiesObject();
        this.loadOneConnector(connectorDeploymentObject, instancePropertiesObject, iASConnectorDescriptor.getJndiName(), string, classLoader);
        _logger.log(Level.FINE, "***** after put ref");
    }

    public void unloadOneConnector(String string, String string2) throws IASDeploymentException {
        String string3 = this.getJndiName(string2);
        this.removeInstance(string3);
        this.removeRAProperties(string2);
        this.removeJndiName(string2);
    }

    private void removeInstance(String string) throws IASDeploymentException {
        this.removeInstanceProperties(string);
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        try {
            namingManager.unpublishObject(string);
        }
        catch (NamingException namingException) {
            _logger.log(Level.FINE, "Failed to remove ref for " + string, namingException);
            String string2 = localStrings.getString("connectors.deployment.SHOULD_NOT_HAPPEN");
            throw new IASDeploymentException(string2);
        }
    }
}

