/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config.serverbeans;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.StaleWriteConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.HttpQos;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.VirtualServer;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class VirtualServerClass
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String VIRTUAL_SERVER = "VirtualServer";
    public static final String HTTP_QOS = "HttpQos";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public VirtualServerClass() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public VirtualServerClass(int n) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("virtual-server", VIRTUAL_SERVER, 66096, VirtualServer.class);
        this.createAttribute(VIRTUAL_SERVER, "id", "Id", 257, null, null);
        this.createAttribute(VIRTUAL_SERVER, "http-listeners", "HttpListeners", 513, null, null);
        this.createAttribute(VIRTUAL_SERVER, "default-web-module", "DefaultWebModule", 513, null, null);
        this.createAttribute(VIRTUAL_SERVER, "config-file", "ConfigFile", 513, null, null);
        this.createAttribute(VIRTUAL_SERVER, "default-object", "DefaultObject", 513, null, null);
        this.createAttribute(VIRTUAL_SERVER, "hosts", "Hosts", 257, null, null);
        this.createAttribute(VIRTUAL_SERVER, "mime", "Mime", 257, null, null);
        this.createAttribute(VIRTUAL_SERVER, "state", "State", 2, new String[]{"on", "off", "disabled"}, "on");
        this.createAttribute(VIRTUAL_SERVER, "acls", "Acls", 513, null, null);
        this.createAttribute(VIRTUAL_SERVER, "accept-language", "AcceptLanguage", 1, null, "false");
        this.createAttribute(VIRTUAL_SERVER, "log-file", "LogFile", 513, null, null);
        this.createProperty("http-qos", HTTP_QOS, 66064, HttpQos.class);
        this.createAttribute(HTTP_QOS, "bandwidth-limit", "BandwidthLimit", 513, null, null);
        this.createAttribute(HTTP_QOS, "enforce-bandwidth-limit", "EnforceBandwidthLimit", 1, null, "false");
        this.createAttribute(HTTP_QOS, "connection-limit", "ConnectionLimit", 513, null, null);
        this.createAttribute(HTTP_QOS, "enforce-connection-limit", "EnforceConnectionLimit", 1, null, "false");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(n);
    }

    void initialize(int n) {
    }

    public void setVirtualServer(int n, VirtualServer virtualServer) {
        this.setValue(VIRTUAL_SERVER, n, virtualServer);
    }

    public VirtualServer getVirtualServer(int n) {
        return (VirtualServer)this.getValue(VIRTUAL_SERVER, n);
    }

    public void setVirtualServer(VirtualServer[] virtualServerArray) {
        this.setValue(VIRTUAL_SERVER, virtualServerArray);
    }

    public VirtualServer[] getVirtualServer() {
        return (VirtualServer[])this.getValues(VIRTUAL_SERVER);
    }

    public int sizeVirtualServer() {
        return this.size(VIRTUAL_SERVER);
    }

    public int addVirtualServer(VirtualServer virtualServer) throws ConfigException {
        return this.addVirtualServer(virtualServer, true);
    }

    public int addVirtualServer(VirtualServer virtualServer, boolean bl) throws ConfigException {
        VirtualServer virtualServer2 = this.getVirtualServerById(virtualServer.getId());
        if (virtualServer2 != null) {
            String string = localStrings.getString("com.iplanet.ias.config.virtual_server");
            throw new ConfigException(string);
        }
        return this.addValue(VIRTUAL_SERVER, virtualServer, bl);
    }

    public int removeVirtualServer(VirtualServer virtualServer) {
        return this.removeValue(VIRTUAL_SERVER, virtualServer);
    }

    public int removeVirtualServer(VirtualServer virtualServer, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(VIRTUAL_SERVER, virtualServer, bl);
    }

    public VirtualServer getVirtualServerById(String string) {
        VirtualServer[] virtualServerArray = this.getVirtualServer();
        if (virtualServerArray == null) {
            return null;
        }
        for (int i = 0; i < virtualServerArray.length; ++i) {
            if (!virtualServerArray[i].getAttributeValue(Common.convertName((String)ServerTags.ID)).equals(string)) continue;
            return virtualServerArray[i];
        }
        return null;
    }

    public void setHttpQos(HttpQos httpQos) {
        this.setValue(HTTP_QOS, httpQos);
    }

    public HttpQos getHttpQos() {
        return (HttpQos)this.getValue(HTTP_QOS);
    }

    public void setElementProperty(int n, ElementProperty elementProperty) {
        this.setValue(ELEMENT_PROPERTY, n, elementProperty);
    }

    public ElementProperty getElementProperty(int n) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, n);
    }

    public void setElementProperty(ElementProperty[] elementPropertyArray) {
        this.setValue(ELEMENT_PROPERTY, elementPropertyArray);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty elementProperty) throws ConfigException {
        return this.addElementProperty(elementProperty, true);
    }

    public int addElementProperty(ElementProperty elementProperty, boolean bl) throws ConfigException {
        ElementProperty elementProperty2 = this.getElementPropertyByName(elementProperty.getName());
        if (elementProperty2 != null) {
            String string = localStrings.getString("com.iplanet.ias.config.element_property");
            throw new ConfigException(string);
        }
        return this.addValue(ELEMENT_PROPERTY, elementProperty, bl);
    }

    public int removeElementProperty(ElementProperty elementProperty) {
        return this.removeValue(ELEMENT_PROPERTY, elementProperty);
    }

    public int removeElementProperty(ElementProperty elementProperty, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, elementProperty, bl);
    }

    public ElementProperty getElementPropertyByName(String string) {
        ElementProperty[] elementPropertyArray = this.getElementProperty();
        if (elementPropertyArray == null) {
            return null;
        }
        for (int i = 0; i < elementPropertyArray.length; ++i) {
            if (!elementPropertyArray[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(string)) continue;
            return elementPropertyArray[i];
        }
        return null;
    }

    public String getId() {
        return this.getAttributeValue(ServerTags.ID);
    }

    public void setId(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ID, string, bl);
    }

    public void setId(String string) {
        this.setAttributeValue(ServerTags.ID, string);
    }

    public String getConfigFile() {
        return this.getAttributeValue(ServerTags.CONFIG_FILE);
    }

    public void setConfigFile(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.CONFIG_FILE, string, bl);
    }

    public void setConfigFile(String string) {
        this.setAttributeValue(ServerTags.CONFIG_FILE, string);
    }

    public String getDefaultObject() {
        return this.getAttributeValue(ServerTags.DEFAULT_OBJECT);
    }

    public void setDefaultObject(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DEFAULT_OBJECT, string, bl);
    }

    public void setDefaultObject(String string) {
        this.setAttributeValue(ServerTags.DEFAULT_OBJECT, string);
    }

    public boolean isAcceptLanguage() {
        return VirtualServerClass.toBoolean(this.getAttributeValue(ServerTags.ACCEPT_LANGUAGE));
    }

    public void setAcceptLanguage(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ACCEPT_LANGUAGE, "" + bl, bl2);
    }

    public void setAcceptLanguage(boolean bl) {
        this.setAttributeValue(ServerTags.ACCEPT_LANGUAGE, "" + bl);
    }

    public boolean isEnabled() {
        return VirtualServerClass.toBoolean(this.getAttributeValue(ServerTags.ENABLED));
    }

    public void setEnabled(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ENABLED, "" + bl, bl2);
    }

    public void setEnabled(boolean bl) {
        this.setAttributeValue(ServerTags.ENABLED, "" + bl);
    }

    protected String getRelativeXPath() {
        String string = null;
        string = "virtual-server-class[@id='" + this.getAttributeValue("id") + "']";
        return string;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator beanComparator) {
        comparators.add(beanComparator);
    }

    public static void removeComparator(BeanComparator beanComparator) {
        comparators.remove(beanComparator);
    }

    public static String getDefaultAttributeValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(ServerTags.DEFAULT_OBJECT)) {
            return "default";
        }
        if (string.equals(ServerTags.ACCEPT_LANGUAGE)) {
            return "false";
        }
        if (string.equals(ServerTags.ENABLED)) {
            return "true";
        }
        return null;
    }

    public static String getDefaultDefaultObject() {
        return "default";
    }

    public static String getDefaultAcceptLanguage() {
        return "false";
    }

    public static String getDefaultEnabled() {
        return "true";
    }

    public void dump(StringBuffer stringBuffer, String string) {
        ConfigBean configBean;
        int n;
        stringBuffer.append(string);
        stringBuffer.append("VirtualServer[" + this.sizeVirtualServer() + "]");
        for (n = 0; n < this.sizeVirtualServer(); ++n) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + n + ":");
            configBean = this.getVirtualServer(n);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(VIRTUAL_SERVER, n, stringBuffer, string);
        }
        stringBuffer.append(string);
        stringBuffer.append(HTTP_QOS);
        configBean = this.getHttpQos();
        if (configBean != null) {
            configBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(HTTP_QOS, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (n = 0; n < this.sizeElementProperty(); ++n) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + n + ":");
            configBean = this.getElementProperty(n);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, n, stringBuffer, string);
        }
    }

    public String dumpBeanNode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VirtualServerClass\n");
        this.dump(stringBuffer, "\n  ");
        return stringBuffer.toString();
    }
}

