/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config.serverbeans;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.StaleWriteConfigException;
import com.iplanet.ias.config.serverbeans.AuthDb;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.HttpQos;
import com.iplanet.ias.config.serverbeans.ServerTags;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class VirtualServer
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String HTTP_QOS = "HttpQos";
    public static final String AUTH_DB = "AuthDb";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public VirtualServer() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public VirtualServer(int n) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("http-qos", HTTP_QOS, 66064, HttpQos.class);
        this.createAttribute(HTTP_QOS, "bandwidth-limit", "BandwidthLimit", 513, null, null);
        this.createAttribute(HTTP_QOS, "enforce-bandwidth-limit", "EnforceBandwidthLimit", 1, null, "false");
        this.createAttribute(HTTP_QOS, "connection-limit", "ConnectionLimit", 513, null, null);
        this.createAttribute(HTTP_QOS, "enforce-connection-limit", "EnforceConnectionLimit", 1, null, "false");
        this.createProperty("auth-db", AUTH_DB, 66096, AuthDb.class);
        this.createAttribute(AUTH_DB, "id", "Id", 257, null, null);
        this.createAttribute(AUTH_DB, "database", "Database", 257, null, null);
        this.createAttribute(AUTH_DB, "basedn", "Basedn", 513, null, null);
        this.createAttribute(AUTH_DB, "certmaps", "Certmaps", 513, null, null);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(n);
    }

    void initialize(int n) {
    }

    public void setHttpQos(HttpQos httpQos) {
        this.setValue(HTTP_QOS, httpQos);
    }

    public HttpQos getHttpQos() {
        return (HttpQos)this.getValue(HTTP_QOS);
    }

    public void setAuthDb(int n, AuthDb authDb) {
        this.setValue(AUTH_DB, n, authDb);
    }

    public AuthDb getAuthDb(int n) {
        return (AuthDb)this.getValue(AUTH_DB, n);
    }

    public void setAuthDb(AuthDb[] authDbArray) {
        this.setValue(AUTH_DB, authDbArray);
    }

    public AuthDb[] getAuthDb() {
        return (AuthDb[])this.getValues(AUTH_DB);
    }

    public int sizeAuthDb() {
        return this.size(AUTH_DB);
    }

    public int addAuthDb(AuthDb authDb) throws ConfigException {
        return this.addAuthDb(authDb, true);
    }

    public int addAuthDb(AuthDb authDb, boolean bl) throws ConfigException {
        AuthDb authDb2 = this.getAuthDbById(authDb.getId());
        if (authDb2 != null) {
            String string = localStrings.getString("com.iplanet.ias.config.auth_db");
            throw new ConfigException(string);
        }
        return this.addValue(AUTH_DB, authDb, bl);
    }

    public int removeAuthDb(AuthDb authDb) {
        return this.removeValue(AUTH_DB, authDb);
    }

    public int removeAuthDb(AuthDb authDb, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(AUTH_DB, authDb, bl);
    }

    public AuthDb getAuthDbById(String string) {
        AuthDb[] authDbArray = this.getAuthDb();
        if (authDbArray == null) {
            return null;
        }
        for (int i = 0; i < authDbArray.length; ++i) {
            if (!authDbArray[i].getAttributeValue(Common.convertName((String)ServerTags.ID)).equals(string)) continue;
            return authDbArray[i];
        }
        return null;
    }

    public void setElementProperty(int n, ElementProperty elementProperty) {
        this.setValue(ELEMENT_PROPERTY, n, elementProperty);
    }

    public ElementProperty getElementProperty(int n) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, n);
    }

    public void setElementProperty(ElementProperty[] elementPropertyArray) {
        this.setValue(ELEMENT_PROPERTY, elementPropertyArray);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty elementProperty) throws ConfigException {
        return this.addElementProperty(elementProperty, true);
    }

    public int addElementProperty(ElementProperty elementProperty, boolean bl) throws ConfigException {
        ElementProperty elementProperty2 = this.getElementPropertyByName(elementProperty.getName());
        if (elementProperty2 != null) {
            String string = localStrings.getString("com.iplanet.ias.config.element_property");
            throw new ConfigException(string);
        }
        return this.addValue(ELEMENT_PROPERTY, elementProperty, bl);
    }

    public int removeElementProperty(ElementProperty elementProperty) {
        return this.removeValue(ELEMENT_PROPERTY, elementProperty);
    }

    public int removeElementProperty(ElementProperty elementProperty, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, elementProperty, bl);
    }

    public ElementProperty getElementPropertyByName(String string) {
        ElementProperty[] elementPropertyArray = this.getElementProperty();
        if (elementPropertyArray == null) {
            return null;
        }
        for (int i = 0; i < elementPropertyArray.length; ++i) {
            if (!elementPropertyArray[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(string)) continue;
            return elementPropertyArray[i];
        }
        return null;
    }

    public String getId() {
        return this.getAttributeValue(ServerTags.ID);
    }

    public void setId(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ID, string, bl);
    }

    public void setId(String string) {
        this.setAttributeValue(ServerTags.ID, string);
    }

    public String getHttpListeners() {
        return this.getAttributeValue(ServerTags.HTTP_LISTENERS);
    }

    public void setHttpListeners(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.HTTP_LISTENERS, string, bl);
    }

    public void setHttpListeners(String string) {
        this.setAttributeValue(ServerTags.HTTP_LISTENERS, string);
    }

    public String getDefaultWebModule() {
        return this.getAttributeValue(ServerTags.DEFAULT_WEB_MODULE);
    }

    public void setDefaultWebModule(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DEFAULT_WEB_MODULE, string, bl);
    }

    public void setDefaultWebModule(String string) {
        this.setAttributeValue(ServerTags.DEFAULT_WEB_MODULE, string);
    }

    public String getConfigFile() {
        return this.getAttributeValue(ServerTags.CONFIG_FILE);
    }

    public void setConfigFile(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.CONFIG_FILE, string, bl);
    }

    public void setConfigFile(String string) {
        this.setAttributeValue(ServerTags.CONFIG_FILE, string);
    }

    public String getDefaultObject() {
        return this.getAttributeValue(ServerTags.DEFAULT_OBJECT);
    }

    public void setDefaultObject(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DEFAULT_OBJECT, string, bl);
    }

    public void setDefaultObject(String string) {
        this.setAttributeValue(ServerTags.DEFAULT_OBJECT, string);
    }

    public String getHosts() {
        return this.getAttributeValue(ServerTags.HOSTS);
    }

    public void setHosts(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.HOSTS, string, bl);
    }

    public void setHosts(String string) {
        this.setAttributeValue(ServerTags.HOSTS, string);
    }

    public String getMime() {
        return this.getAttributeValue(ServerTags.MIME);
    }

    public void setMime(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.MIME, string, bl);
    }

    public void setMime(String string) {
        this.setAttributeValue(ServerTags.MIME, string);
    }

    public String getState() {
        return this.getAttributeValue(ServerTags.STATE);
    }

    public void setState(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.STATE, string, bl);
    }

    public void setState(String string) {
        this.setAttributeValue(ServerTags.STATE, string);
    }

    public String getAcls() {
        return this.getAttributeValue(ServerTags.ACLS);
    }

    public void setAcls(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ACLS, string, bl);
    }

    public void setAcls(String string) {
        this.setAttributeValue(ServerTags.ACLS, string);
    }

    public boolean isAcceptLanguage() {
        return VirtualServer.toBoolean(this.getAttributeValue(ServerTags.ACCEPT_LANGUAGE));
    }

    public void setAcceptLanguage(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ACCEPT_LANGUAGE, "" + bl, bl2);
    }

    public void setAcceptLanguage(boolean bl) {
        this.setAttributeValue(ServerTags.ACCEPT_LANGUAGE, "" + bl);
    }

    public String getLogFile() {
        return this.getAttributeValue(ServerTags.LOG_FILE);
    }

    public void setLogFile(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.LOG_FILE, string, bl);
    }

    public void setLogFile(String string) {
        this.setAttributeValue(ServerTags.LOG_FILE, string);
    }

    protected String getRelativeXPath() {
        String string = null;
        string = "virtual-server[@id='" + this.getAttributeValue("id") + "']";
        return string;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator beanComparator) {
        comparators.add(beanComparator);
    }

    public static void removeComparator(BeanComparator beanComparator) {
        comparators.remove(beanComparator);
    }

    public static String getDefaultAttributeValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(ServerTags.STATE)) {
            return "on";
        }
        if (string.equals(ServerTags.ACCEPT_LANGUAGE)) {
            return "false";
        }
        return null;
    }

    public static String getDefaultState() {
        return "on";
    }

    public static String getDefaultAcceptLanguage() {
        return "false";
    }

    public void dump(StringBuffer stringBuffer, String string) {
        int n;
        stringBuffer.append(string);
        stringBuffer.append(HTTP_QOS);
        ConfigBean configBean = this.getHttpQos();
        if (configBean != null) {
            configBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(HTTP_QOS, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append("AuthDb[" + this.sizeAuthDb() + "]");
        for (n = 0; n < this.sizeAuthDb(); ++n) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + n + ":");
            configBean = this.getAuthDb(n);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(AUTH_DB, n, stringBuffer, string);
        }
        stringBuffer.append(string);
        stringBuffer.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (n = 0; n < this.sizeElementProperty(); ++n) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + n + ":");
            configBean = this.getElementProperty(n);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, n, stringBuffer, string);
        }
    }

    public String dumpBeanNode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VirtualServer\n");
        this.dump(stringBuffer, "\n  ");
        return stringBuffer.toString();
    }
}

