/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config.serverbeans;

import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerXPathHelper {
    public static final String XPATH_SEPARATOR = "/";
    public static final String XPATH_SERVER = "/" + ServerTags.SERVER;
    public static final String XPATH_APPLICATIONS = XPATH_SERVER + "/" + ServerTags.APPLICATIONS;
    public static final String XPATH_J2EE_APPLICATION = XPATH_APPLICATIONS + "/" + ServerTags.J2EE_APPLICATION;
    public static final String XPATH_EJB_MODULE = XPATH_APPLICATIONS + "/" + ServerTags.EJB_MODULE;
    public static final String XPATH_WEB_MODULE = XPATH_APPLICATIONS + "/" + ServerTags.WEB_MODULE;
    public static final String XPATH_CONNECTOR_MODULE = XPATH_APPLICATIONS + "/" + ServerTags.CONNECTOR_MODULE;
    public static final String XPATH_LIFECYCLE_MODULE = XPATH_APPLICATIONS + "/" + ServerTags.LIFECYCLE_MODULE;
    public static final String XPATH_LOG_SERVICE = XPATH_SERVER + "/" + ServerTags.LOG_SERVICE;
    public static final String XPATH_SECURITY_SERVICE = XPATH_SERVER + "/" + ServerTags.SECURITY_SERVICE;
    public static final String XPATH_SECURITY_AUTH_REALM = XPATH_SECURITY_SERVICE + "/" + ServerTags.AUTH_REALM;
    public static final String XPATH_RESOURCES = XPATH_SERVER + "/" + ServerTags.RESOURCES;
    public static final String XPATH_JDBC_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.JDBC_RESOURCE;
    public static final String XPATH_JMS_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.JMS_RESOURCE;
    public static final String XPATH_JNDI_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.EXTERNAL_JNDI_RESOURCE;
    public static final String XPATH_CUSTOM_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.CUSTOM_RESOURCE;
    public static final String XPATH_JDBC_CONNECTION_POOL = XPATH_RESOURCES + "/" + ServerTags.JDBC_CONNECTION_POOL;
    public static final String XPATH_PM_FACTORY_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.PERSISTENCE_MANAGER_FACTORY_RESOURCE;
    public static final String XPATH_MAIL_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.MAIL_RESOURCE;
    public static final String XPATH_HTTP_SERVICE = XPATH_SERVER + "/" + ServerTags.HTTP_SERVICE;
    public static final String XPATH_HTTP_LISTENER = XPATH_HTTP_SERVICE + "/" + ServerTags.HTTP_LISTENER;
    public static final String XPATH_HTTP_ACL = XPATH_HTTP_SERVICE + "/" + ServerTags.ACL;
    public static final String XPATH_HTTP_MIME = XPATH_HTTP_SERVICE + "/" + ServerTags.MIME;
    public static final String XPATH_TRANSACTION_SERVICE = XPATH_SERVER + "/" + ServerTags.TRANSACTION_SERVICE;
    public static final String XPATH_JMS_SERVICE = XPATH_SERVER + "/" + ServerTags.JMS_SERVICE;
    public static final String XPATH_VIRTUAL_SERVER_CLASS = XPATH_HTTP_SERVICE + "/" + ServerTags.VIRTUAL_SERVER_CLASS;
    public static final String XPATH_IIOP_SERVICE = XPATH_SERVER + "/" + ServerTags.IIOP_SERVICE;
    public static final String XPATH_ORB = XPATH_IIOP_SERVICE + "/" + ServerTags.ORB;
    public static final String XPATH_IIOP_LISTENER = XPATH_IIOP_SERVICE + "/" + ServerTags.IIOP_LISTENER;
    public static final String XPATH_MDB_CONTAINER = XPATH_SERVER + "/" + ServerTags.MDB_CONTAINER;
    public static final String XPATH_WEB_CONTAINER = XPATH_SERVER + "/" + ServerTags.WEB_CONTAINER;
    public static final String XPATH_EJB_CONTAINER = XPATH_SERVER + "/" + ServerTags.EJB_CONTAINER;
    public static final String XPATH_JAVACONFIG = XPATH_SERVER + "/" + ServerTags.JAVA_CONFIG;
    public static final String XPATH_PROFILER = XPATH_JAVACONFIG + "/" + ServerTags.PROFILER;
    public static final String XPATH_AVAILABILITY_SERVICE = XPATH_SERVER + "/" + ServerTags.AVAILABILITY_SERVICE;
    public static final String XPATH_PERSISTENCE_STORE = XPATH_AVAILABILITY_SERVICE + "/" + ServerTags.PERSISTENCE_STORE;
    public static final String XPATH_IIOP_CLUSTER = XPATH_AVAILABILITY_SERVICE + "/" + ServerTags.IIOP_CLUSTER;
    public static final String XPATH_IIOP_SERVER_INSTANCE = XPATH_IIOP_CLUSTER + "/" + ServerTags.IIOP_SERVER_INSTANCE;
    public static final String XPATH_IIOP_ENDPOINT = XPATH_IIOP_SERVER_INSTANCE + "/" + ServerTags.IIOP_ENDPOINT;
    public static final String XPATH_SESSION_CONFIG = XPATH_WEB_CONTAINER + "/" + ServerTags.SESSION_CONFIG;
    public static final String XPATH_SESSION_MANAGER = XPATH_SESSION_CONFIG + "/" + ServerTags.SESSION_MANAGER;
    public static final String XPATH_SESSION_PROPERTIES = XPATH_SESSION_CONFIG + "/" + ServerTags.SESSION_PROPERTIES;
    public static final String XPATH_MANAGER_PROPERTIES = XPATH_SESSION_MANAGER + "/" + ServerTags.MANAGER_PROPERTIES;
    public static final String XPATH_STORE_PROPERTIES = XPATH_SESSION_MANAGER + "/" + ServerTags.STORE_PROPERTIES;
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.config");
    private static char SEPARATOR_CHAR = (char)47;
    private static char OPENBRACKET_CHAR = (char)91;
    private static char CLOSEBRACKET_CHAR = (char)93;
    private static char ESCAPE_CHAR = (char)92;

    public static NodeList processXPath(Node node, String string) throws SAXException {
        NodeList nodeList = null;
        try {
            nodeList = XPathAPI.selectNodeList((Node)node, (String)string);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "config.select_nodelist_exception", exception);
        }
        return nodeList;
    }

    public static String getAppIdXpathExpression(String string) {
        return XPATH_J2EE_APPLICATION + "[@" + ServerTags.NAME + "='" + string + "']";
    }

    public static String getEjbModuleIdXpathExpression(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_EJB_MODULE, ServerTags.NAME, string);
    }

    public static String getWebModuleIdXpathExpression(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_WEB_MODULE, ServerTags.NAME, string);
    }

    public static String getConnectorModuleIdXpathExpression(String string) {
        return XPATH_CONNECTOR_MODULE + "[@" + ServerTags.NAME + "='" + string + "']";
    }

    public static String getLifecycleModuleIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_LIFECYCLE_MODULE, ServerTags.NAME, string);
    }

    public static String getJDBCResourceIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JDBC_RESOURCE, ServerTags.JNDI_NAME, string);
    }

    public static String getJMSResourceIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JMS_RESOURCE, ServerTags.JNDI_NAME, string);
    }

    public static String getJNDIResourceIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JNDI_RESOURCE, ServerTags.JNDI_NAME, string);
    }

    public static String getMailResourceIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_MAIL_RESOURCE, ServerTags.JNDI_NAME, string);
    }

    public static String getCustomResourceIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_CUSTOM_RESOURCE, ServerTags.JNDI_NAME, string);
    }

    public static String getJDBCConnectionPoolIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JDBC_CONNECTION_POOL, ServerTags.NAME, string);
    }

    public static String getPMFactoryResourceIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_PM_FACTORY_RESOURCE, ServerTags.JNDI_NAME, string);
    }

    public static String getMDBContainerXpath() {
        return XPATH_MDB_CONTAINER;
    }

    public static String getWEBContainerXpath() {
        return XPATH_WEB_CONTAINER;
    }

    public static String getEJBContainerXpath() {
        return XPATH_EJB_CONTAINER;
    }

    public static String getAvailabilityServiceXpath() {
        return XPATH_AVAILABILITY_SERVICE;
    }

    public static String getPersistenceStoreXpath() {
        return XPATH_PERSISTENCE_STORE;
    }

    public static String getIiopClusterXpath() {
        return XPATH_IIOP_CLUSTER;
    }

    public static String getIiopServerInstanceXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_IIOP_SERVER_INSTANCE, ServerTags.NAME, string);
    }

    public static String getIiopEndpointXpath(String string, String string2) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(ServerXPathHelper.getIiopServerInstanceXpath(string) + XPATH_SEPARATOR + ServerTags.IIOP_ENDPOINT, ServerTags.ID, string2);
    }

    public static String getTransactionServiceXpath() {
        return XPATH_TRANSACTION_SERVICE;
    }

    public static String getJmsServiceXpath() {
        return XPATH_JMS_SERVICE;
    }

    public static String getHTTPServiceXpath() {
        return XPATH_HTTP_SERVICE;
    }

    public static String getHTTPListenerIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_HTTP_LISTENER, ServerTags.ID, string);
    }

    public static String getHTTPMimeIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_HTTP_MIME, ServerTags.ID, string);
    }

    public static String getHTTPAclIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_HTTP_ACL, ServerTags.ID, string);
    }

    public static String getVirtualServerClassIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_VIRTUAL_SERVER_CLASS, ServerTags.ID, string);
    }

    public static String getVirtualServerIdXpath(String string, String string2) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(ServerXPathHelper.getVirtualServerClassIdXpath(string) + XPATH_SEPARATOR + ServerTags.VIRTUAL_SERVER, ServerTags.ID, string2);
    }

    public static String getAuthDbIdXpath(String string, String string2, String string3) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(ServerXPathHelper.getVirtualServerIdXpath(string, string2) + XPATH_SEPARATOR + ServerTags.AUTH_DB, ServerTags.ID, string3);
    }

    public static String getIIOPServiceXpath() {
        return XPATH_IIOP_SERVICE;
    }

    public static String getOrbXpath() {
        return XPATH_ORB;
    }

    public static String getIIOPListenerIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_IIOP_LISTENER, ServerTags.ID, string);
    }

    public static String getLogServiceXpath() {
        return XPATH_LOG_SERVICE;
    }

    public static String getSecurityServiceXpath() {
        return XPATH_SECURITY_SERVICE;
    }

    public static String getSecurityAuthRealmIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_SECURITY_AUTH_REALM, ServerTags.NAME, string);
    }

    public static String getJavaConfigXpath() {
        return XPATH_JAVACONFIG;
    }

    public static String getProfilerXpath() {
        return XPATH_PROFILER;
    }

    public static String getSessionManagerXpath() {
        return XPATH_SESSION_MANAGER;
    }

    public static String getSessionPropertiesXpath() {
        return XPATH_SESSION_PROPERTIES;
    }

    public static String getManagerPropertiesXpath() {
        return XPATH_MANAGER_PROPERTIES;
    }

    public static String getStorePropertiesXpath() {
        return XPATH_STORE_PROPERTIES;
    }

    public static String getAbsoluteIdXpathExpression(String string, String string2, String string3) {
        return XPATH_SEPARATOR + string + "[@" + string2 + "='" + string3 + "']";
    }

    public static String getLastNodeName(String string) {
        char c;
        int n = string.length() - 1;
        int n2 = -1;
        if (n >= 0 && (c = string.charAt(n)) == CLOSEBRACKET_CHAR) {
            --n;
            n = n2 = ServerXPathHelper.bypassBrackets(string, n);
        }
        while (n >= 0 && ((c = string.charAt(n)) != SEPARATOR_CHAR || ServerXPathHelper.isEscapedChar(string, n))) {
            --n;
        }
        ++n;
        if (n2 <= 0 || n2 == string.length() - 1) {
            return string.substring(n);
        }
        return string.substring(n, n2 + 1);
    }

    private static int bypassBrackets(String string, int n) {
        char c;
        while (n >= 0 && ((c = string.charAt(n)) != OPENBRACKET_CHAR || ServerXPathHelper.isEscapedChar(string, n))) {
            --n;
        }
        return n - 1;
    }

    private static boolean isEscapedChar(String string, int n) {
        if (n <= 0) {
            return false;
        }
        int n2 = 0;
        while (--n >= 0 && string.charAt(n) == ESCAPE_CHAR) {
            ++n2;
        }
        return n2 % 2 == 1;
    }
}

