/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config.serverbeans;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.StaleWriteConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.ServerTags;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class JdbcConnectionPool
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String DESCRIPTION = "Description";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public JdbcConnectionPool() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public JdbcConnectionPool(int n) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("description", DESCRIPTION, 65808, String.class);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(n);
    }

    void initialize(int n) {
    }

    public String getDescription() {
        return (String)this.getValue(ServerTags.DESCRIPTION);
    }

    public void setDescription(String string) {
        this.setValue(ServerTags.DESCRIPTION, string);
    }

    public void setElementProperty(int n, ElementProperty elementProperty) {
        this.setValue(ELEMENT_PROPERTY, n, elementProperty);
    }

    public ElementProperty getElementProperty(int n) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, n);
    }

    public void setElementProperty(ElementProperty[] elementPropertyArray) {
        this.setValue(ELEMENT_PROPERTY, elementPropertyArray);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty elementProperty) throws ConfigException {
        return this.addElementProperty(elementProperty, true);
    }

    public int addElementProperty(ElementProperty elementProperty, boolean bl) throws ConfigException {
        ElementProperty elementProperty2 = this.getElementPropertyByName(elementProperty.getName());
        if (elementProperty2 != null) {
            String string = localStrings.getString("com.iplanet.ias.config.element_property");
            throw new ConfigException(string);
        }
        return this.addValue(ELEMENT_PROPERTY, elementProperty, bl);
    }

    public int removeElementProperty(ElementProperty elementProperty) {
        return this.removeValue(ELEMENT_PROPERTY, elementProperty);
    }

    public int removeElementProperty(ElementProperty elementProperty, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, elementProperty, bl);
    }

    public ElementProperty getElementPropertyByName(String string) {
        ElementProperty[] elementPropertyArray = this.getElementProperty();
        if (elementPropertyArray == null) {
            return null;
        }
        for (int i = 0; i < elementPropertyArray.length; ++i) {
            if (!elementPropertyArray[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(string)) continue;
            return elementPropertyArray[i];
        }
        return null;
    }

    public String getName() {
        return this.getAttributeValue(ServerTags.NAME);
    }

    public void setName(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.NAME, string, bl);
    }

    public void setName(String string) {
        this.setAttributeValue(ServerTags.NAME, string);
    }

    public String getDatasourceClassname() {
        return this.getAttributeValue(ServerTags.DATASOURCE_CLASSNAME);
    }

    public void setDatasourceClassname(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DATASOURCE_CLASSNAME, string, bl);
    }

    public void setDatasourceClassname(String string) {
        this.setAttributeValue(ServerTags.DATASOURCE_CLASSNAME, string);
    }

    public String getResType() {
        return this.getAttributeValue(ServerTags.RES_TYPE);
    }

    public void setResType(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.RES_TYPE, string, bl);
    }

    public void setResType(String string) {
        this.setAttributeValue(ServerTags.RES_TYPE, string);
    }

    public String getSteadyPoolSize() {
        return this.getAttributeValue(ServerTags.STEADY_POOL_SIZE);
    }

    public void setSteadyPoolSize(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.STEADY_POOL_SIZE, string, bl);
    }

    public void setSteadyPoolSize(String string) {
        this.setAttributeValue(ServerTags.STEADY_POOL_SIZE, string);
    }

    public String getMaxPoolSize() {
        return this.getAttributeValue(ServerTags.MAX_POOL_SIZE);
    }

    public void setMaxPoolSize(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.MAX_POOL_SIZE, string, bl);
    }

    public void setMaxPoolSize(String string) {
        this.setAttributeValue(ServerTags.MAX_POOL_SIZE, string);
    }

    public String getMaxWaitTimeInMillis() {
        return this.getAttributeValue(ServerTags.MAX_WAIT_TIME_IN_MILLIS);
    }

    public void setMaxWaitTimeInMillis(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.MAX_WAIT_TIME_IN_MILLIS, string, bl);
    }

    public void setMaxWaitTimeInMillis(String string) {
        this.setAttributeValue(ServerTags.MAX_WAIT_TIME_IN_MILLIS, string);
    }

    public String getPoolResizeQuantity() {
        return this.getAttributeValue(ServerTags.POOL_RESIZE_QUANTITY);
    }

    public void setPoolResizeQuantity(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.POOL_RESIZE_QUANTITY, string, bl);
    }

    public void setPoolResizeQuantity(String string) {
        this.setAttributeValue(ServerTags.POOL_RESIZE_QUANTITY, string);
    }

    public String getIdleTimeoutInSeconds() {
        return this.getAttributeValue(ServerTags.IDLE_TIMEOUT_IN_SECONDS);
    }

    public void setIdleTimeoutInSeconds(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.IDLE_TIMEOUT_IN_SECONDS, string, bl);
    }

    public void setIdleTimeoutInSeconds(String string) {
        this.setAttributeValue(ServerTags.IDLE_TIMEOUT_IN_SECONDS, string);
    }

    public String getTransactionIsolationLevel() {
        return this.getAttributeValue(ServerTags.TRANSACTION_ISOLATION_LEVEL);
    }

    public void setTransactionIsolationLevel(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.TRANSACTION_ISOLATION_LEVEL, string, bl);
    }

    public void setTransactionIsolationLevel(String string) {
        this.setAttributeValue(ServerTags.TRANSACTION_ISOLATION_LEVEL, string);
    }

    public boolean isIsIsolationLevelGuaranteed() {
        return JdbcConnectionPool.toBoolean(this.getAttributeValue(ServerTags.IS_ISOLATION_LEVEL_GUARANTEED));
    }

    public void setIsIsolationLevelGuaranteed(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.IS_ISOLATION_LEVEL_GUARANTEED, "" + bl, bl2);
    }

    public void setIsIsolationLevelGuaranteed(boolean bl) {
        this.setAttributeValue(ServerTags.IS_ISOLATION_LEVEL_GUARANTEED, "" + bl);
    }

    public boolean isIsConnectionValidationRequired() {
        return JdbcConnectionPool.toBoolean(this.getAttributeValue(ServerTags.IS_CONNECTION_VALIDATION_REQUIRED));
    }

    public void setIsConnectionValidationRequired(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.IS_CONNECTION_VALIDATION_REQUIRED, "" + bl, bl2);
    }

    public void setIsConnectionValidationRequired(boolean bl) {
        this.setAttributeValue(ServerTags.IS_CONNECTION_VALIDATION_REQUIRED, "" + bl);
    }

    public String getConnectionValidationMethod() {
        return this.getAttributeValue(ServerTags.CONNECTION_VALIDATION_METHOD);
    }

    public void setConnectionValidationMethod(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.CONNECTION_VALIDATION_METHOD, string, bl);
    }

    public void setConnectionValidationMethod(String string) {
        this.setAttributeValue(ServerTags.CONNECTION_VALIDATION_METHOD, string);
    }

    public String getValidationTableName() {
        return this.getAttributeValue(ServerTags.VALIDATION_TABLE_NAME);
    }

    public void setValidationTableName(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.VALIDATION_TABLE_NAME, string, bl);
    }

    public void setValidationTableName(String string) {
        this.setAttributeValue(ServerTags.VALIDATION_TABLE_NAME, string);
    }

    public boolean isFailAllConnections() {
        return JdbcConnectionPool.toBoolean(this.getAttributeValue(ServerTags.FAIL_ALL_CONNECTIONS));
    }

    public void setFailAllConnections(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.FAIL_ALL_CONNECTIONS, "" + bl, bl2);
    }

    public void setFailAllConnections(boolean bl) {
        this.setAttributeValue(ServerTags.FAIL_ALL_CONNECTIONS, "" + bl);
    }

    protected String getRelativeXPath() {
        String string = null;
        string = "jdbc-connection-pool[@name='" + this.getAttributeValue("name") + "']";
        return string;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator beanComparator) {
        comparators.add(beanComparator);
    }

    public static void removeComparator(BeanComparator beanComparator) {
        comparators.remove(beanComparator);
    }

    public static String getDefaultAttributeValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(ServerTags.STEADY_POOL_SIZE)) {
            return "8";
        }
        if (string.equals(ServerTags.MAX_POOL_SIZE)) {
            return "32";
        }
        if (string.equals(ServerTags.MAX_WAIT_TIME_IN_MILLIS)) {
            return "60000";
        }
        if (string.equals(ServerTags.POOL_RESIZE_QUANTITY)) {
            return "2";
        }
        if (string.equals(ServerTags.IDLE_TIMEOUT_IN_SECONDS)) {
            return "300";
        }
        if (string.equals(ServerTags.IS_ISOLATION_LEVEL_GUARANTEED)) {
            return "true";
        }
        if (string.equals(ServerTags.IS_CONNECTION_VALIDATION_REQUIRED)) {
            return "false";
        }
        if (string.equals(ServerTags.CONNECTION_VALIDATION_METHOD)) {
            return "auto-commit";
        }
        if (string.equals(ServerTags.FAIL_ALL_CONNECTIONS)) {
            return "false";
        }
        return null;
    }

    public static String getDefaultSteadyPoolSize() {
        return "8";
    }

    public static String getDefaultMaxPoolSize() {
        return "32";
    }

    public static String getDefaultMaxWaitTimeInMillis() {
        return "60000";
    }

    public static String getDefaultPoolResizeQuantity() {
        return "2";
    }

    public static String getDefaultIdleTimeoutInSeconds() {
        return "300";
    }

    public static String getDefaultIsIsolationLevelGuaranteed() {
        return "true";
    }

    public static String getDefaultIsConnectionValidationRequired() {
        return "false";
    }

    public static String getDefaultConnectionValidationMethod() {
        return "auto-commit";
    }

    public static String getDefaultFailAllConnections() {
        return "false";
    }

    public void dump(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
        stringBuffer.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + i + ":");
            ElementProperty elementProperty = this.getElementProperty(i);
            if (elementProperty != null) {
                elementProperty.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, stringBuffer, string);
        }
    }

    public String dumpBeanNode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JdbcConnectionPool\n");
        this.dump(stringBuffer, "\n  ");
        return stringBuffer.toString();
    }
}

