/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config.serverbeans;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.StaleWriteConfigException;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.Ssl;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class HttpListener
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String SSL = "Ssl";

    public HttpListener() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public HttpListener(int n) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("ssl", SSL, 66064, Ssl.class);
        this.createAttribute(SSL, "cert-nickname", "CertNickname", 257, null, null);
        this.createAttribute(SSL, "ssl2-enabled", "Ssl2Enabled", 1, null, "false");
        this.createAttribute(SSL, "ssl2-ciphers", "Ssl2Ciphers", 513, null, null);
        this.createAttribute(SSL, "ssl3-enabled", "Ssl3Enabled", 1, null, "true");
        this.createAttribute(SSL, "ssl3-tls-ciphers", "Ssl3TlsCiphers", 513, null, null);
        this.createAttribute(SSL, "tls-enabled", "TlsEnabled", 1, null, "true");
        this.createAttribute(SSL, "tls-rollback-enabled", "TlsRollbackEnabled", 1, null, "true");
        this.createAttribute(SSL, "client-auth-enabled", "ClientAuthEnabled", 1, null, "false");
        this.initialize(n);
    }

    void initialize(int n) {
    }

    public void setSsl(Ssl ssl) {
        this.setValue(SSL, ssl);
    }

    public Ssl getSsl() {
        return (Ssl)this.getValue(SSL);
    }

    public String getId() {
        return this.getAttributeValue(ServerTags.ID);
    }

    public void setId(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ID, string, bl);
    }

    public void setId(String string) {
        this.setAttributeValue(ServerTags.ID, string);
    }

    public String getAddress() {
        return this.getAttributeValue(ServerTags.ADDRESS);
    }

    public void setAddress(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ADDRESS, string, bl);
    }

    public void setAddress(String string) {
        this.setAttributeValue(ServerTags.ADDRESS, string);
    }

    public String getPort() {
        return this.getAttributeValue(ServerTags.PORT);
    }

    public void setPort(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.PORT, string, bl);
    }

    public void setPort(String string) {
        this.setAttributeValue(ServerTags.PORT, string);
    }

    public String getFamily() {
        return this.getAttributeValue(ServerTags.FAMILY);
    }

    public void setFamily(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.FAMILY, string, bl);
    }

    public void setFamily(String string) {
        this.setAttributeValue(ServerTags.FAMILY, string);
    }

    public String getAcceptorThreads() {
        return this.getAttributeValue(ServerTags.ACCEPTOR_THREADS);
    }

    public void setAcceptorThreads(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ACCEPTOR_THREADS, string, bl);
    }

    public void setAcceptorThreads(String string) {
        this.setAttributeValue(ServerTags.ACCEPTOR_THREADS, string);
    }

    public boolean isBlockingEnabled() {
        return HttpListener.toBoolean(this.getAttributeValue(ServerTags.BLOCKING_ENABLED));
    }

    public void setBlockingEnabled(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.BLOCKING_ENABLED, "" + bl, bl2);
    }

    public void setBlockingEnabled(boolean bl) {
        this.setAttributeValue(ServerTags.BLOCKING_ENABLED, "" + bl);
    }

    public boolean isSecurityEnabled() {
        return HttpListener.toBoolean(this.getAttributeValue(ServerTags.SECURITY_ENABLED));
    }

    public void setSecurityEnabled(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.SECURITY_ENABLED, "" + bl, bl2);
    }

    public void setSecurityEnabled(boolean bl) {
        this.setAttributeValue(ServerTags.SECURITY_ENABLED, "" + bl);
    }

    public String getDefaultVirtualServer() {
        return this.getAttributeValue(ServerTags.DEFAULT_VIRTUAL_SERVER);
    }

    public void setDefaultVirtualServer(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DEFAULT_VIRTUAL_SERVER, string, bl);
    }

    public void setDefaultVirtualServer(String string) {
        this.setAttributeValue(ServerTags.DEFAULT_VIRTUAL_SERVER, string);
    }

    public String getServerName() {
        return this.getAttributeValue(ServerTags.SERVER_NAME);
    }

    public void setServerName(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.SERVER_NAME, string, bl);
    }

    public void setServerName(String string) {
        this.setAttributeValue(ServerTags.SERVER_NAME, string);
    }

    public boolean isEnabled() {
        return HttpListener.toBoolean(this.getAttributeValue(ServerTags.ENABLED));
    }

    public void setEnabled(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ENABLED, "" + bl, bl2);
    }

    public void setEnabled(boolean bl) {
        this.setAttributeValue(ServerTags.ENABLED, "" + bl);
    }

    protected String getRelativeXPath() {
        String string = null;
        string = "http-listener[@id='" + this.getAttributeValue("id") + "']";
        return string;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator beanComparator) {
        comparators.add(beanComparator);
    }

    public static void removeComparator(BeanComparator beanComparator) {
        comparators.remove(beanComparator);
    }

    public static String getDefaultAttributeValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(ServerTags.ACCEPTOR_THREADS)) {
            return "1";
        }
        if (string.equals(ServerTags.BLOCKING_ENABLED)) {
            return "false";
        }
        if (string.equals(ServerTags.SECURITY_ENABLED)) {
            return "false";
        }
        if (string.equals(ServerTags.ENABLED)) {
            return "true";
        }
        return null;
    }

    public static String getDefaultAcceptorThreads() {
        return "1";
    }

    public static String getDefaultBlockingEnabled() {
        return "false";
    }

    public static String getDefaultSecurityEnabled() {
        return "false";
    }

    public static String getDefaultEnabled() {
        return "true";
    }

    public void dump(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
        stringBuffer.append(SSL);
        Ssl ssl = this.getSsl();
        if (ssl != null) {
            ssl.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(SSL, 0, stringBuffer, string);
    }

    public String dumpBeanNode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HttpListener\n");
        this.dump(stringBuffer, "\n  ");
        return stringBuffer.toString();
    }
}

