/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config.serverbeans;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.StaleWriteConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.IiopCluster;
import com.iplanet.ias.config.serverbeans.PersistenceStore;
import com.iplanet.ias.config.serverbeans.ServerTags;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class AvailabilityService
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String IIOP_CLUSTER = "IiopCluster";
    public static final String PERSISTENCE_STORE = "PersistenceStore";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public AvailabilityService() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public AvailabilityService(int n) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("iiop-cluster", IIOP_CLUSTER, 66064, IiopCluster.class);
        this.createProperty("persistence-store", PERSISTENCE_STORE, 66064, PersistenceStore.class);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(n);
    }

    void initialize(int n) {
    }

    public void setIiopCluster(IiopCluster iiopCluster) {
        this.setValue(IIOP_CLUSTER, iiopCluster);
    }

    public IiopCluster getIiopCluster() {
        return (IiopCluster)this.getValue(IIOP_CLUSTER);
    }

    public int removeIiopCluster(IiopCluster iiopCluster) {
        return this.removeValue(IIOP_CLUSTER, iiopCluster);
    }

    public void setPersistenceStore(PersistenceStore persistenceStore) {
        this.setValue(PERSISTENCE_STORE, persistenceStore);
    }

    public PersistenceStore getPersistenceStore() {
        return (PersistenceStore)this.getValue(PERSISTENCE_STORE);
    }

    public void setElementProperty(int n, ElementProperty elementProperty) {
        this.setValue(ELEMENT_PROPERTY, n, elementProperty);
    }

    public ElementProperty getElementProperty(int n) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, n);
    }

    public void setElementProperty(ElementProperty[] elementPropertyArray) {
        this.setValue(ELEMENT_PROPERTY, elementPropertyArray);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty elementProperty) throws ConfigException {
        return this.addElementProperty(elementProperty, true);
    }

    public int addElementProperty(ElementProperty elementProperty, boolean bl) throws ConfigException {
        ElementProperty elementProperty2 = this.getElementPropertyByName(elementProperty.getName());
        if (elementProperty2 != null) {
            throw new ConfigException("ElementProperty Already Exists: cannot add duplicate");
        }
        return this.addValue(ELEMENT_PROPERTY, elementProperty, bl);
    }

    public int removeElementProperty(ElementProperty elementProperty) {
        return this.removeValue(ELEMENT_PROPERTY, elementProperty);
    }

    public int removeElementProperty(ElementProperty elementProperty, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, elementProperty, bl);
    }

    public ElementProperty getElementPropertyByName(String string) {
        ElementProperty[] elementPropertyArray = this.getElementProperty();
        if (elementPropertyArray == null) {
            return null;
        }
        for (int i = 0; i < elementPropertyArray.length; ++i) {
            if (!elementPropertyArray[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(string)) continue;
            return elementPropertyArray[i];
        }
        return null;
    }

    public boolean isAvailabilityEnabled() {
        return AvailabilityService.toBoolean(this.getAttributeValue(ServerTags.AVAILABILITY_ENABLED));
    }

    public void setAvailabilityEnabled(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.AVAILABILITY_ENABLED, "" + bl, bl2);
    }

    public void setAvailabilityEnabled(boolean bl) {
        this.setAttributeValue(ServerTags.AVAILABILITY_ENABLED, "" + bl);
    }

    protected String getRelativeXPath() {
        String string = null;
        string = "availability-service";
        return string;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator beanComparator) {
        comparators.add(beanComparator);
    }

    public static void removeComparator(BeanComparator beanComparator) {
        comparators.remove(beanComparator);
    }

    public static String getDefaultAttributeValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(ServerTags.AVAILABILITY_ENABLED)) {
            return "false";
        }
        return null;
    }

    public static String getDefaultAvailabilityEnabled() {
        return "false";
    }

    public void dump(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
        stringBuffer.append(IIOP_CLUSTER);
        ConfigBean configBean = this.getIiopCluster();
        if (configBean != null) {
            configBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(IIOP_CLUSTER, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append(PERSISTENCE_STORE);
        configBean = this.getPersistenceStore();
        if (configBean != null) {
            configBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(PERSISTENCE_STORE, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + i + ":");
            configBean = this.getElementProperty(i);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, stringBuffer, string);
        }
    }

    public String dumpBeanNode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AvailabilityService\n");
        this.dump(stringBuffer, "\n  ");
        return stringBuffer.toString();
    }
}

