/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config;

import com.iplanet.ias.admin.audit.ASAuditUtil;
import com.iplanet.ias.config.ConfigAdd;
import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigChange;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.ConfigContextEventListener;
import com.iplanet.ias.config.ConfigDelete;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.ConfigSet;
import com.iplanet.ias.config.ConfigUpdate;
import com.iplanet.ias.config.StaleWriteConfigException;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import org.netbeans.modules.schema2beans.BaseBean;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigContextImpl
implements ConfigContext,
Serializable,
Cloneable {
    private static final boolean INITIALIZE_XPATH = true;
    private static final boolean LOAD_PERSISTENT_CONFIG_CHANGES = true;
    private static final long INVALID_LAST_MODIFIED = -1L;
    private static final long UNINITIALIZED_LAST_MODIFIED = 0L;
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.config");
    protected transient Vector listeners = null;
    private ConfigBean server;
    protected String xmlUrl;
    private transient long lastModified = 0L;
    private boolean readOnly = false;
    private boolean autoCommit = false;
    private Class rootClass;
    private boolean isAdministered = false;
    private DefaultHandler defaultHandler = null;
    private transient ArrayList configChangeList = new ArrayList();
    private static final String PRE_CHANGE = "PRE_CHANGE";
    private static final String POST_CHANGE = "POST_CHANGE";

    public ArrayList getConfigChangeList() {
        return this.configChangeList;
    }

    public boolean isAdministered() {
        return this.isAdministered;
    }

    public void setIsAdministered(boolean bl) {
        this.isAdministered = bl;
    }

    public synchronized void resetConfigChangeList() {
        this.configChangeList = new ArrayList();
        this.clearPersistentConfigChanges();
        this.isAdministered = true;
    }

    public synchronized void addToConfigChangeList(String string, String string2, String string3, String string4) {
        if (!this.isAdministered) {
            return;
        }
        try {
            if (string3 == null && string4 == null) {
                return;
            }
            if (string3 != null && string3.equals(string4)) {
                return;
            }
            boolean bl = false;
            for (int i = 0; i < this.configChangeList.size(); ++i) {
                if (!((ConfigChange)this.configChangeList.get(i)).getConfigChangeType().equals("update") || !((ConfigUpdate)this.configChangeList.get(i)).getXPath().equals(string)) continue;
                ((ConfigUpdate)this.configChangeList.get(i)).addChangedAttribute(string2, string3, string4);
                this.persistConfigChanges();
                ASAuditUtil.logGenericEvent(this.getRootConfigBean().getAttributeValue("name") + ":" + string + "." + string2, string4, "update", 0);
                bl = true;
                break;
            }
            if (!bl) {
                this.configChangeList.add(new ConfigUpdate(string, string2, string3, string4));
                this.persistConfigChanges();
                ASAuditUtil.logGenericEvent(this.getRootConfigBean().getAttributeValue("name") + ":" + string + "." + string2, string4, "update", 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    ConfigContextImpl(String string, boolean bl, boolean bl2, Class clazz, DefaultHandler defaultHandler) {
        this.xmlUrl = string;
        this.readOnly = bl;
        this.autoCommit = bl2;
        this.rootClass = clazz;
        this.defaultHandler = defaultHandler;
    }

    public synchronized ConfigBean getRootConfigBean() throws ConfigException {
        if (this.server == null) {
            this.refresh();
        }
        return this.server;
    }

    String getXmlUrl() {
        return this.xmlUrl;
    }

    public ConfigBean exactLookup(String string) throws ConfigException {
        if (this.server == null) {
            this.refresh();
        }
        return ConfigFactory.getConfigBeanByXPath(this, string);
    }

    public ConfigBean[] lookup(String string) throws ConfigException {
        return null;
    }

    private void assertReadOnly() throws ConfigException {
        if (this.readOnly) {
            throw new ConfigException("Read only: you cannot write");
        }
    }

    public synchronized void flush(boolean bl) throws ConfigException {
        if (!bl && this.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigContext Flush failed: File Changed Externally");
        }
        ConfigContextEvent configContextEvent = new ConfigContextEvent(this, "PRE_FLUSH_CHANGE");
        this.preChange(configContextEvent);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.xmlUrl);
            this.server.write(fileOutputStream);
        }
        catch (Exception exception) {
            throw new ConfigException("Error Flushing ConfigContext");
        }
        this.initLastModified();
        configContextEvent = new ConfigContextEvent(this, "POST_FLUSH_CHANGE");
        this.postChange(configContextEvent);
    }

    public void flush() throws ConfigException {
        this.flush(true);
    }

    public synchronized void refresh(boolean bl) throws ConfigException {
        try {
            if (!bl && this.isChanged()) {
                throw new ConfigException("ConfigContext has changed in Memory. cannot refresh");
            }
            FileInputStream fileInputStream = new FileInputStream(this.xmlUrl);
            this.server = this.defaultHandler != null ? (ConfigBean)BaseBean.createGraph((Class)this.rootClass, (InputStream)fileInputStream, (boolean)true, (EntityResolver)this.defaultHandler, (ErrorHandler)this.defaultHandler) : (ConfigBean)BaseBean.createGraph((Class)this.rootClass, (InputStream)fileInputStream, (boolean)true);
            this.initConfigChanges();
            this.initLastModified();
            if (!this.readOnly) {
                this.setXPathInAllBeans();
            }
            this.setIsAdministered(true);
        }
        catch (Exception exception) {
            throw new ConfigException("Error refreshing ConfigContext", exception);
        }
    }

    private void setXPathInAllBeans() throws ConfigException {
        if (this.readOnly) {
            return;
        }
        ConfigBean configBean = this.getRootConfigBean();
        _logger.fine("Setting xpath for the whole tree");
        this.setXPathInTree(configBean, "");
        _logger.fine("Finished setting xpath for the whole tree");
    }

    private void setXPathInTree(ConfigBean configBean, String string) {
        configBean.setConfigContext(this);
        String string2 = configBean.getAbsoluteXPath(string);
        _logger.finer("   " + configBean.name() + " " + string2);
        configBean.setXPath(string2);
        ConfigBean[] configBeanArray = configBean.getAllChildBeans();
        if (configBeanArray == null || configBeanArray.length <= 0) {
            return;
        }
        for (int i = 0; i < configBeanArray.length; ++i) {
            if (configBeanArray[i] == null) continue;
            _logger.finest("Child " + configBeanArray[i].name());
            try {
                this.setXPathInTree(configBeanArray[i], configBean.getXPath());
                continue;
            }
            catch (Throwable throwable) {
                _logger.fine("Error: Cannot setXpath for " + configBeanArray[i].name());
                _logger.fine("Error: Xpath is " + configBean.getXPath());
                _logger.fine("Error: Exception is: " + throwable.getMessage());
                _logger.fine("Error: Continuing with rest of settings");
            }
        }
    }

    public void cleanup() {
        _logger.fine("Cleaning up config context");
        if (this.server != null) {
            this.cleanup(this.server);
        }
        _logger.fine("Finished setting xpath for the whole tree");
        this.server = null;
    }

    private void cleanup(ConfigBean configBean) {
        configBean.cleanup();
        _logger.finer("   " + configBean.name() + " cleaned up");
        ConfigBean[] configBeanArray = configBean.getAllChildBeans();
        if (configBeanArray == null || configBeanArray.length <= 0) {
            return;
        }
        for (int i = 0; i < configBeanArray.length; ++i) {
            if (configBeanArray[i] == null) continue;
            _logger.finest("Child " + configBeanArray[i].name());
            try {
                this.cleanup(configBeanArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                _logger.fine("Warning: Cannot cleanup configbean " + configBeanArray[i].name());
                _logger.fine("Warning: Exception is: " + throwable.getMessage());
                _logger.fine("Warning: Continuing with rest of settings");
            }
        }
    }

    public void refresh() throws ConfigException {
        this.refresh(true);
    }

    public Object clone() {
        ConfigContextImpl configContextImpl = new ConfigContextImpl(this.xmlUrl, false, false, this.rootClass, this.defaultHandler);
        configContextImpl.setRootConfigBean((ConfigBean)this.server.clone());
        return configContextImpl;
    }

    void setRootConfigBean(ConfigBean configBean) {
        this.server = configBean;
    }

    public synchronized void addToConfigChangeList(String string, String string2, String string3, ConfigBean configBean) {
        if (!this.isAdministered) {
            return;
        }
        try {
            this.configChangeList.add(new ConfigAdd(string, string2, string3, configBean));
            this.persistConfigChanges();
            ASAuditUtil.logGenericEvent(this.getRootConfigBean().getAttributeValue("name") + ":" + string2 + "." + string3, "", "add", 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void addToConfigChangeList(String string) {
        if (!this.isAdministered) {
            return;
        }
        try {
            if (!this.removeOtherConfigChanges(string)) {
                this.configChangeList.add(new ConfigDelete(string));
            }
            this.persistConfigChanges();
            ASAuditUtil.logGenericEvent(this.getRootConfigBean().getAttributeValue("name") + ":" + string, "", "delete", 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean removeOtherConfigChanges(String string) {
        boolean bl = false;
        try {
            Iterator iterator = this.configChangeList.iterator();
            while (iterator.hasNext()) {
                ConfigChange configChange = (ConfigChange)iterator.next();
                if (string.indexOf(configChange.getXPath()) < 0) continue;
                if (configChange instanceof ConfigAdd) {
                    bl = true;
                }
                iterator.remove();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public synchronized void addToConfigChangeList(String string, String string2, Object object, Object[] objectArray) {
        if (!this.isAdministered) {
            return;
        }
        this.configChangeList.add(new ConfigSet(string, string2, object, objectArray));
        this.persistConfigChanges();
    }

    public synchronized void removeConfigChange(ConfigChange configChange) {
        if (!this.isAdministered) {
            return;
        }
        int n = this.configChangeList.indexOf(configChange);
        if (n != -1) {
            this.configChangeList.remove(n);
        }
        this.persistConfigChanges();
    }

    public synchronized void updateFromConfigChange(ConfigChange configChange) throws ConfigException {
        if (configChange == null) {
            return;
        }
        boolean bl = this.isAdministered;
        this.isAdministered = false;
        if (configChange.getConfigChangeType().equals("add")) {
            this.updateFromConfigAdd((ConfigAdd)configChange);
        } else if (configChange.getConfigChangeType().equals("update")) {
            this.updateFromConfigUpdate((ConfigUpdate)configChange);
        } else if (configChange.getConfigChangeType().equals("delete")) {
            this.updateFromConfigDelete((ConfigDelete)configChange);
        } else if (configChange.getConfigChangeType().equals("set")) {
            this.updateFromConfigSet((ConfigSet)configChange);
        }
        this.isAdministered = bl;
    }

    private void updateFromConfigAdd(ConfigAdd configAdd) throws ConfigException {
        ConfigBean configBean = ConfigFactory.getConfigBeanByXPath(this, configAdd.getParentXPath());
        if (configBean == null) {
            throw new ConfigException("updateFromConfigAdd: Cannot find parent");
        }
        ConfigBean configBean2 = configAdd.getConfigBean();
        if (configBean2 == null) {
            throw new ConfigException("updateFromConfigAdd: Cannot find root bean");
        }
        ConfigBean configBean3 = ConfigBeansFactory.getConfigBeanByXPath(configBean2, configAdd.getXPath());
        if (configBean3 == null) {
            throw new ConfigException("updateFromConfigAdd: Cannot find childBean");
        }
        configBean3 = (ConfigBean)configBean3.clone();
        configBean.addValue(configAdd.getName(), configBean3);
    }

    private void updateFromConfigSet(ConfigSet configSet) throws ConfigException {
    }

    private void updateFromConfigUpdate(ConfigUpdate configUpdate) throws ConfigException {
        ConfigBean configBean = ConfigFactory.getConfigBeanByXPath(this, configUpdate.getXPath());
        if (configBean == null) {
            throw new ConfigException("updateFromConfigUpdate:Could not find ConfigBean to update");
        }
        Set set = configUpdate.getAttributeSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            configBean.setAttributeValue(string, configUpdate.getNewValue(string));
        }
    }

    private void updateFromConfigDelete(ConfigDelete configDelete) throws ConfigException {
        String string = configDelete.getXPath();
        ConfigBean configBean = ConfigFactory.getConfigBeanByXPath(this, string);
        if (configBean != null) {
            ConfigBean configBean2 = (ConfigBean)configBean.parent();
            configBean2.removeChild(configBean);
        }
    }

    public String toString() {
        if (this.server == null) {
            return "null bean";
        }
        return this.server.dumpBeanNode();
    }

    public String getAttributeValue(String string, String string2) {
        ConfigBean configBean = null;
        try {
            configBean = this.exactLookup(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configBean != null) {
            return configBean.getAttributeValue(string2);
        }
        return null;
    }

    public boolean getBooleanAttributeValue(String string, String string2) {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return false;
        }
        return string3.equals("true");
    }

    public boolean isChanged() {
        return this.configChangeList != null && this.configChangeList.size() != 0;
    }

    private long getLastModified() {
        long l = -1L;
        try {
            File file = new File(this.xmlUrl);
            l = file.lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public boolean isFileChangedExternally() {
        return this.getLastModified() != this.lastModified;
    }

    private void initLastModified() {
        this.lastModified = this.getLastModified();
    }

    public boolean equals(Object object) {
        try {
            if (this.getRootConfigBean().equals(((ConfigContext)object).getRootConfigBean())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private String getConfigChangeUrl() {
        return this.xmlUrl + ".changes";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistConfigChanges() {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.getConfigChangeUrl());
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.configChangeList);
            objectOutputStream.flush();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                objectOutputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfigChanges() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.getConfigChangeUrl());
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.configChangeList = (ArrayList)objectInputStream.readObject();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private void clearPersistentConfigChanges() {
        try {
            File file = new File(this.getConfigChangeUrl());
            file.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addConfigContextEventListener(ConfigContextEventListener configContextEventListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(configContextEventListener);
    }

    public void removeConfigContextEventListener(ConfigContextEventListener configContextEventListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.removeElement(configContextEventListener);
    }

    public void preChange(ConfigContextEvent configContextEvent) {
        this.change(PRE_CHANGE, configContextEvent);
    }

    public void postChange(ConfigContextEvent configContextEvent) {
        this.change(POST_CHANGE, configContextEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(String string, ConfigContextEvent configContextEvent) {
        if (this.listeners == null) {
            return;
        }
        String string2 = configContextEvent.getType();
        Vector vector = null;
        Object object = this.listeners;
        synchronized (object) {
            vector = (Vector)this.listeners.clone();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            ConfigContextEventListener configContextEventListener = (ConfigContextEventListener)object.nextElement();
            if (string.equals(PRE_CHANGE)) {
                if (string2.equals("PRE_ACCESS") || string2.equals("POST_ACCESS")) {
                    configContextEventListener.preAccessNotification(configContextEvent);
                    continue;
                }
                configContextEventListener.preChangeNotification(configContextEvent);
                continue;
            }
            if (string2.equals("PRE_ACCESS") || string2.equals("POST_ACCESS")) {
                configContextEventListener.postAccessNotification(configContextEvent);
                continue;
            }
            configContextEventListener.postChangeNotification(configContextEvent);
        }
    }
}

