/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.StaleWriteConfigException;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.GenBeans;

public abstract class ConfigBean
extends BaseBean
implements Serializable {
    private static final String DESCRIPTION = "description";
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.config");
    protected transient ConfigContext ctx = null;
    private String xpath;
    protected static StringManager localStrings = StringManager.getManager(ConfigBean.class);

    public void setXPath(String string) {
        this.xpath = string;
    }

    String getXPath() {
        return this.xpath;
    }

    ConfigContext getConfigContext() {
        return this.ctx;
    }

    public void setConfigContext(ConfigContext configContext) {
        this.ctx = configContext;
    }

    void cleanup() {
        this.ctx = null;
    }

    public ConfigBean() {
    }

    public ConfigBean(Vector vector, GenBeans.Version version) {
        super(vector, version);
    }

    public static boolean toBoolean(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("yes")) {
            return true;
        }
        if (string.equals("on")) {
            return true;
        }
        return string.equals("1");
    }

    public void setAttributeValue(String string, String string2) {
        try {
            this.setAttributeValue(string, string2, true);
        }
        catch (StaleWriteConfigException staleWriteConfigException) {
            // empty catch block
        }
    }

    public void setAttributeValue(String string, String string2, boolean bl) throws StaleWriteConfigException {
        if (!bl && this.ctx != null && this.ctx.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigBean: cannot change since FileChangedExternally");
        }
        if (string != null && string.equals(DESCRIPTION)) {
            super.setValue(DESCRIPTION, (Object)string2);
        } else {
            ConfigContextEvent configContextEvent;
            String string3 = "DONOTKNOW";
            if (this.ctx != null) {
                configContextEvent = new ConfigContextEvent(this.ctx, "PRE_UPDATE_CHANGE", string, string2, "UPDATE");
                configContextEvent.setBeanName(this.name());
                configContextEvent.setClassObject(this);
                this.ctx.preChange(configContextEvent);
                try {
                    string3 = this.getAttributeValue(string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            super.setAttributeValue(string, string2);
            if (this.ctx != null) {
                this.ctx.addToConfigChangeList(this.xpath, string, string3, string2);
                configContextEvent = new ConfigContextEvent(this.ctx, "POST_UPDATE_CHANGE", string, string2, "UPDATE");
                this.ctx.postChange(configContextEvent);
            }
        }
    }

    public Properties getBeanProperties() {
        return null;
    }

    public String getBeanDescription() {
        return null;
    }

    public ConfigBean[] getChildBeansByName(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("property")) {
            string = "element-property";
        }
        ConfigBean[] configBeanArray = null;
        try {
            configBeanArray = (ConfigBean[])this.getValues(string);
        }
        catch (Exception exception) {
            try {
                ConfigBean configBean = (ConfigBean)this.getValue(string);
                configBeanArray = new ConfigBean[]{configBean};
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return configBeanArray;
    }

    public ConfigBean[] getAllChildBeans() {
        ArrayList<ConfigBean> arrayList = new ArrayList<ConfigBean>();
        String[] stringArray = this.getChildBeanNames();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            ConfigBean[] configBeanArray = this.getChildBeansByName(stringArray[i]);
            if (configBeanArray == null) continue;
            for (int j = 0; j < configBeanArray.length; ++j) {
                arrayList.add(configBeanArray[j]);
            }
        }
        ConfigBean[] configBeanArray = new ConfigBean[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            configBeanArray[i] = (ConfigBean)arrayList.get(i);
        }
        return configBeanArray;
    }

    private String[] getChildBeanNames() {
        BaseProperty[] basePropertyArray = super.listProperties();
        if (basePropertyArray == null) {
            return null;
        }
        String[] stringArray = new String[basePropertyArray.length];
        for (int i = 0; i < basePropertyArray.length; ++i) {
            stringArray[i] = basePropertyArray[i].getDtdName();
        }
        return stringArray;
    }

    public int appendChild(ConfigBean configBean) throws ConfigException {
        return 0;
    }

    public int removeChild(ConfigBean configBean) throws ConfigException {
        return this.removeChild(configBean, true);
    }

    public int removeChild(ConfigBean configBean, boolean bl) throws ConfigException {
        if (!bl && this.ctx != null && this.ctx.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigBean: cannot change since FileChangedExternally");
        }
        if (configBean == null) {
            throw new ConfigException("Cannot remove null child");
        }
        return this.removeValue(configBean.name(), configBean);
    }

    public int addValue(String string, Object object) {
        int n = 0;
        try {
            n = this.addValue(string, object, true);
        }
        catch (StaleWriteConfigException staleWriteConfigException) {
            // empty catch block
        }
        return n;
    }

    public int addValue(String string, Object object, boolean bl) throws StaleWriteConfigException {
        if (!bl && this.ctx != null && this.ctx.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigBean: cannot change since FileChangedExternally");
        }
        if (this.ctx != null) {
            ConfigContextEvent configContextEvent = new ConfigContextEvent(this.ctx, "PRE_ADD_CHANGE", string, object, "ADD");
            configContextEvent.setClassObject(this);
            this.ctx.preChange(configContextEvent);
        }
        int n = super.addValue(string, object);
        if (this.ctx != null) {
            try {
                this.ctx.addToConfigChangeList(this.xpath, ((ConfigBean)object).getAbsoluteXPath(this.xpath), string, (ConfigBean)this.ctx.getRootConfigBean().clone());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ((ConfigBean)object).setConfigContext(this.ctx);
            ((ConfigBean)object).setXPath(((ConfigBean)object).getAbsoluteXPath(this.xpath));
            ConfigContextEvent configContextEvent = new ConfigContextEvent(this.ctx, "POST_ADD_CHANGE", string, object, "ADD");
            this.ctx.postChange(configContextEvent);
        }
        return n;
    }

    public int removeValue(String string, Object object) {
        int n = 0;
        try {
            n = this.removeValue(string, object, true);
        }
        catch (StaleWriteConfigException staleWriteConfigException) {
            // empty catch block
        }
        return n;
    }

    public int removeValue(String string, Object object, boolean bl) throws StaleWriteConfigException {
        if (!bl && this.ctx != null && this.ctx.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigBean: cannot change since FileChangedExternally");
        }
        if (this.ctx != null) {
            ConfigContextEvent configContextEvent = new ConfigContextEvent(this.ctx, "PRE_DELETE_CHANGE", string, object, "DELETE");
            configContextEvent.setClassObject(this);
            this.ctx.preChange(configContextEvent);
        }
        int n = super.removeValue(string, object);
        if (this.ctx != null) {
            this.ctx.addToConfigChangeList(((ConfigBean)object).getXPath());
            ConfigContextEvent configContextEvent = new ConfigContextEvent(this.ctx, "POST_DELETE_CHANGE", string, object, "DELETE");
            this.ctx.postChange(configContextEvent);
        }
        return n;
    }

    public void setValue(String string, Object object) {
        try {
            this.setValue(string, object, true);
        }
        catch (StaleWriteConfigException staleWriteConfigException) {
            // empty catch block
        }
    }

    public void setValue(String string, Object object, boolean bl) throws StaleWriteConfigException {
        ConfigContextEvent configContextEvent;
        if (!bl && this.ctx != null && this.ctx.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigBean: cannot change since FileChangedExternally");
        }
        if (this.ctx != null) {
            configContextEvent = new ConfigContextEvent(this.ctx, "PRE_SET_CHANGE", string, object, "SET");
            configContextEvent.setClassObject(this);
            this.ctx.preChange(configContextEvent);
        }
        super.setValue(string, object);
        if (this.ctx != null) {
            if (object instanceof ConfigBean) {
                this.ctx.addToConfigChangeList(this.xpath, string, ((ConfigBean)object).clone(), null);
                ((ConfigBean)object).setConfigContext(this.ctx);
                configContextEvent = new ConfigContextEvent(this.ctx, "POST_SET_CHANGE", string, object, "SET");
                this.ctx.postChange(configContextEvent);
            } else {
                this.ctx.addToConfigChangeList(this.xpath, string, object, null);
            }
        }
    }

    public void setValue(String string, Object[] objectArray) {
        super.setValue(string, objectArray);
        if (this.ctx != null) {
            this.ctx.addToConfigChangeList(this.xpath, string, null, objectArray);
        }
    }

    public static String getDefaultAttributeValueFromDtd(String string) {
        return ConfigBean.getDefaultAttributeValue(string);
    }

    public static String getDefaultAttributeValue(String string) {
        return null;
    }

    protected String getRelativeXPath() {
        return null;
    }

    public String getAbsoluteXPath(String string) {
        if (this.xpath != null) {
            return this.xpath;
        }
        String string2 = this.getRelativeXPath();
        if (string2 == null) {
            return null;
        }
        return string + "/" + this.getRelativeXPath();
    }

    public String getAttributeValue(String string) {
        Object object;
        if (string != null && string.equals(DESCRIPTION)) {
            return (String)super.getValue(DESCRIPTION);
        }
        if (this.ctx != null) {
            object = new ConfigContextEvent(this.ctx, "PRE_ACCESS");
            ((ConfigContextEvent)object).setClassObject(this);
            this.ctx.preChange((ConfigContextEvent)object);
        }
        object = super.getAttributeValue(string);
        if (this.ctx != null) {
            ConfigContextEvent configContextEvent = new ConfigContextEvent(this.ctx, "POST_ACCESS");
            this.ctx.postChange(configContextEvent);
        }
        return object;
    }

    public void dumpAttributes(String string, int n, StringBuffer stringBuffer, String string2) {
        String[] stringArray = this.getAttributeNames(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = null;
            string3 = stringArray[i].indexOf("Password") != -1 || stringArray[i].indexOf("UserName") != -1 ? "*****" : this.getAttributeValue(string, n, stringArray[i]);
            if (string3 == null) continue;
            stringBuffer.append(string2 + "\t  attr: ");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("=");
            stringBuffer.append(string3);
        }
    }

    public void changed() {
    }
}

