/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.connection;

import com.iplanet.ias.cis.LogWrap;
import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.ChannelManager;
import com.iplanet.ias.cis.channel.ServerChannel;
import com.iplanet.ias.cis.connection.ConnectException;
import com.iplanet.ias.cis.connection.Connection;
import com.iplanet.ias.cis.connection.EndPoint;
import java.util.logging.Level;

public class ServerConnection {
    private EndPoint endPoint = null;
    private ServerChannel serverChannel = null;
    private boolean isBlocking = true;
    private int backLog = 50;
    private boolean clientAuth = false;
    private boolean tlsRollback = false;
    private String certname = null;
    private static final int defaultBackLog = 50;
    private static ChannelManager channelManager = ChannelManager.getChannelManager();

    public ServerConnection(EndPoint endPoint, boolean bl, int n) throws ConnectException {
        try {
            this.serverChannel = channelManager.createServerChannel(endPoint, bl, n);
            if (this.serverChannel == null) {
                throw new ConnectException("Creation of ServerConnection failed");
            }
            this.endPoint = endPoint;
            this.isBlocking = bl;
            this.backLog = n;
        }
        catch (ChannelException channelException) {
            throw new ConnectException("Creation of ServerConnection failed : " + channelException.getMessage());
        }
    }

    public ServerConnection(EndPoint endPoint, boolean bl) throws ConnectException {
        this(endPoint, bl, 50);
    }

    public ServerConnection(EndPoint endPoint) throws ConnectException {
        this(endPoint, true, 50);
    }

    public ServerConnection(EndPoint endPoint, String string, int n, String[] stringArray, String[] stringArray2, boolean bl, int n2) throws ConnectException {
        try {
            this.serverChannel = channelManager.createServerChannel(endPoint, string, n, stringArray, stringArray2, bl, n2);
            if (this.serverChannel == null) {
                throw new ConnectException("Creation of ServerConnection failed");
            }
            this.endPoint = endPoint;
            this.isBlocking = true;
            this.backLog = n2;
            this.clientAuth = endPoint.getType().equals("SSL_MUTUALAUTH");
            this.tlsRollback = bl;
            this.certname = string;
        }
        catch (ChannelException channelException) {
            LogWrap.logger.log(Level.SEVERE, "", channelException);
            throw new ConnectException("Creation of ServerConnection failed : " + channelException.getMessage());
        }
    }

    public ServerConnection(EndPoint endPoint, String string, int n, String[] stringArray, String[] stringArray2, boolean bl) throws ConnectException {
        this(endPoint, string, n, stringArray, stringArray2, bl, 50);
    }

    public EndPoint getServerEndpoint() {
        return this.endPoint;
    }

    public boolean isClientAuthEnabled() {
        return this.clientAuth;
    }

    public boolean isTlsRollbackEnabled() {
        return this.tlsRollback;
    }

    public String getType() {
        return this.endPoint.getType();
    }

    public Connection accept() throws ConnectException {
        Connection connection = null;
        try {
            Channel channel = this.serverChannel.accept();
            if (channel == null) {
                throw new ConnectException("ServerConnection::Accept failed");
            }
            connection = this.endPoint.getType().equals("IIOP_CLEAR_TEXT") ? new Connection(channel, this.isBlocking) : (this.endPoint.getType().equals("SSL_MUTUALAUTH") ? new Connection(channel, this.certname, this.isBlocking, true, this.tlsRollback) : new Connection(channel, this.certname, this.isBlocking, false, this.tlsRollback));
            return connection;
        }
        catch (ChannelException channelException) {
            throw new ConnectException("ServerConnection::Accept failed : " + channelException.getMessage());
        }
    }

    public Connection accept(long l) throws ConnectException {
        Connection connection = null;
        try {
            Channel channel = this.serverChannel.accept(l);
            if (channel == null) {
                throw new ConnectException("ServerConnection::Accept failed");
            }
            connection = this.endPoint.getType().equals("IIOP_CLEAR_TEXT") ? new Connection(channel, this.isBlocking) : (this.endPoint.getType().equals("SSL_MUTUALAUTH") ? new Connection(channel, this.certname, this.isBlocking, true, this.tlsRollback) : new Connection(channel, this.certname, this.isBlocking, false, this.tlsRollback));
            return connection;
        }
        catch (ChannelException channelException) {
            throw new ConnectException("ServerConnection::Accept failed : " + channelException.getMessage());
        }
    }

    public void close() throws ConnectException {
        if (this.serverChannel == null) {
            return;
        }
        try {
            this.serverChannel.close();
            this.serverChannel = null;
        }
        catch (ChannelException channelException) {
            throw new ConnectException("ServerConnection::close failed : " + channelException.getMessage());
        }
    }
}

