/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.connection;

import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.connection.AbstractConnectionOutputStream;
import java.io.IOException;

public class NonBlockingConnectionOutputStream
extends AbstractConnectionOutputStream {
    public NonBlockingConnectionOutputStream(Channel channel) throws ChannelException {
        super(channel);
    }

    public int writeAsync(byte[] byArray) throws IOException {
        return this.writeAsync(byArray, 0, byArray.length);
    }

    public int writeAsync(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isValid) {
            throw new IOException("Stream already closed.");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return n2;
        }
        try {
            return this.channel.send(byArray, n, n2);
        }
        catch (ChannelException channelException) {
            throw new IOException("Data not fully sent.");
        }
    }
}

