/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.connection;

import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.tcp.TCPNativeException;
import java.net.InetAddress;

public class EndPoint {
    public static final String TCP = "IIOP_CLEAR_TEXT";
    public static final String SSL = "SSL";
    public static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    public static final String SSL_PERSISTENT = "PERSISTENT_SSL";
    protected static final String LOCAL_HOST = "localhost";
    private static final String colon = ":";
    private int address;
    private int family;
    private int hash;
    private String hostIP;
    private String hostName;
    private String type;
    private int port;
    private boolean ipv6Flag = false;

    public static EndPoint getEndPoint(String string, int n, boolean bl) throws ChannelException {
        return EndPoint.getEndPoint(null, string, n, bl);
    }

    public static EndPoint getEndPoint(String string, String string2, int n, boolean bl) throws ChannelException {
        return new EndPoint(string, string2, n, bl);
    }

    public static EndPoint getEndPoint(String string, String string2, int n) throws ChannelException {
        return EndPoint.getEndPoint(string, string2, n, false);
    }

    public static EndPoint getEndPoint(String string, int n) throws ChannelException {
        return EndPoint.getEndPoint(null, string, n, false);
    }

    public static EndPoint getLocalEndPoint(int n) throws ChannelException {
        return EndPoint.getEndPoint(null, LOCAL_HOST, n, false);
    }

    protected EndPoint(String string, String string2, int n, boolean bl) throws ChannelException {
        if (!(null == string || string.equals(TCP) || string.equals(SSL) || string.equals(SSL_MUTUALAUTH) || string.equals(SSL_PERSISTENT))) {
            throw new ChannelException("Type of Endpoint is illegal: " + string);
        }
        this.type = null == string ? TCP : string;
        this.port = n;
        this.ipv6Flag = bl;
        this.getValidAddress(string2, n, bl);
        this.hash = this.toString().hashCode();
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public InetAddress getInetAddress() throws ChannelException {
        try {
            return InetAddress.getByAddress(this.hostIP.getBytes());
        }
        catch (Exception exception) {
            throw new ChannelException(exception.getMessage());
        }
    }

    public String getType() {
        return this.type;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void updatePort(int n) {
        if (this.port == 0) {
            this.port = n;
        }
    }

    public boolean isIPv6() {
        return this.ipv6Flag;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("EndPoint [");
        stringBuffer.append(this.type);
        stringBuffer.append(colon);
        stringBuffer.append(this.hostIP);
        stringBuffer.append(colon);
        stringBuffer.append(this.port);
        stringBuffer.append(colon);
        stringBuffer.append(this.ipv6Flag);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isLocal() {
        return false;
    }

    private boolean isIPv4Address(String string) {
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return false;
            }
            int n3 = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return false;
                }
                n3 = n3 * 10 + c - 48;
                if (++i >= cArray.length) break;
                c = cArray[i];
            }
            if (n3 > 255) {
                return false;
            }
            n = (n << 8) + n3;
            ++n2;
        }
        return n2 == 4 && !string.endsWith(".");
    }

    public boolean isIPv6Address() {
        return this.ipv6Flag;
    }

    private void getValidAddress(String string, int n, boolean bl) throws ChannelException {
        if (n < 0 || n > 65535) {
            throw new ChannelException("Port value out of range: " + n);
        }
        if (string == null) {
            string = LOCAL_HOST;
        }
        this.getValidAddressNative(string);
    }

    private native void getHostByAddressNative(String var1, int var2) throws TCPNativeException;

    private native void getHostByNameNative(String var1, int var2) throws TCPNativeException;

    private native void getValidAddressNative(String var1) throws TCPNativeException;

    private static native void initNative();

    static {
        System.loadLibrary("cis");
        EndPoint.initNative();
    }
}

