/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.channel.ssl;

import com.iplanet.ias.cis.LogWrap;
import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.ssl.CipherUtils;
import com.iplanet.ias.cis.channel.ssl.SSLBlockingChannel;
import com.iplanet.ias.cis.channel.tcp.TCPBlockingServerChannel;
import com.iplanet.ias.cis.connection.EndPoint;
import java.util.logging.Level;

public class SSLBlockingServerChannel
extends TCPBlockingServerChannel {
    private boolean clientAuth = false;
    String certname;
    private int sslVersion;
    private String[] ssl2Ciphers;
    private String[] ssl3Ciphers;
    private boolean tlsRollback;

    public SSLBlockingServerChannel(EndPoint endPoint, String string, int n) throws ChannelException {
        super(endPoint, n);
        this.certname = string;
        if (endPoint.getType().equals("SSL_MUTUALAUTH")) {
            this.clientAuth = true;
        }
    }

    public SSLBlockingServerChannel(EndPoint endPoint, String string) throws ChannelException {
        super(endPoint);
        this.certname = string;
        if (endPoint.getType().equals("SSL_MUTUALAUTH")) {
            this.clientAuth = true;
        }
    }

    public SSLBlockingServerChannel(EndPoint endPoint, String string, int n, String[] stringArray, String[] stringArray2, boolean bl, int n2) throws ChannelException {
        this(endPoint, string, n2);
        this.sslVersion = n;
        this.ssl2Ciphers = stringArray;
        this.ssl3Ciphers = stringArray2;
        this.tlsRollback = bl;
    }

    public Channel accept() throws ChannelException {
        SSLBlockingChannel sSLBlockingChannel = new SSLBlockingChannel(this.certname, this.clientAuth, this.local.getType(), this.sslVersion, this.ssl2Ciphers, this.ssl3Ciphers, this.tlsRollback);
        sSLBlockingChannel.setType(this.local.getType());
        try {
            this.acceptNativeAll(sSLBlockingChannel, this.certname, this.clientAuth, -1, this.sslVersion, CipherUtils.getSsl2CipherIDs(this.ssl2Ciphers), CipherUtils.getSsl3CipherIDs(this.ssl3Ciphers), this.tlsRollback);
        }
        catch (ChannelException channelException) {
            LogWrap.logger.log(Level.SEVERE, "", channelException);
            throw channelException;
        }
        return sSLBlockingChannel;
    }

    public Channel accept(int n) throws ChannelException {
        Channel channel = null;
        return channel;
    }

    private native void acceptNative(SSLBlockingChannel var1, String var2, boolean var3, int var4);

    private native void acceptNativeAll(SSLBlockingChannel var1, String var2, boolean var3, int var4, int var5, int[] var6, int[] var7, boolean var8);

    private static native void initNative();

    static {
        System.loadLibrary("cis");
        SSLBlockingServerChannel.initNative();
    }
}

