/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.appclient;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.clientbeans.CertDb;
import com.iplanet.ias.config.clientbeans.ClientBeansFactory;
import com.iplanet.ias.config.clientbeans.ClientContainer;
import com.iplanet.ias.config.clientbeans.ClientCredential;
import com.iplanet.ias.config.clientbeans.ElementProperty;
import com.iplanet.ias.config.clientbeans.Security;
import com.iplanet.ias.config.clientbeans.Ssl;
import com.iplanet.ias.config.clientbeans.TargetServer;
import com.iplanet.ias.deployment.AppClientXmlReader;
import com.iplanet.ias.deployment.ApplicationXmlReader;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.appclient.HttpAuthenticator;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.security.GUIErrorDialog;
import com.sun.enterprise.security.KeyTool;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import com.sun.web.server.HttpsURLStreamHandlerFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;

public class Main {
    private static final String CLIENT = "-client";
    private static final String NAME = "-name";
    private static final String MAIN_CLASS = "-mainclass";
    private static final String TEXT_AUTH = "-textauth";
    private static final String XML_PATH = "-xml";
    private static final String ACC_CONFIG_XML = "-configxml";
    private static final String DEFAULT_CLIENT_CONTAINER_XML = "sun-acc.xml";
    private static final String CLIENT_XML_FULL_NAME = "com.iplanet.ias.appclient.ClientContainer";
    private static final String NO_APP_INVOKE = "-noappinvoke";
    private static final String USER = "-user";
    private static final String PASSWORD = "-password";
    private static final String LOGIN_NAME = "j2eelogin.name";
    private static final String LOGIN_PASSWORD = "j2eelogin.password";
    private static final String DASH = "-";
    private static Logger _logger;
    private static final String ORB_SSL_CERTDB_PATH = "com.sun.CORBA.ssl.CertDB";
    private static final String ORB_SSL_CERTDB_PASSWORD = "com.sun.CORBA.ssl.CertDBPassword";
    private static final String ORB_SSL_CLIENT_CERTNAME = "com.sun.CORBA.ssl.client.Certname";
    private static final String ORB_SSL_CLIENT_SSLVERSION = "com.sun.CORBA.ssl.client.SslVersion";
    private static final String ORB_SSL_CLIENT_SSL2CIPHERS = "com.sun.CORBA.ssl.client.Ssl2Ciphers";
    private static final String ORB_SSL_CLIENT_SSL3CIPHERS = "com.sun.CORBA.ssl.client.Ssl3Ciphers";
    private static final String ORB_SSL_CLIENT_TLSROLLBACK = "com.sun.CORBA.ssl.client.TlsRollback";
    private static final boolean debug = false;
    private static StringManager localStrings;
    private static boolean guiAuth;
    private static boolean runClient;

    public static void main(String[] stringArray) {
        new Main(stringArray);
    }

    public Main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        guiAuth = Boolean.valueOf(System.getProperty("auth.gui", "true"));
        if (stringArray.length < 1) {
            Main.usage();
        } else {
            while (n < stringArray.length) {
                if ((string = stringArray[n++]).equals(CLIENT)) {
                    if (n < stringArray.length && !stringArray[n].startsWith(DASH)) {
                        string2 = stringArray[n++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (string.equals(NAME) && !stringArray[n].startsWith(DASH)) {
                    if (n < stringArray.length && string4 == null) {
                        string3 = stringArray[n++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (string.equals(MAIN_CLASS) && !stringArray[n].startsWith(DASH)) {
                    if (n < stringArray.length && string3 == null) {
                        string4 = stringArray[n++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (string.equals(XML_PATH)) {
                    if (n < stringArray.length && string5 == null) {
                        string5 = stringArray[n++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (string.equals(ACC_CONFIG_XML)) {
                    if (n < stringArray.length && string6 == null) {
                        string6 = stringArray[n++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (string.equals(TEXT_AUTH)) {
                    guiAuth = false;
                    continue;
                }
                if (string.equals(NO_APP_INVOKE)) {
                    runClient = false;
                    continue;
                }
                if (string.equals(USER)) {
                    if (n < stringArray.length) {
                        System.setProperty(LOGIN_NAME, stringArray[n++]);
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (string.equals(PASSWORD)) {
                    if (n < stringArray.length) {
                        System.setProperty(LOGIN_PASSWORD, stringArray[n++]);
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                vector.add(string);
            }
        }
        if (string2 == null) {
            Main.usage();
        }
        if (string5 != null) {
            Main.validateXMLFile(string5);
        } else if (string6 != null) {
            Main.validateXMLFile(string6);
            string5 = string6;
        }
        if (string5 != null) {
            System.setProperty(CLIENT_XML_FULL_NAME, string5);
        }
        _logger = LogDomains.getLogger("javax.enterprise.system.container.appclient");
        _logger.info("\n---------AppClient Container--------\n");
        Utility.checkJVMVersion();
        J2EESecurityManager j2EESecurityManager = new J2EESecurityManager();
        System.setSecurityManager(j2EESecurityManager);
        KeyTool.initProvider();
        Main.setTagetServerProperties(string5);
        boolean bl = false;
        AppContainer appContainer = null;
        Cleanup cleanup = new Cleanup();
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(cleanup);
        try {
            String[] stringArray2;
            Serializable serializable;
            Object object;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL.setURLStreamHandlerFactory(new HttpsURLStreamHandlerFactory());
                    return null;
                }
            });
            File file = new File(string2);
            URL[] uRLArray = new URL[]{file.toURL()};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
            if (ApplicationArchivist.isApplication(file)) {
                object = null;
                try {
                    object = ApplicationXmlReader.loadApplicationClients(file, uRLClassLoader);
                }
                catch (Throwable throwable) {
                    _logger.log(Level.WARNING, "acc.failed_load_client_desc", string2);
                    throw throwable;
                }
                serializable = null;
                stringArray2 = ((Application)object).getApplicationClientDescriptors().iterator();
                while (stringArray2.hasNext()) {
                    ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)stringArray2.next();
                    if (string4 != null) {
                        if (!applicationClientDescriptor.getMainClassName().equals(string4)) {
                            applicationClientDescriptor.setMainClassName(string4);
                        }
                        serializable = applicationClientDescriptor;
                        break;
                    }
                    if (string3 != null && applicationClientDescriptor.getName().equals(string3)) {
                        if (serializable == null) {
                            serializable = applicationClientDescriptor;
                        } else {
                            _logger.log(Level.WARNING, "acc.duplicate_display_name");
                            System.exit(1);
                        }
                    }
                    if (string3 != null || string4 != null) continue;
                    if (serializable == null) {
                        serializable = applicationClientDescriptor;
                        continue;
                    }
                    _logger.log(Level.WARNING, "acc.mutiple_app_require_name");
                    System.exit(1);
                }
                if (serializable != null) {
                    appContainer = new AppContainer((ApplicationClientDescriptor)serializable, guiAuth);
                    file = new File(serializable.getArchivist().getArchiveCanonicalPath());
                }
            } else {
                object = null;
                try {
                    object = AppClientXmlReader.load(file, "");
                }
                catch (Throwable throwable) {
                    _logger.log(Level.WARNING, "main.appclient_descriptors_failed", string3 == null ? string4 : string3);
                    throw throwable;
                }
                appContainer = new AppContainer((ApplicationClientDescriptor)object, guiAuth);
            }
            if (appContainer == null) {
                _logger.log(Level.WARNING, "acc.no_client_desc", string3 == null ? string4 : string3);
                System.exit(1);
            }
            try {
                Class.forName("com.sun.appserv.ee.naming.EEInitialContextFactoryBuilder").getMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "", exception);
            }
            Authenticator.setDefault(new HttpAuthenticator(appContainer));
            _logger.log(Level.INFO, "acc.orb_host_name", System.getProperty("org.omg.CORBA.ORBInitialHost"));
            _logger.log(Level.INFO, "acc.orb_port_number", System.getProperty("org.omg.CORBA.ORBInitialPort"));
            object = appContainer.preInvoke();
            cleanup.setAppContainer(appContainer);
            serializable = uRLClassLoader.loadClass((String)object);
            _logger.log(Level.INFO, "acc.load_app_class", object);
            stringArray2 = new String[vector.size()];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = (String)vector.elementAt(i);
            }
            if (runClient) {
                Utility.invokeApplicationMain((Class)serializable, stringArray2);
                _logger.info("Application main() finished normally");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            _logger.log(Level.WARNING, "acc.app_exception", throwable);
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (throwable instanceof FailedLoginException) {
                _logger.info("acc.login_error");
                boolean bl2 = Boolean.valueOf(System.getProperty("auth.gui", "true"));
                String string7 = localStrings.getString("main.exception.loginError", "Incorrect login and/or password");
                if (bl2) {
                    GUIErrorDialog gUIErrorDialog = new GUIErrorDialog(string7);
                    gUIErrorDialog.show();
                }
            }
            _logger.log(Level.WARNING, "acc.app_exception", throwable);
            if (throwable instanceof NamingException) {
                _logger.log(Level.WARNING, "acc.naming_exception_received");
            }
            System.exit(1);
        }
    }

    private static void setTagetServerProperties(String string) {
        try {
            if (string == null || string.equals("")) {
                string = DEFAULT_CLIENT_CONTAINER_XML;
            }
            _logger.log(Level.INFO, "acc.using_xml_location", string);
            ConfigContext configContext = ConfigFactory.createConfigContext(string, true, false, true, ClientContainer.class, null);
            ClientContainer clientContainer = ClientBeansFactory.getClientBean(configContext);
            System.setProperty("org.omg.CORBA.ORBInitialHost", clientContainer.getTargetServer().getAddress());
            System.setProperty("org.omg.CORBA.ORBInitialPort", clientContainer.getTargetServer().getPort());
            String string2 = "com.sun.appserv.iiop.loadbalancingpolicy";
            ElementProperty elementProperty = clientContainer.getElementPropertyByName(string2);
            String string3 = null;
            if (elementProperty != null && (string3 = elementProperty.getValue()) != null && string3.length() != 0) {
                System.setProperty(string2, string3);
            }
            if ((elementProperty = clientContainer.getElementPropertyByName(string2 = "com.sun.appserv.iiop.endpoints")) != null && (string3 = elementProperty.getValue()) != null && string3.length() != 0) {
                System.setProperty(string2, string3);
            }
            Main.setSSLData(clientContainer);
            ClientCredential clientCredential = clientContainer.getClientCredential();
            if (clientCredential != null) {
                if (System.getProperty(LOGIN_NAME) == null) {
                    _logger.config("using login name from client container xml...");
                    System.setProperty(LOGIN_NAME, clientCredential.getUserName());
                }
                if (System.getProperty(LOGIN_PASSWORD) == null) {
                    _logger.config("using password from client container xml...");
                    System.setProperty(LOGIN_PASSWORD, clientCredential.getPassword());
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ConfigException) {
                _logger.log(Level.WARNING, "acc.acc_xml_file_error", string);
            } else {
                _logger.warning("acc.clientContainer_xml_not_found");
            }
            _logger.log(Level.FINE, "exception " + throwable.toString(), throwable);
        }
    }

    private static void setSSLData(ClientContainer clientContainer) {
        try {
            TargetServer targetServer = clientContainer.getTargetServer();
            Security security = targetServer.getSecurity();
            if (security == null) {
                _logger.fine("No Security input set in ClientContainer.xml");
                return;
            }
            Ssl ssl = security.getSsl();
            if (ssl == null) {
                _logger.fine("No SSL input set in ClientContainer.xml");
                return;
            }
            CertDb certDb = security.getCertDb();
            System.setProperty(ORB_SSL_CERTDB_PATH, certDb.getPath());
            System.setProperty(ORB_SSL_CERTDB_PASSWORD, certDb.getPassword());
            System.setProperty(ORB_SSL_CLIENT_CERTNAME, ssl.getCertNickname());
            int n = 0;
            if (ssl.isSsl2Enabled()) {
                ++n;
            }
            if (ssl.isSsl3Enabled()) {
                n += 2;
            }
            if (ssl.isTlsEnabled()) {
                n += 4;
            }
            System.setProperty(ORB_SSL_CLIENT_SSLVERSION, "" + n);
            System.setProperty(ORB_SSL_CLIENT_SSL2CIPHERS, ssl.getSsl2Ciphers());
            System.setProperty(ORB_SSL_CLIENT_SSL3CIPHERS, ssl.getSsl3TlsCiphers());
            System.setProperty(ORB_SSL_CLIENT_TLSROLLBACK, "" + ssl.isTlsRollbackEnabled());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setClientXMLLocation(String[] stringArray) {
        String string = DEFAULT_CLIENT_CONTAINER_XML;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(XML_PATH)) continue;
            string = stringArray[i + 1];
            break;
        }
        System.setProperty(CLIENT_XML_FULL_NAME, string);
    }

    private static void validateXMLFile(String string) {
        if (string == null || string.startsWith(DASH)) {
            Main.usage();
        }
        try {
            File file = new File(string);
            if (file != null && file.exists() && file.isFile() && file.canRead()) {
                return;
            }
            Main.xmlMessage(string);
            Main.usage();
        }
        catch (Exception exception) {
            Main.xmlMessage(string);
            Main.usage();
        }
    }

    private static File getClientJar(BundleDescriptor bundleDescriptor) throws IOException {
        String string = bundleDescriptor.getApplication().getName() + ".tmpjar";
        File file = new File(FileUtil.getTempDirectory(), string);
        file.deleteOnExit();
        bundleDescriptor.getApplication().getApplicationArchivist().extractBundleToFile(bundleDescriptor, file);
        return file;
    }

    private static void usage() {
        System.out.println(localStrings.getString("main.usage", "appclient -client <appjar> [-mainclass <appClass-name>|-name <display-name>] [-xml <xml>] [-textauth] [app-args]"));
        System.exit(1);
    }

    private static void xmlMessage(String string) {
        System.out.println(localStrings.getString("main.cannot_read_clientContainer_xml", string, "Client Container xml: " + string + " not found or unable to read.\nYou may want to use the -xml option to locate your configuration xml."));
    }

    static {
        localStrings = StringManager.getManager(Main.class);
        runClient = true;
    }

    private static class Cleanup
    extends Thread {
        private AppContainer appContainer = null;
        private boolean cleanedUp = false;

        public void setAppContainer(AppContainer appContainer) {
            this.appContainer = appContainer;
        }

        public void run() {
            this.cleanUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanUp() {
            if (!this.cleanedUp) {
                try {
                    if (this.appContainer != null) {
                        this.appContainer.postInvoke();
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.cleanedUp = true;
                }
            }
        }
    }
}

